/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public final class JstVar
extends BaseJstNode
implements ILHS,
IStmt {
    private static final long serialVersionUID = 1L;
    private IJstTypeReference m_typeRef;
    private final String m_name;

    public JstVar(IJstType type, String name) {
        assert (type != null) : "type is null";
        assert (name != null) : "name is null";
        this.m_typeRef = new JstTypeReference(type);
        this.addChild(this.m_typeRef);
        this.m_name = name;
    }

    public JstVar(IJstTypeReference typeRef, String name) {
        assert (typeRef != null) : "typeRef is null";
        assert (name != null) : "name is null";
        this.m_typeRef = typeRef;
        this.addChild(this.m_typeRef);
        this.m_name = name;
    }

    @Override
    public String toLHSText() {
        return "var " + this.m_name;
    }

    @Override
    public String toStmtText() {
        return String.valueOf(this.toLHSText()) + ";";
    }

    @Override
    public IJstType getType() {
        return this.m_typeRef.getReferencedType();
    }

    public void setType(IJstType type) {
        this.m_typeRef = new JstTypeReference(type);
    }

    public IJstTypeReference getTypeRef() {
        return this.m_typeRef;
    }

    public String getName() {
        return this.m_name;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        Z z = new Z();
        z.format("m_type", (Object)this.m_typeRef.getReferencedType());
        z.format("m_name", (Object)this.m_name);
        return z.toString();
    }
}

