/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.expr;

import java.util.ArrayList;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstInferredType;
import org.eclipse.vjet.dsf.jst.declaration.JstMixedType;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class ArrayAccessExpr
extends BaseJstNode
implements ILHS,
IExpr {
    private static final long serialVersionUID = 1L;
    private IExpr m_expr;
    private IExpr m_index;
    private IJstType m_type;

    public ArrayAccessExpr(IExpr expr) {
        this(expr, null);
    }

    public ArrayAccessExpr(IExpr expr, IExpr index) {
        assert (this.m_expr != null) : "m_expr is null";
        this.m_expr = expr;
        this.m_index = index;
        this.addChild(expr);
        this.addChild(index);
    }

    @Override
    public String toExprText() {
        StringBuilder sb = new StringBuilder();
        String e = null;
        if (this.m_expr != null) {
            e = this.m_expr.toExprText();
        }
        String i = null;
        if (this.m_index != null) {
            i = this.m_index.toExprText();
        }
        if (e != null) {
            sb.append(e);
        }
        sb.append("[");
        if (i != null) {
            sb.append(i);
        }
        sb.append("]");
        String text = sb.toString();
        return text.length() > 0 ? text : null;
    }

    @Override
    public String toLHSText() {
        return this.toExprText();
    }

    @Override
    public IJstType getResultType() {
        IJstType type;
        if (this.m_type != null) {
            return this.m_type;
        }
        if (this.m_expr != null && (type = this.m_expr.getResultType()) != null) {
            if (type instanceof JstMixedType) {
                JstMixedType mixed = (JstMixedType)type;
                ArrayList<IJstType> mixedComponentType = new ArrayList<IJstType>();
                for (IJstType mixedType : mixed.getMixedTypes()) {
                    IJstType foundJstArray = this.getComponentType(mixedType);
                    if (foundJstArray == null) continue;
                    mixedComponentType.add(foundJstArray);
                }
                return new JstMixedType(mixedComponentType);
            }
            return this.getComponentType(type);
        }
        return null;
    }

    private IJstType getComponentType(IJstType type) {
        if (type instanceof JstInferredType) {
            type = ((JstInferredType)type).getType();
        }
        if (type instanceof JstArray) {
            return ((JstArray)type).getComponentType();
        }
        return null;
    }

    @Override
    public IJstType getType() {
        return this.getResultType();
    }

    public void setType(IJstType type) {
        this.m_type = type;
    }

    public IExpr getIndex() {
        return this.m_index;
    }

    public IExpr getExpr() {
        return this.m_expr;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.toExprText();
    }
}

