/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.expr;

import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.token.IBoolExpr;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class ConditionalExpr
extends BaseJstNode
implements IExpr {
    private static final long serialVersionUID = 1L;
    private IBoolExpr m_cond;
    private IExpr m_then;
    private IExpr m_else;
    private IJstType m_resultType;

    public ConditionalExpr(IBoolExpr cond, IExpr thenExpr, IExpr elseExpr) {
        assert (cond != null) : "cond cannot be null";
        assert (thenExpr != null) : "thenExpr cannot be null";
        assert (elseExpr != null) : "elseExpr cannot be null";
        this.m_cond = cond;
        this.m_then = thenExpr;
        this.m_else = elseExpr;
        this.addChild(cond);
        this.addChild(this.m_then);
        this.addChild(this.m_else);
    }

    @Override
    public IJstType getResultType() {
        return this.m_resultType != null ? this.m_resultType : (this.m_then == null ? null : this.m_then.getResultType());
    }

    public void setResultType(IJstType resultType) {
        this.m_resultType = resultType;
    }

    @Override
    public String toExprText() {
        StringBuilder sb = new StringBuilder();
        if (this.m_cond != null) {
            sb.append(this.m_cond.toExprText());
        }
        sb.append("?");
        if (this.m_then != null) {
            sb.append(this.m_then.toExprText());
        }
        sb.append(":");
        if (this.m_else != null) {
            sb.append(this.m_else.toExprText());
        }
        return sb.toString();
    }

    public IBoolExpr getCondition() {
        return this.m_cond;
    }

    public IExpr getThenExpr() {
        return this.m_then;
    }

    public IExpr getElseExpr() {
        return this.m_else;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.toExprText();
    }
}

