/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.expr;

import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class PtyGetter
extends BaseJstNode
implements IExpr {
    private static final long serialVersionUID = 1L;
    private final JstIdentifier m_ptyName;
    private IExpr m_qualifyExpr;

    public PtyGetter(String ptyName) {
        this(new JstIdentifier(ptyName));
    }

    public PtyGetter(JstIdentifier ptyName) {
        this(ptyName, null);
    }

    public PtyGetter(JstIdentifier ptyName, IExpr qualifyExpr) {
        assert (ptyName != null) : "ptyName cannot be null";
        this.m_ptyName = ptyName;
        this.m_qualifyExpr = qualifyExpr;
        this.addChild(ptyName);
        this.addChild(qualifyExpr);
    }

    @Override
    public IJstType getResultType() {
        return this.m_ptyName == null ? null : this.m_ptyName.getType();
    }

    @Override
    public String toExprText() {
        String text;
        StringBuilder sb = new StringBuilder();
        String q = null;
        if (this.m_qualifyExpr != null) {
            q = this.m_qualifyExpr.toExprText();
        }
        String n = null;
        if (this.m_ptyName != null) {
            n = this.m_ptyName.toSimpleTermText();
        }
        if (q != null) {
            sb.append(q);
        }
        if (q != null && n != null) {
            sb.append(".");
        }
        if (n != null) {
            sb.append(n);
        }
        return (text = sb.toString()).length() > 0 ? text : null;
    }

    public JstIdentifier getPtyName() {
        return this.m_ptyName;
    }

    public void setQualifyExpr(IExpr qualifyExpr) {
        this.removeChild(this.m_qualifyExpr);
        this.addChild(qualifyExpr);
        this.m_qualifyExpr = qualifyExpr;
    }

    public IExpr getQualifyExpr() {
        return this.m_qualifyExpr;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.toExprText();
    }
}

