/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.term;

import org.eclipse.vjet.dsf.jsnative.global.Number;
import org.eclipse.vjet.dsf.jsnative.global.PrimitiveBoolean;
import org.eclipse.vjet.dsf.jsnative.global.String;
import org.eclipse.vjet.dsf.jsnative.global.Undefined;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.term.JstLiteral;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public final class SimpleLiteral
extends JstLiteral {
    private static final long serialVersionUID = 1L;
    private Class<?> m_type;
    private IJstType m_javaType;
    private java.lang.String m_value;
    private static final java.lang.String SINGLE_QUOTE = "'";
    private static final java.lang.String DOUBLE_QUOTE = "\"";

    public SimpleLiteral(Class<?> type, IJstType jstType, java.lang.String value) {
        this.m_type = type;
        this.m_jstType = jstType;
        this.m_value = value;
        this.m_javaType = SimpleLiteral.getJavaType(type);
        if (this.m_value != null) {
            java.lang.Number l;
            if (this.m_type != java.lang.String.class && this.m_type != CharSequence.class && this.m_type != Object.class && (this.m_value.charAt(this.m_value.length() - 1) == 'L' || this.m_value.charAt(this.m_value.length() - 1) == 'l')) {
                this.m_value = this.m_value.substring(0, this.m_value.length() - 1);
            }
            if (this.m_type == Integer.TYPE || this.m_type == Integer.class) {
                try {
                    l = Long.decode(this.m_value);
                    if ((Long)l > Integer.MAX_VALUE) {
                        this.m_value = Integer.toString(((Long)l).intValue());
                    }
                }
                catch (Exception exception) {}
            }
            if ((this.m_type == Short.TYPE || this.m_type == Short.class) && (Integer)(l = Integer.decode(this.m_value)) > Short.MAX_VALUE) {
                this.m_value = Short.toString(((Integer)l).shortValue());
            }
            if ((this.m_type == Byte.TYPE || this.m_type == Byte.class) && (Integer)(l = Integer.decode(this.m_value)) > 127) {
                this.m_value = Byte.toString(((Integer)l).byteValue());
            }
        }
    }

    @Override
    public java.lang.String toValueText() {
        if (this.m_value == null) {
            return "null";
        }
        if (this.m_type == java.lang.String.class && this.m_value != null) {
            return DOUBLE_QUOTE + this.m_value + DOUBLE_QUOTE;
        }
        if (this.m_type == Character.TYPE && this.m_value != null) {
            return SINGLE_QUOTE + this.m_value + SINGLE_QUOTE;
        }
        if ((this.m_type == Double.class || this.m_type == Double.TYPE || this.m_type == Float.class || this.m_type == Float.TYPE) && (this.m_value.endsWith("d") || this.m_value.endsWith("f") || this.m_value.endsWith("D") || this.m_value.endsWith("F")) && !this.m_value.startsWith("0x")) {
            return this.m_value.substring(0, this.m_value.length() - 1);
        }
        return this.m_value;
    }

    public java.lang.String toParamText() {
        return this.toValueText();
    }

    public java.lang.String toTermText() {
        return this.toValueText();
    }

    @Override
    public java.lang.String toSimpleTermText() {
        return this.toValueText();
    }

    public java.lang.String toRHSText() {
        return this.toValueText();
    }

    @Override
    public java.lang.String toExprText() {
        return this.toValueText();
    }

    public void setResultType(IJstType type) {
        this.m_javaType = type;
        this.m_jstType = type;
    }

    @Override
    public IJstType getResultType() {
        return this.m_javaType != null ? this.m_javaType : this.m_jstType;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public java.lang.String toString() {
        return this.toValueText();
    }

    public java.lang.String getValue() {
        return this.m_value;
    }

    public static SimpleLiteral getCharLiteral(java.lang.String literal) {
        return new SimpleLiteral(Character.TYPE, SimpleLiteral.getJsType(String.class), literal);
    }

    public static SimpleLiteral getStringLiteral(java.lang.String literal) {
        return new SimpleLiteral(java.lang.String.class, SimpleLiteral.getJsType(String.class), literal);
    }

    public static SimpleLiteral getBooleanLiteral(java.lang.String literal) {
        return new SimpleLiteral(Boolean.TYPE, SimpleLiteral.getJsType(PrimitiveBoolean.class), literal);
    }

    public static SimpleLiteral getBooleanLiteral(boolean literal) {
        return new SimpleLiteral(Boolean.TYPE, SimpleLiteral.getJsType(PrimitiveBoolean.class), Boolean.toString(literal));
    }

    public static SimpleLiteral getIntLiteral(int literal) {
        return new SimpleLiteral(Integer.TYPE, SimpleLiteral.getJsType(Number.class), java.lang.String.valueOf(literal));
    }

    public static SimpleLiteral getIntLiteral(java.lang.String literal) {
        return new SimpleLiteral(Integer.TYPE, SimpleLiteral.getJsType(Number.class), literal);
    }

    public static SimpleLiteral getShortLiteral(java.lang.String literal) {
        return new SimpleLiteral(Short.TYPE, SimpleLiteral.getJsType(Number.class), literal);
    }

    public static SimpleLiteral getByteLiteral(java.lang.String literal) {
        return new SimpleLiteral(Byte.TYPE, SimpleLiteral.getJsType(Number.class), literal);
    }

    public static SimpleLiteral getIntegerLiteral(java.lang.String literal) {
        return new SimpleLiteral(Integer.TYPE, SimpleLiteral.getJsType(Number.class), literal);
    }

    public static SimpleLiteral getFloatLiteral(java.lang.String literal) {
        return new SimpleLiteral(Float.TYPE, SimpleLiteral.getJsType(Number.class), literal);
    }

    public static SimpleLiteral getLongLiteral(java.lang.String literal) {
        return new SimpleLiteral(Long.TYPE, SimpleLiteral.getJsType(Number.class), literal);
    }

    public static SimpleLiteral getDoubleLiteral(java.lang.String literal) {
        return new SimpleLiteral(Double.TYPE, SimpleLiteral.getJsType(Number.class), literal);
    }

    public static SimpleLiteral getNullLiteral() {
        return new SimpleLiteral(null, null, null);
    }

    public static SimpleLiteral getUndefinedLiteral() {
        return new SimpleLiteral(null, SimpleLiteral.getJsType(Undefined.class), "undefined");
    }

    private static JstType getJsType(Class<?> jsnative) {
        JstType type = JstCache.getInstance().getType(jsnative.getName());
        if (type != null) {
            return type;
        }
        return JstCache.getInstance().getType(jsnative.getSimpleName());
    }

    private static JstType getJavaType(Class<?> javaWrapper) {
        if (javaWrapper == null) {
            return null;
        }
        JstType type = JstCache.getInstance().getType("vjo." + javaWrapper.getName());
        if (type != null) {
            return type;
        }
        return JstCache.getInstance().getType(javaWrapper.getSimpleName());
    }
}

