/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.ts;

import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.ts.AJstSymbolTableMgr;
import org.eclipse.vjet.dsf.jst.ts.JstQueryExecutor;
import org.eclipse.vjet.dsf.ts.TypeSpace;
import org.eclipse.vjet.dsf.ts.index.DependencyIndexMap;
import org.eclipse.vjet.dsf.ts.index.DependencyIndexNode;
import org.eclipse.vjet.dsf.ts.method.MethodIndex;
import org.eclipse.vjet.dsf.ts.method.MethodName;
import org.eclipse.vjet.dsf.ts.type.ISymbolName;
import org.eclipse.vjet.dsf.ts.type.TypeName;

final class MethodIndexMgr
extends AJstSymbolTableMgr<MethodName> {
    MethodIndexMgr(TypeSpace<IJstType, IJstNode> ts, JstQueryExecutor executor) {
        super(ts, executor);
    }

    @Override
    protected Map<MethodName, List<IJstNode>> findSymbolUsagesWithinType(IJstType type) {
        return this.m_qe.findMethodUsagesWithinNode(type);
    }

    @Override
    protected DependencyIndexMap<IJstNode> createIndex(IJstType type) {
        return new MethodIndex(type);
    }

    @Override
    protected void addDanglingReferencesToSymbol(ISymbolName symbol, DependencyIndexNode<IJstNode> indexnode) {
        this.m_ts.addToUnresolvedIndexNode((MethodName)symbol, indexnode);
    }

    @Override
    protected IJstNode getSymbolNode(ISymbolName symbol, boolean isStatic) {
        TypeName typeName = new TypeName(symbol.getGroupName(), symbol.getOwnerTypeName());
        IJstType type = (IJstType)this.m_ts.getType(typeName);
        if (type == null) {
            throw new RuntimeException("cannot find type for type:" + type);
        }
        return type.getMethod(symbol.getLocalName(), isStatic, false);
    }

    @Override
    protected boolean isSymbolInType(IJstType type, String symbol) {
        if (type.getMethod(symbol) != null) {
            return true;
        }
        IJstMethod constructor = type.getConstructor();
        return constructor != null && constructor.getName().getName().equals(symbol);
    }

    void removeMethod(MethodName mtdName, boolean isStatic) {
        this.removeSymbol(mtdName, isStatic);
    }

    void addMethod(MethodName mtdName, IJstMethod mtd) {
        TypeName typeName = mtdName.typeName();
        IJstType type = (IJstType)this.m_ts.getType(typeName);
        if (type == null) {
            throw new RuntimeException("cannot find type for type:" + typeName);
        }
        DependencyIndexMap index = this.getTypeIndex(typeName, true, true);
        DependencyIndexNode node = this.m_ts.getUnresolvedIndexNode(mtdName);
        if (index != null && node != null) {
            index.addEntity(node);
        }
        Map methodUsageMap = this.getMethodUsages(mtd);
        this.addReferencesUsedByType(type, methodUsageMap);
        Map propertyUsageMap = this.getPropertyUsages(mtd);
        this.m_ts.getPropertySymbolTableManager().addReferencesUsedByType(type, propertyUsageMap);
    }

    void modifyMethod(MethodName mtdName, boolean isStatic, IJstMethod method) {
        this.removeSymbol(mtdName, isStatic);
        this.addMethod(mtdName, method);
    }
}

