/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.ts.util;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.common.StringUtils;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.ISynthesized;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstName;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstVar;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.traversal.IJstVisitor;

public class JstPrettyPrintVisitor
implements IJstVisitor {
    private final PrintStream m_ps;
    private final boolean m_support_indent_escape_symbols;
    private Map<IJstNode, Integer> m_ids = new IdentityHashMap<IJstNode, Integer>();
    private int m_id = 0;

    public JstPrettyPrintVisitor(PrintStream ps) {
        this.m_ps = ps;
        this.m_support_indent_escape_symbols = ps.getClass().getCanonicalName().endsWith("IndentedPrintStream");
    }

    private String get_role_in_parent(IJstNode node) {
        IJstNode parent = node.getParentNode();
        if (parent != null) {
            Method[] methodArray = parent.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method accessor = methodArray[n2];
                if (accessor.getParameterTypes().length <= 0 && accessor.getName().startsWith("get") && !accessor.getName().equals("getChildren")) {
                    try {
                        Object result = accessor.invoke((Object)parent, new Object[0]);
                        if (result == node) {
                            return accessor.getName().substring("get".length()).toUpperCase();
                        }
                        if (result instanceof List && ((List)result).contains(node)) {
                            return String.valueOf(accessor.getName().substring("get".length()).toUpperCase()) + "#";
                        }
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
        }
        return "CHILD";
    }

    @Override
    public void preVisit(IJstNode node) {
        String role = String.valueOf(this.get_role_in_parent(node)) + ":";
        this.m_ps.print(this.m_support_indent_escape_symbols ? "\u0001" + role + "[" : String.valueOf(role) + "[");
    }

    @Override
    public void postVisit(IJstNode node) {
        this.m_ps.println(this.m_support_indent_escape_symbols ? "]\u0002" : "]");
    }

    @Override
    public void endVisit(IJstNode node) {
    }

    private int get_id(IJstNode node) {
        Integer id = this.m_ids.get(node);
        if (id == null) {
            id = this.m_id++;
            this.m_ids.put(node, id);
        }
        return id;
    }

    @Override
    public boolean visit(IJstNode node) {
        return this.visit(node, false);
    }

    private boolean visit(IJstNode node, boolean abbreviated) {
        if (node == null) {
            this.m_ps.print("{IJstNode=null}");
        } else {
            if (node instanceof IJstType) {
                return this.visitJstType((IJstType)node, abbreviated);
            }
            if (node instanceof IJstProperty) {
                return this.visitJstProperty((IJstProperty)node, abbreviated);
            }
            if (node instanceof IJstMethod) {
                return this.visitJstMethod((IJstMethod)node, abbreviated);
            }
            if (node instanceof JstBlock) {
                return this.visitJstBlock((JstBlock)node, abbreviated);
            }
            if (node instanceof JstIdentifier) {
                return this.visitJstIdentifier((JstIdentifier)node, abbreviated);
            }
            if (node instanceof JstArg) {
                return this.visitJstArg((JstArg)node, abbreviated);
            }
            if (node instanceof JstName) {
                return this.visitJstName((JstName)node, abbreviated);
            }
            if (node instanceof IExpr) {
                return this.visitExpr((IExpr)node, abbreviated);
            }
            if (node instanceof IStmt) {
                return this.visitStmt((IStmt)node, abbreviated);
            }
            if (node instanceof JstVar) {
                return this.visitJstVar((JstVar)node, abbreviated);
            }
            if (node instanceof JstTypeReference) {
                this.m_ps.println("type: " + ((JstTypeReference)node).getReferencedType().getName());
                return true;
            }
            this.m_ps.print("*** Unknown node type " + node.getClass());
        }
        return true;
    }

    private boolean printJstSource(JstSource node) {
        if (node != null) {
            this.m_ps.println("source info:");
            this.m_ps.println("start offset : " + node.getStartOffSet());
            this.m_ps.println("end offset : " + node.getEndOffSet());
        }
        return true;
    }

    private boolean visitJstBlock(JstBlock block, boolean abbreviated) {
        this.prt_JstBlock(block);
        if (abbreviated) {
            return true;
        }
        this.m_ps.print(this.m_support_indent_escape_symbols ? "\n\u0001" : "\n");
        if (block.getOwnerType() != null) {
            this.m_ps.print("defined_by=[");
            this.visit(block.getOwnerType(), true);
            this.m_ps.println("]");
        }
        this.prt_list("Statements", block.getStmts());
        block.getVarTable();
        if (this.m_support_indent_escape_symbols) {
            this.m_ps.print('\u0002');
        }
        return true;
    }

    private boolean visitJstMethod(IJstMethod node, boolean abbreviated) {
        this.prt_JstMethod(node);
        if (abbreviated) {
            return true;
        }
        this.m_ps.print(this.m_support_indent_escape_symbols ? "\n\u0001" : "\n");
        if (node.getOwnerType() != null) {
            this.m_ps.print("declared_by=[");
            this.visit(node.getRootType(), true);
            this.m_ps.println("]");
        }
        this.m_ps.print("type=[");
        this.prt_JstType(node.getRtnType());
        this.m_ps.println("]\nmodifiers=" + node.getModifiers());
        this.prt_list("args", node.getArgs());
        if (this.m_support_indent_escape_symbols) {
            this.m_ps.print('\u0002');
        }
        return true;
    }

    private boolean visitJstProperty(IJstProperty node, boolean abbreviated) {
        this.prt_JstProperty(node);
        if (abbreviated) {
            return true;
        }
        this.m_ps.print(this.m_support_indent_escape_symbols ? "\n\u0001" : "\n");
        if (node.getOwnerType() != null) {
            this.m_ps.print("declared_by=[");
            this.visit(node.getRootType(), true);
            this.m_ps.println("]");
        }
        if (node.getInitializer() != null) {
            this.m_ps.print("initializer=[");
            this.visit(node.getInitializer(), true);
            this.m_ps.println("]");
        }
        this.m_ps.print("type=[");
        this.prt_JstType(node.getType());
        this.m_ps.println("]\nmodifiers=" + node.getModifiers() + (this.m_support_indent_escape_symbols ? "\u0002" : ""));
        return true;
    }

    private boolean visitJstType(IJstType node, boolean abbreviated) {
        this.prt_JstType(node);
        if (abbreviated) {
            return true;
        }
        this.m_ps.print(this.m_support_indent_escape_symbols ? "\n\u0001" : "\n");
        if (node.getOwnerType() != null) {
            this.m_ps.print("owner_type=[");
            this.visit(node.getOwnerType(), true);
            this.m_ps.println("]");
        }
        try {
            this.m_ps.print("ctor=[");
            IJstMethod cons = node.getConstructor();
            if (cons instanceof ISynthesized) {
                cons = null;
            }
            this.visitJstMethod(cons, true);
            this.m_ps.println("]\nmodifiers=" + node.getModifiers());
            this.m_ps.println(this.m_support_indent_escape_symbols ? "Details=[\u0001" : "Details=[");
            this.prt_list("Expects", node.getExpects());
            this.prt_list("Extends", node.getExtends());
            this.prt_list("Imports", node.getImports());
            this.prt_list("Satisfies", node.getSatisfies());
            this.prt_list("Mixins", node.getMixinsRef());
            this.prt_list("InstanceProperties", node.getInstanceProperties());
            this.prt_list("StaticProperties", node.getStaticProperties());
            this.prt_list("InstanceMethods", node.getMethods(false));
            this.prt_list("StaticMethods", node.getMethods(true));
            this.prt_list("InstanceInitializers", node.getInstanceInitializers());
            this.prt_list("StaticInitializers", node.getStaticInitializers());
            this.m_ps.println(this.m_support_indent_escape_symbols ? "\u0002]" : "]");
        }
        finally {
            if (this.m_support_indent_escape_symbols) {
                this.m_ps.print('\u0002');
            }
        }
        return true;
    }

    private boolean visitJstName(JstName name, boolean abbreviated) {
        this.prt_JstName(name);
        return true;
    }

    private boolean visitStmt(IStmt stmt, boolean abbreviated) {
        this.prt_JstStmt(stmt);
        if (abbreviated) {
            return true;
        }
        this.m_ps.print('\n');
        return true;
    }

    private boolean visitExpr(IExpr expr, boolean abbreviated) {
        this.prt_JstExpr(expr);
        if (abbreviated) {
            return true;
        }
        this.m_ps.print('\n');
        if (this.m_support_indent_escape_symbols) {
            this.m_ps.print('\u0001');
        }
        try {
            if (expr.getResultType() != null) {
                this.m_ps.print("result_type=[");
                this.visit(expr.getResultType(), true);
                this.m_ps.println("]");
            }
            if (expr instanceof MtdInvocationExpr) {
                if (((MtdInvocationExpr)expr).getMethod() != null) {
                    this.m_ps.print("declared_by=[");
                    this.visit(((MtdInvocationExpr)expr).getMethod().getRootType(), true);
                    this.m_ps.println("]");
                } else if (((MtdInvocationExpr)expr).getQualifyExpr() != null) {
                    this.m_ps.println("declared_by=[{??? text=\"" + this.sanitize(((MtdInvocationExpr)expr).getQualifyExpr().toExprText()) + "\"}]");
                }
            }
        }
        finally {
            if (this.m_support_indent_escape_symbols) {
                this.m_ps.print('\u0002');
            }
        }
        return true;
    }

    private boolean visitJstIdentifier(JstIdentifier identifier, boolean abbreviated) {
        this.prt_JstIdentifier(identifier);
        if (abbreviated) {
            return true;
        }
        this.m_ps.print('\n');
        if (this.m_support_indent_escape_symbols) {
            this.m_ps.print('\u0001');
        }
        try {
            if (identifier.getJstBinding() != null) {
                this.m_ps.print("binding=[");
                this.visit(identifier.getJstBinding(), true);
                this.m_ps.println("]");
            }
            if (identifier.getResultType() != null) {
                this.m_ps.print("result_type=[");
                this.visit(identifier.getResultType(), true);
                this.m_ps.println("]");
            }
            if (identifier.getName() != null) {
                this.m_ps.println("name=\"" + identifier.getName() + "\"");
            }
        }
        finally {
            if (this.m_support_indent_escape_symbols) {
                this.m_ps.print('\u0002');
            }
        }
        return true;
    }

    private boolean visitJstArg(JstArg arg, boolean abbreviated) {
        this.prt_JstArg(arg);
        return true;
    }

    private boolean visitJstVar(JstVar var, boolean abbreviated) {
        this.m_ps.print("JstVar: @" + this.get_id(var) + " \"" + var.getName() + "\"");
        return true;
    }

    private void prt_JstProperty(IJstProperty prop) {
        this.m_ps.print("IJstProperty: @" + this.get_id(prop) + " \"" + prop.getName() + "\"");
    }

    private void prt_JstType(IJstType node) {
        if (node == null) {
            this.m_ps.print("{IJstType=null}");
            return;
        }
        this.m_ps.print("IJstType: @" + this.get_id(node) + " \"" + node.getName() + "\"");
    }

    private void prt_JstMethod(IJstMethod method) {
        if (method == null) {
            this.m_ps.print("{IJstMethod=null}");
            return;
        }
        this.m_ps.print("IJstMethod: @" + this.get_id(method) + " \"" + method.getName() + "\"");
    }

    private void prt_JstArg(JstArg arg) {
        this.m_ps.print("JstArg: @" + this.get_id(arg) + " \"" + arg.getName() + "\" + type: " + arg.getTypeRef().getReferencedType().getName());
        this.printJstSource(arg.getSource());
    }

    private void prt_JstBlock(JstBlock block) {
        this.m_ps.print("JstBlock: @" + this.get_id(block));
        this.printJstSource(block.getSource());
    }

    private void prt_JstName(JstName name) {
        this.m_ps.print("JstName: @" + this.get_id(name) + " \"" + name.getName() + "\"");
        this.printJstSource(name.getSource());
    }

    private void prt_JstStmt(IStmt stmt) {
        this.m_ps.print("IStmt:" + stmt.getClass().getSimpleName() + ": @" + this.get_id(stmt) + " \"" + this.sanitize(stmt.toStmtText()) + "\"");
        this.printJstSource(stmt.getSource());
    }

    private void prt_JstExpr(IExpr expr) {
        this.m_ps.print("IExpr:" + expr.getClass().getSimpleName() + ": @" + this.get_id(expr) + " \"" + this.sanitize(expr.toExprText()) + "\"");
        this.printJstSource(expr.getSource());
    }

    private void prt_JstIdentifier(JstIdentifier identifier) {
        this.m_ps.print("JstIdentifier: @" + this.get_id(identifier) + " \"" + this.sanitize(identifier.toExprText()) + "\"");
        this.printJstSource(identifier.getSource());
    }

    private void prt_list(String name, List<? extends IJstNode> lst) {
        if (lst == null || lst.size() == 0) {
            return;
        }
        if (lst.size() == 1) {
            this.m_ps.print(String.valueOf(name) + "=[");
            this.visit(lst.get(0), true);
        } else {
            this.m_ps.print(String.valueOf(name) + (this.m_support_indent_escape_symbols ? "=[\n\u0001" : "=[\n"));
            try {
                for (IJstNode iJstNode : lst) {
                    this.printJstSource(iJstNode.getSource());
                    this.visit(iJstNode, true);
                    this.m_ps.print('\n');
                }
            }
            finally {
                if (this.m_support_indent_escape_symbols) {
                    this.m_ps.print('\u0002');
                }
            }
        }
        this.m_ps.println("]");
    }

    private String sanitize(String s) {
        String[] a = s.split("\\s");
        return StringUtils.join(Arrays.asList(a), (String)" ");
    }
}

