/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.ts.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class JstSrcFileCollector {
    private File m_srcRoot;

    public List<File> getJsSrcFiles(String srcFolder) {
        return this.getJsSrcFiles(new File(srcFolder));
    }

    public List<File> getJsSrcFiles(File srcFolder) {
        if (this.m_srcRoot == null && srcFolder.isDirectory()) {
            this.m_srcRoot = srcFolder;
        }
        ArrayList<File> fileList = new ArrayList<File>();
        if (srcFolder.exists() && srcFolder.isDirectory()) {
            File[] files = srcFolder.listFiles();
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isFile()) {
                    String fileName = file.getName();
                    if (fileName.matches(".*\\.js") || fileName.matches(".*\\.vjo")) {
                        fileList.add(file);
                    }
                } else if (file.isDirectory() && !file.getAbsolutePath().substring(this.m_srcRoot.getAbsolutePath().length()).contains(".")) {
                    fileList.addAll(this.getJsSrcFiles(file));
                }
                ++i;
            }
        }
        return fileList;
    }

    public static void main(String[] args) {
        JstSrcFileCollector coll = new JstSrcFileCollector();
        List<File> list = coll.getJsSrcFiles(args[0]);
        for (File f : list) {
            System.out.println(f.getPath());
        }
    }
}

