/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstAnnotation;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.ISynthesized;
import org.eclipse.vjet.dsf.jst.declaration.JstAnnotation;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstConstructor;
import org.eclipse.vjet.dsf.jst.declaration.JstFactory;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstMixedType;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.util.DataTypeHelper;

public class JstTypeHelper {
    public static JstType getJstType(IJstType type) {
        if (type == null) {
            return null;
        }
        if (type instanceof JstType) {
            return (JstType)type;
        }
        if (type instanceof JstTypeWithArgs) {
            return JstTypeHelper.getJstType(((JstTypeWithArgs)type).getType());
        }
        return null;
    }

    public static IJstType getPrimitiveType(IExpr expr) {
        if (expr == null || expr.getResultType() == null) {
            return null;
        }
        IJstType type = expr.getResultType();
        if (DataTypeHelper.isPrimitiveType(type)) {
            return type;
        }
        return DataTypeHelper.getPrimitivetype(type);
    }

    public static IJstType getExprType(IExpr expr) {
        IExpr qualifier;
        MtdInvocationExpr mtdInvocation;
        IExpr mtdIdentifier;
        if (expr == null || expr.getResultType() == null) {
            return null;
        }
        IJstType actualType = expr.getResultType();
        if (expr instanceof MtdInvocationExpr && (mtdIdentifier = (mtdInvocation = (MtdInvocationExpr)expr).getMethodIdentifier()) != null && (actualType = mtdIdentifier.getResultType()) instanceof JstParamType && (qualifier = mtdInvocation.getQualifyExpr()) != null && (actualType = qualifier.getResultType()) instanceof JstTypeWithArgs) {
            actualType = ((JstTypeWithArgs)actualType).getArgType();
        }
        return actualType;
    }

    public static boolean isTypeOf(IJstType aType, IJstType bType) {
        if (aType instanceof IJstRefType && "Function".equals(bType.getName())) {
            return true;
        }
        return JstTypeHelper.isSubTypeOf(aType, bType) || JstTypeHelper.isImplementerOf(aType, bType) || "Object".equals(bType.getName()) || "Object".equals(bType.getSimpleName());
    }

    private static boolean isSubTypeOf(IJstType aType, IJstType bType) {
        for (IJstType iJstType : aType.getExtends()) {
            if (iJstType == bType) {
                return true;
            }
            if (!JstTypeHelper.isSubTypeOf(iJstType, bType)) continue;
            return true;
        }
        return false;
    }

    private static boolean isImplementerOf(IJstType type, IJstType bType) {
        if (type == null || bType == null) {
            return false;
        }
        IJstType aType = type;
        if (type instanceof JstTypeWithArgs) {
            aType = ((JstTypeWithArgs)type).getType();
        }
        for (IJstType iJstType : aType.getSatisfies()) {
            if (iJstType == bType) {
                return true;
            }
            if (!JstTypeHelper.isImplementerOf(iJstType, bType)) continue;
            return true;
        }
        for (IJstType iJstType : aType.getExtends()) {
            if (!JstTypeHelper.isImplementerOf(iJstType, bType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTemplateType(IJstType type, IJstMethod method) {
        if (type == null || method == null) {
            return false;
        }
        if (JstTypeHelper.isTemplateType(type, method.getParamTypes())) {
            return true;
        }
        if (method.getRootType() != null) {
            return JstTypeHelper.isTemplateType(type, method.getRootType().getParamTypes());
        }
        return false;
    }

    public static boolean isTemplateType(IJstType type, List<JstParamType> paramTypes) {
        if (type == null || type.getName() == null || paramTypes == null) {
            return false;
        }
        for (JstParamType ptype : paramTypes) {
            if (!type.getName().equals(ptype.getName())) continue;
            return true;
        }
        return false;
    }

    public static IJstType resolveTypeWithArgs(IJstNode mtdOrPty, IJstType parentType) {
        IJstType paramType = null;
        if (mtdOrPty instanceof IJstMethod) {
            paramType = ((IJstMethod)mtdOrPty).getRtnType();
        } else if (mtdOrPty instanceof IJstProperty) {
            paramType = ((IJstProperty)mtdOrPty).getType();
        }
        if (paramType instanceof JstParamType) {
            if (parentType instanceof JstTypeWithArgs) {
                return JstTypeHelper.getParamType((JstParamType)paramType, (JstTypeWithArgs)parentType);
            }
            List<JstParamType> paramTypeList = parentType.getParamTypes();
            if (paramTypeList != null && !paramTypeList.isEmpty()) {
                return JstCache.getInstance().getType("Undefined");
            }
        }
        return paramType;
    }

    private static IJstType getParamType(JstParamType paramType, JstTypeWithArgs typeWithArgs) {
        IJstType type = typeWithArgs.getParamArgType(paramType);
        if (type != null) {
            return type;
        }
        return paramType;
    }

    public static IJstType resolveJstArgType(JstArg arg, IJstType typeWithArgs) {
        IJstType argType = arg.getType();
        if (argType instanceof JstParamType && typeWithArgs instanceof JstTypeWithArgs) {
            argType = JstTypeHelper.getParamType((JstParamType)argType, (JstTypeWithArgs)typeWithArgs);
        } else {
            if (argType instanceof JstTypeWithArgs || argType instanceof JstType || argType instanceof JstParamType) {
                return argType;
            }
            List<JstParamType> paramTypeList = typeWithArgs.getParamTypes();
            if (paramTypeList != null && !paramTypeList.isEmpty()) {
                argType = JstCache.getInstance().getType("Object");
            }
        }
        return argType;
    }

    public static List<IJstProperty> getDeclaredProperties(List<IJstProperty> properties) {
        ArrayList<IJstProperty> newList = new ArrayList<IJstProperty>();
        boolean useNew = false;
        for (IJstProperty itm : properties) {
            if (itm instanceof ISynthesized) {
                useNew = true;
                continue;
            }
            newList.add(itm);
        }
        return useNew ? newList : properties;
    }

    public static List<? extends IJstMethod> getDeclaredMethods(List<? extends IJstMethod> mtds) {
        ArrayList<IJstMethod> newList = new ArrayList<IJstMethod>();
        boolean useNew = false;
        for (IJstMethod iJstMethod : mtds) {
            if (iJstMethod instanceof ISynthesized) {
                useNew = true;
                continue;
            }
            newList.add(iJstMethod);
        }
        return useNew ? newList : mtds;
    }

    public static List<? extends IJstMethod> getSignatureConstructors(IJstType type) {
        if (type == null || type.getConstructor() == null) {
            return Collections.emptyList();
        }
        ArrayList<IJstMethod> constructors = new ArrayList<IJstMethod>();
        IJstMethod constructor = type.getConstructor();
        if (constructor.isDispatcher()) {
            constructors.addAll(constructor.getOverloaded());
        } else {
            constructors.add(constructor);
        }
        return constructors;
    }

    public static List<? extends IJstMethod> getSignatureMethods(IJstType type) {
        if (type == null) {
            return Collections.emptyList();
        }
        ArrayList<IJstMethod> methods = new ArrayList<IJstMethod>();
        for (IJstMethod iJstMethod : type.getMethods()) {
            if (iJstMethod.isDispatcher()) {
                methods.addAll(iJstMethod.getOverloaded());
                continue;
            }
            methods.add(iJstMethod);
        }
        return methods;
    }

    public static List<? extends IJstMethod> getSignatureMethods(IJstMethod mtd) {
        if (mtd == null) {
            return Collections.emptyList();
        }
        ArrayList<IJstMethod> methods = new ArrayList<IJstMethod>();
        if (mtd.isDispatcher()) {
            methods.addAll(mtd.getOverloaded());
        } else {
            methods.add(mtd);
        }
        return methods;
    }

    public static List<? extends IJstMethod> getSignatureMethods(IJstType type, boolean isStatic, boolean recursive) {
        if (type == null) {
            return Collections.emptyList();
        }
        ArrayList<IJstMethod> methods = new ArrayList<IJstMethod>();
        if (type instanceof JstMixedType) {
            JstMixedType m = (JstMixedType)type;
            for (IJstType t : m.getMixedTypes()) {
                JstTypeHelper.getMethodSignatures(t, isStatic, recursive, methods);
            }
        } else {
            JstTypeHelper.getMethodSignatures(type, isStatic, recursive, methods);
        }
        return methods;
    }

    private static void getMethodSignatures(IJstType type, boolean isStatic, boolean recursive, List<IJstMethod> methods) {
        for (IJstMethod iJstMethod : type.getMethods(isStatic, recursive)) {
            if (iJstMethod.isDispatcher()) {
                methods.addAll(iJstMethod.getOverloaded());
                continue;
            }
            methods.add(iJstMethod);
        }
    }

    public static boolean hasSameRootType(IJstType type1, IJstType type2) {
        return JstTypeHelper.getRootType(type1) == JstTypeHelper.getRootType(type2);
    }

    public static JstPackage getTruePackage(IJstType type) {
        if (type == null) {
            return null;
        }
        return JstTypeHelper.getRootType(type).getPackage();
    }

    private static IJstType getRootType(IJstType type) {
        IJstType parent = type;
        while (parent != null) {
            type = parent;
            parent = type.getOuterType();
        }
        return type;
    }

    public static List<IJstType> getRtnTypes(JstMethod meth) {
        ArrayList<IJstType> list;
        if (!meth.isDispatcher()) {
            list = new ArrayList<IJstType>(1);
            list.add(meth.getRtnType());
        } else {
            List<IJstMethod> methods = meth.getOverloaded();
            list = new ArrayList(methods.size());
            for (IJstMethod mtd : methods) {
                list.add(mtd.getRtnType());
            }
        }
        return list;
    }

    public static IJstType mixin(IJstType type, IJstType mtype) {
        JstType newType = JstFactory.getInstance().createJstType(type.getPackage(), type.getSimpleName(), false);
        newType.addExtend(type);
        newType.addMixin(new JstTypeReference(mtype));
        return newType;
    }

    public static IJstType make(IJstType type) {
        JstType newType = JstFactory.getInstance().createJstType(type.getPackage(), type.getSimpleName(), false);
        if (type.isClass()) {
            newType.addExtend(new JstTypeReference(type));
        } else if (type.isInterface()) {
            newType.addSatisfy(new JstTypeReference(type));
        }
        return newType;
    }

    public static boolean isConstructor(IJstNode node) {
        String mtdName;
        JstMethod method;
        if (node instanceof JstConstructor) {
            return true;
        }
        return node instanceof JstMethod && (method = (JstMethod)node) != null && (mtdName = method.getName().getName()) != null && mtdName.startsWith("constructs") && mtdName.endsWith("_ovld");
    }

    public static void populateMethod(JstMethod to, IJstMethod from) {
        List<IJstAnnotation> annos = from.getAnnotations();
        for (IJstAnnotation anno : annos) {
            to.addAnnotation((JstAnnotation)anno);
        }
        if (to.getArgs() != null) {
            to.getArgs().clear();
        }
        List<JstArg> args = from.getArgs();
        for (JstArg arg : args) {
            to.addArg(new JstArg(arg.getType(), arg.getName(), arg.isVariable(), arg.isOptional(), arg.isFinal()));
        }
        if (to.getParamTypes() != null) {
            to.getParamTypes().clear();
        }
        List<String> params = from.getParamNames();
        int i = 0;
        while (i < params.size()) {
            to.addParam(params.get(i));
            ++i;
        }
        to.setRtnRefType(from.getRtnTypeRef());
        to.setReturnOptional(from.isReturnTypeOptional());
    }

    public static void populateMethod(JstMethod to, IJstMethod from, boolean keepArgNames) {
        if (!keepArgNames) {
            JstTypeHelper.populateMethod(to, from);
            return;
        }
        List<IJstAnnotation> annos = from.getAnnotations();
        for (IJstAnnotation anno : annos) {
            to.addAnnotation((JstAnnotation)anno);
        }
        ArrayList<String> argNameList = new ArrayList<String>();
        List<JstArg> toArgs = to.getArgs();
        if (toArgs != null) {
            for (JstArg arg : toArgs) {
                argNameList.add(arg.getName());
            }
            toArgs.clear();
        }
        List<JstArg> args = from.getArgs();
        int idx = 0;
        for (JstArg arg : args) {
            String argName = null;
            if (idx >= argNameList.size()) break;
            argName = (String)argNameList.get(idx);
            if (argName == null || argName.length() == 0) {
                argName = arg.getName();
            }
            to.addArg(new JstArg(arg.getType(), argName, arg.isVariable(), arg.isOptional(), arg.isFinal()));
            ++idx;
        }
        if (to.getParamTypes() != null) {
            to.getParamTypes().clear();
        }
        List<String> params = from.getParamNames();
        int i = 0;
        while (i < params.size()) {
            to.addParam(params.get(i));
            ++i;
        }
        to.setRtnRefType(from.getRtnTypeRef());
        to.setReturnOptional(from.isReturnTypeOptional());
    }

    public static IJstRefType getJstTypeRefType(IJstType type) {
        IJstRefType typeRefType = JstCache.getInstance().getTypeRefType(type);
        if (typeRefType == null) {
            typeRefType = JstFactory.getInstance().createJstTypeRefType(type);
        }
        return typeRefType;
    }
}

