/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.ts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.ts.TypeSpaceLocker;
import org.eclipse.vjet.dsf.ts.index.DependencyIndexMap;
import org.eclipse.vjet.dsf.ts.index.DependencyIndexNode;
import org.eclipse.vjet.dsf.ts.type.ISymbolName;
import org.eclipse.vjet.dsf.ts.type.TypeName;

public abstract class ASymbolTableManager<T, D> {
    private final TypeSpaceLocker m_locker = new TypeSpaceLocker();
    protected Map<TypeName, DependencyIndexMap<D>> m_symbolTable = new LinkedHashMap<TypeName, DependencyIndexMap<D>>();
    protected Map<TypeName, DependencyIndexMap<D>> m_removedSymbolTable = new LinkedHashMap<TypeName, DependencyIndexMap<D>>();

    protected abstract DependencyIndexMap<D> createIndex(T var1);

    protected abstract void addDanglingReferencesToSymbol(ISymbolName var1, DependencyIndexNode<D> var2);

    protected abstract D getSymbolNode(ISymbolName var1, boolean var2);

    protected abstract Map<? extends ISymbolName, List<D>> getPropertyUsages(D var1);

    protected abstract Map<? extends ISymbolName, List<D>> getMethodUsages(D var1);

    protected abstract String getName(T var1);

    protected abstract T getOwnerType(D var1);

    protected abstract T lookupType(TypeName var1);

    protected ASymbolTableManager() {
    }

    protected DependencyIndexMap<D> addIndex(TypeName typeName, DependencyIndexMap<D> index) {
        if (index == null || typeName == null) {
            return null;
        }
        try {
            this.m_locker.lockExclusive();
            DependencyIndexMap<D> index1 = this.m_symbolTable.get(typeName);
            if (index1 != null) {
                if (index1 == index) {
                    DependencyIndexMap<D> dependencyIndexMap = index1;
                    return dependencyIndexMap;
                }
                throw new RuntimeException("Index of same type already exists:" + typeName);
            }
            this.m_symbolTable.put(typeName, index);
            DependencyIndexMap<D> dependencyIndexMap = index;
            return dependencyIndexMap;
        }
        finally {
            this.m_locker.releaseExclusive();
        }
    }

    protected DependencyIndexMap<D> removeIndex(TypeName typeName) {
        if (typeName == null) {
            return null;
        }
        try {
            this.m_locker.lockExclusive();
            DependencyIndexMap<D> index = this.m_symbolTable.remove(typeName);
            if (index != null) {
                this.remove_references(typeName, index);
                this.m_removedSymbolTable.put(typeName, index);
            }
            DependencyIndexMap<D> dependencyIndexMap = index;
            return dependencyIndexMap;
        }
        finally {
            this.m_locker.releaseExclusive();
        }
    }

    protected DependencyIndexMap<D> getIndex(TypeName typeName) {
        return this.getTypeIndex(typeName, false, false);
    }

    protected abstract boolean isSymbolInType(IJstType var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fixIndexMap(TypeName typeName, IJstType type) {
        if (typeName == null || type == null) {
            return;
        }
        DependencyIndexMap<D> index = this.getTypeIndex(typeName, true, true);
        if (index != null) {
            ArrayList<String> symbolNameRemoveList = new ArrayList<String>();
            for (String symbol : index.getMap().keySet()) {
                if (this.isSymbolInType(type, symbol)) continue;
                symbolNameRemoveList.add(symbol);
            }
            ASymbolTableManager aSymbolTableManager = this;
            synchronized (aSymbolTableManager) {
                for (String symbol : symbolNameRemoveList) {
                    index.removeEntity(symbol);
                }
            }
        }
    }

    protected DependencyIndexMap<D> getTypeIndex(TypeName typeName, boolean useRemoved, boolean create_index) {
        if (typeName == null) {
            return null;
        }
        DependencyIndexMap<D> index = null;
        try {
            this.m_locker.lockExclusive();
            index = this.m_symbolTable.get(typeName);
            if (index == null && useRemoved && (index = this.m_removedSymbolTable.get(typeName)) != null && create_index) {
                this.m_removedSymbolTable.remove(typeName);
                this.m_symbolTable.put(typeName, index);
            }
            if (index == null && create_index && (index = this.m_symbolTable.get(typeName)) == null) {
                T type = this.lookupType(typeName);
                if (type == null) {
                    throw new RuntimeException("cannot find type:" + typeName);
                }
                index = this.createIndex(type);
                this.m_symbolTable.put(typeName, index);
            }
        }
        finally {
            this.m_locker.releaseExclusive();
        }
        return index;
    }

    protected void renameType(TypeName oldName, String newName) {
        if (oldName == null || newName == null) {
            return;
        }
        try {
            this.m_locker.lockExclusive();
            TypeName newTypeName = new TypeName(oldName.groupName(), newName);
            this.m_symbolTable.put(newTypeName, this.m_symbolTable.remove(oldName));
        }
        finally {
            this.m_locker.releaseExclusive();
        }
    }

    public List<D> getDependents(ISymbolName symbol) {
        if (symbol == null) {
            return Collections.emptyList();
        }
        TypeName typeName = new TypeName(symbol.getGroupName(), symbol.getOwnerTypeName());
        DependencyIndexMap<D> index = this.m_symbolTable.get(typeName);
        if (index == null) {
            return Collections.emptyList();
        }
        return index.getDependents(symbol.getLocalName());
    }

    protected void removeSymbol(ISymbolName symbol, boolean isStatic) {
        if (symbol == null) {
            return;
        }
        TypeName declaringTypeName = new TypeName(symbol.getGroupName(), symbol.getOwnerTypeName());
        DependencyIndexMap<D> declaringTypeIndex = this.getTypeIndex(declaringTypeName, true, false);
        if (declaringTypeIndex == null) {
            throw new RuntimeException("cannot find symbol index for type:" + declaringTypeName);
        }
        DependencyIndexNode<D> nodes_referring_us = declaringTypeIndex.removeEntity(symbol.getLocalName());
        this.addDanglingReferencesToSymbol(symbol, nodes_referring_us);
        D node = this.getSymbolNode(symbol, isStatic);
        if (node != null) {
            this.removePropertyDependencies(this.getPropertyUsages(node));
            this.removeMethodDependencies(this.getMethodUsages(node));
        }
    }

    protected abstract void removePropertyDependencies(Map<? extends ISymbolName, List<D>> var1);

    protected abstract void removeMethodDependencies(Map<? extends ISymbolName, List<D>> var1);

    public void remove_dependencies(Map<? extends ISymbolName, List<D>> usage_list) {
        if (usage_list == null) {
            return;
        }
        for (Map.Entry<ISymbolName, List<D>> entry : usage_list.entrySet()) {
            ISymbolName symbol = entry.getKey();
            TypeName typeName = new TypeName(symbol.getGroupName(), symbol.getOwnerTypeName());
            DependencyIndexMap<D> index = this.getTypeIndex(typeName, true, false);
            if (index == null) continue;
            index.removeDependents(symbol.getLocalName(), entry.getValue());
        }
    }

    public void addReferencesUsedByType(T type, Map<? extends ISymbolName, List<D>> usages) {
        if (type == null) {
            return;
        }
        for (Map.Entry<ISymbolName, List<D>> entry : usages.entrySet()) {
            ISymbolName symbol = entry.getKey();
            TypeName symbolsTypeName = new TypeName(symbol.getGroupName(), symbol.getOwnerTypeName());
            DependencyIndexMap<D> index = this.getTypeIndex(symbolsTypeName, true, true);
            index.addDependents(symbol.getLocalName(), entry.getValue());
        }
    }

    protected void removeReferencesToType(TypeName typeName, List<T> from_types) {
        for (T bType : from_types) {
            TypeName tName;
            DependencyIndexMap<D> another_type_index;
            IJstType jstType;
            String groupName = typeName.groupName();
            if (bType instanceof IJstType && (jstType = (IJstType)bType).getPackage() != null) {
                groupName = jstType.getPackage().getGroupName();
            }
            if ((another_type_index = this.getTypeIndex(tName = new TypeName(groupName, this.getName(bType)), true, false)) == null) continue;
            this.remove_references(typeName, another_type_index);
        }
    }

    private void remove_references(TypeName typeName, DependencyIndexMap<D> another_type_index) {
        for (DependencyIndexNode<D> symbolNode : another_type_index.getMap().values()) {
            ArrayList<D> toRemove = new ArrayList<D>();
            for (Object n : symbolNode.getDependents()) {
                T aType = this.getOwnerType(n);
                if (aType == null || !typeName.typeName().equals(this.getName(aType))) continue;
                toRemove.add(n);
            }
            for (Object n : toRemove) {
                another_type_index.removeDependent(symbolNode.getName(), n);
            }
        }
    }
}

