/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.ts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.ts.TypeSpaceLocker;
import org.eclipse.vjet.dsf.ts.ASymbolTableManager;
import org.eclipse.vjet.dsf.ts.ITypeSpace;
import org.eclipse.vjet.dsf.ts.graph.DependencyGraph;
import org.eclipse.vjet.dsf.ts.graph.DependencyNode;
import org.eclipse.vjet.dsf.ts.group.Group;
import org.eclipse.vjet.dsf.ts.group.GroupDependencyNode;
import org.eclipse.vjet.dsf.ts.group.GroupSymbolMapTable;
import org.eclipse.vjet.dsf.ts.group.IGroup;
import org.eclipse.vjet.dsf.ts.index.DependencyIndexNode;
import org.eclipse.vjet.dsf.ts.method.MethodIndex;
import org.eclipse.vjet.dsf.ts.method.MethodName;
import org.eclipse.vjet.dsf.ts.property.PropertyIndex;
import org.eclipse.vjet.dsf.ts.property.PropertyName;
import org.eclipse.vjet.dsf.ts.type.TypeName;
import org.eclipse.vjet.kernel.collection.IdentityHashSet;

public class TypeSpace<T, D>
implements ITypeSpace<T, D> {
    private Map<String, Group<T>> m_groups = new LinkedHashMap<String, Group<T>>();
    private Map<Group<T>, GroupSymbolMapTable<T, D>> m_groupSymbolMap = new LinkedHashMap<Group<T>, GroupSymbolMapTable<T, D>>();
    private ASymbolTableManager<T, D> m_propertySymbolTable;
    private ASymbolTableManager<T, D> m_methodSymbolTable;
    private Map<PropertyName, DependencyIndexNode<D>> m_unresolvedPtyDependents = new LinkedHashMap<PropertyName, DependencyIndexNode<D>>();
    private Map<MethodName, DependencyIndexNode<D>> m_unresolvedMtdDependents = new LinkedHashMap<MethodName, DependencyIndexNode<D>>();
    private final Map<String, DependencyNode<T>> m_unresolvedNodes = new LinkedHashMap<String, DependencyNode<T>>();
    private Map<String, Map<TypeName, T>> m_packages = new LinkedHashMap<String, Map<TypeName, T>>();
    private Map<String, GroupDependencyNode<T>> m_groupDependency = new LinkedHashMap<String, GroupDependencyNode<T>>();
    private final TypeSpaceLocker m_locker;
    private Map<String, List<GlobalNameEntry>> m_globalTypeNameTbl = new LinkedHashMap<String, List<GlobalNameEntry>>();
    private Map<String, List<GlobalNameEntry>> m_globalMemberNameTbl = new LinkedHashMap<String, List<GlobalNameEntry>>();
    private Map<String, List<GlobalNameEntry>> m_globalAllTypeMemberNameTbl = new LinkedHashMap<String, List<GlobalNameEntry>>();
    private Map<String, List<GlobalNameEntry>> m_globalVarTypeMemberNameTbl = new LinkedHashMap<String, List<GlobalNameEntry>>();

    public TypeSpace() {
        this.m_locker = new TypeSpaceLocker();
    }

    public void setMethodSymbolTableManager(ASymbolTableManager<T, D> stmgr) {
        this.m_methodSymbolTable = stmgr;
    }

    public void setPropertySymbolTableManager(ASymbolTableManager<T, D> stmgr) {
        this.m_propertySymbolTable = stmgr;
    }

    public ASymbolTableManager<T, D> getMethodSymbolTableManager() {
        return this.m_methodSymbolTable;
    }

    public ASymbolTableManager<T, D> getPropertySymbolTableManager() {
        return this.m_propertySymbolTable;
    }

    @Override
    public T getType(TypeName typeName) {
        if (typeName == null) {
            return null;
        }
        IGroup group = this.getGroup(typeName.groupName());
        if (group == null) {
            return null;
        }
        return (T)((Group)group).getEntity(typeName.typeName());
    }

    @Override
    public List<T> getType(String typeName) {
        if (typeName == null) {
            return Collections.emptyList();
        }
        ArrayList<T> list = null;
        for (Group<T> g : this.m_groups.values()) {
            T type = g.getEntity(typeName);
            if (type == null) continue;
            if (list == null) {
                list = new ArrayList<T>();
            }
            list.add(type);
        }
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public D getVisibleGlobal(String global, IGroup<T> fromGroup) {
        if (global == null || fromGroup == null) {
            return null;
        }
        GroupSymbolMapTable<T, D> map = this.m_groupSymbolMap.get(fromGroup);
        map.promoteGlobalTypeMembers();
        if (fromGroup == null) {
            return null;
        }
        IGroup ownerGroup = this.getGroup(fromGroup.getName());
        if (ownerGroup == null) {
            return null;
        }
        if (fromGroup != null && !fromGroup.isDependOn(ownerGroup)) {
            return null;
        }
        D globalVar = this.m_groupSymbolMap.get(ownerGroup).getGlobalVar(global);
        if (globalVar != null) {
            return globalVar;
        }
        for (IGroup g : ((Group)ownerGroup).getDirectGroupDependency()) {
            map = this.m_groupSymbolMap.get(g);
            if (map == null) continue;
            map.promoteGlobalTypeMembers();
            globalVar = map.getGlobalVar(global);
            if (globalVar == null) continue;
            return globalVar;
        }
        return null;
    }

    public List<D> getAllVisibleGlobals(IGroup<T> fromGroup) {
        if (fromGroup == null) {
            return null;
        }
        ArrayList<D> globals = new ArrayList<D>();
        IGroup ownerGroup = this.getGroup(fromGroup.getName());
        if (ownerGroup == null) {
            return null;
        }
        globals.addAll(this.m_groupSymbolMap.get(ownerGroup).getAllGlobalVars());
        for (IGroup g : ((Group)ownerGroup).getDirectGroupDependency()) {
            GroupSymbolMapTable<T, D> groupSymbolMapTable = this.m_groupSymbolMap.get(g);
            if (groupSymbolMapTable == null) continue;
            globals.addAll(groupSymbolMapTable.getAllGlobalVars());
        }
        return globals;
    }

    @Override
    public T getVisibleType(TypeName typeName, IGroup<T> fromGroup) {
        if (typeName == null) {
            return null;
        }
        IGroup ownerGroup = this.getGroup(typeName.groupName());
        if (ownerGroup == null) {
            return null;
        }
        if (fromGroup != null && !fromGroup.isDependOn(ownerGroup)) {
            return null;
        }
        return (T)((Group)ownerGroup).getEntity(typeName.typeName());
    }

    @Override
    public List<T> getVisibleType(String typeName, IGroup<T> fromGroup) {
        if (typeName == null) {
            return Collections.emptyList();
        }
        ArrayList<T> list = null;
        for (Group<T> g : this.m_groups.values()) {
            T type = g.getEntity(typeName);
            if (type == null || fromGroup != null && !fromGroup.isDependOn(g)) continue;
            if (list == null) {
                list = new ArrayList<T>();
            }
            list.add(type);
        }
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public boolean isTypeVisible(TypeName typeName, IGroup<T> fromGroup) {
        if (fromGroup == null) {
            throw new RuntimeException("fromGroup is null");
        }
        if (typeName == null) {
            return false;
        }
        return fromGroup.isDependOn(this.getGroup(this.getType(typeName)));
    }

    @Override
    public boolean isTypeVisible(String typeName, IGroup<T> fromGroup) {
        if (fromGroup == null) {
            throw new RuntimeException("fromGroup is null");
        }
        if (typeName == null) {
            return false;
        }
        List<T> types = this.getType(typeName);
        if (types == null || types.isEmpty()) {
            return false;
        }
        for (T type : types) {
            if (!fromGroup.isDependOn(this.getGroup(type))) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<T> getVisibleTypes(IGroup<T> fromGroup) {
        if (fromGroup == null) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(fromGroup.getEntities().values());
        for (IGroup<T> g : fromGroup.getGroupDependency()) {
            list.addAll(g.getEntities().values());
        }
        return list;
    }

    @Override
    public Map<TypeName, T> getVisibleTypesMap(IGroup<T> fromGroup) {
        if (fromGroup == null) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<TypeName, T> map = new LinkedHashMap<TypeName, T>();
        for (Map.Entry<String, T> entry : fromGroup.getGraph().getEntities().entrySet()) {
            map.put(new TypeName(fromGroup.getName(), entry.getKey()), entry.getValue());
        }
        for (IGroup<T> g : fromGroup.getGroupDependency()) {
            String gName = g.getName();
            for (Map.Entry<String, T> entry : g.getGraph().getEntities().entrySet()) {
                String tName = entry.getKey();
                map.put(new TypeName(gName, tName), entry.getValue());
            }
        }
        return map;
    }

    @Override
    public Map<TypeName, T> getTypes() {
        LinkedHashMap map = new LinkedHashMap();
        for (Group<T> g : this.m_groups.values()) {
            String gName = g.getName();
            for (Map.Entry entry : ((DependencyGraph)g.getGraph()).getEntities().entrySet()) {
                String tName = entry.getKey();
                map.put(new TypeName(gName, tName), entry.getValue());
            }
        }
        return map;
    }

    @Override
    public Object getUserObject(TypeName typeName) {
        if (typeName == null) {
            return null;
        }
        IGroup group = this.getGroup(typeName.groupName());
        if (group == null) {
            return null;
        }
        return ((Group)group).getUserObject(typeName.typeName());
    }

    @Override
    public boolean setUserObject(TypeName typeName, Object userObj) {
        if (typeName == null) {
            return false;
        }
        try {
            this.m_locker.lockExclusive();
            IGroup group = this.getGroup(typeName.groupName());
            if (group == null) {
                return false;
            }
            boolean bl = ((Group)group).setUserObject(typeName.typeName(), userObj);
            return bl;
        }
        finally {
            this.m_locker.releaseExclusive();
        }
    }

    @Override
    public Group<T> getGroup(String groupName) {
        if (groupName == null) {
            return null;
        }
        return this.m_groups.get(groupName);
    }

    public GroupDependencyNode<T> getGroupDependencyNode(String groupName) {
        if (groupName == null) {
            return null;
        }
        GroupDependencyNode<T> node = this.m_groupDependency.get(groupName);
        if (node == null) {
            node = new GroupDependencyNode(groupName);
            this.m_groupDependency.put(groupName, node);
        }
        return node;
    }

    @Override
    public Group<T> getGroup(T type) {
        if (type == null) {
            return null;
        }
        for (Group<T> g : this.m_groups.values()) {
            if (!g.getEntities().containsValue(type)) continue;
            return g;
        }
        return null;
    }

    public Group<T> getDependencyGroup(String groupName, T type) {
        if (type == null) {
            return null;
        }
        GroupDependencyNode<T> node = this.getGroupDependencyNode(groupName);
        for (GroupDependencyNode<T> d : node.getDependencies().values()) {
            Group<T> group = d.getGroup();
            if (group == null || !group.getEntities().containsValue(type)) continue;
            return group;
        }
        return null;
    }

    @Override
    public Map<String, Group<T>> getGroups() {
        return Collections.unmodifiableMap(this.m_groups);
    }

    @Override
    public List<T> getDirectDependencies(TypeName typeName) {
        if (typeName == null) {
            return Collections.emptyList();
        }
        IGroup g = this.getGroup(typeName.groupName());
        if (g == null) {
            return Collections.emptyList();
        }
        return ((DependencyGraph)((Group)g).getGraph()).getDirectDependencies(typeName.typeName(), false);
    }

    @Override
    public List<T> getIndirectDependencies(TypeName typeName) {
        if (typeName == null) {
            return Collections.emptyList();
        }
        IGroup g = this.getGroup(typeName.groupName());
        if (g == null) {
            return Collections.emptyList();
        }
        return ((DependencyGraph)((Group)g).getGraph()).getIndirectDependencies(typeName.typeName(), false);
    }

    @Override
    public List<T> getAllDependencies(TypeName typeName) {
        if (typeName == null) {
            return Collections.emptyList();
        }
        IGroup g = this.getGroup(typeName.groupName());
        if (g == null) {
            return Collections.emptyList();
        }
        return ((DependencyGraph)((Group)g).getGraph()).getAllDependencies(typeName.typeName(), false);
    }

    @Override
    public List<T> getDirectDependents(TypeName typeName) {
        if (typeName == null) {
            return Collections.emptyList();
        }
        IGroup g = this.getGroup(typeName.groupName());
        if (g == null) {
            return Collections.emptyList();
        }
        return ((DependencyGraph)((Group)g).getGraph()).getDirectDependents(typeName.typeName(), false);
    }

    @Override
    public List<T> getIndirectDependents(TypeName typeName) {
        if (typeName == null) {
            return Collections.emptyList();
        }
        IGroup g = this.getGroup(typeName.groupName());
        if (g == null) {
            return Collections.emptyList();
        }
        return ((DependencyGraph)((Group)g).getGraph()).getIndirectDependents(typeName.typeName(), false);
    }

    @Override
    public List<T> getAllDependents(TypeName typeName) {
        if (typeName == null) {
            return Collections.emptyList();
        }
        IGroup g = this.getGroup(typeName.groupName());
        if (g == null) {
            return Collections.emptyList();
        }
        return ((DependencyGraph)((Group)g).getGraph()).getAllDependents(typeName.typeName(), false);
    }

    @Override
    public PropertyIndex<T, D> getPropertyIndex(TypeName typeName) {
        return (PropertyIndex)this.m_propertySymbolTable.getIndex(typeName);
    }

    @Override
    public List<D> getPropertyDependents(PropertyName ptyName) {
        return this.m_propertySymbolTable.getDependents(ptyName);
    }

    @Override
    public Map<PropertyName, List<D>> getUnresolvedPropertyDependents() {
        HashMap<PropertyName, List<D>> map = new HashMap<PropertyName, List<D>>();
        for (Map.Entry<PropertyName, DependencyIndexNode<D>> entry : this.m_unresolvedPtyDependents.entrySet()) {
            map.put(entry.getKey(), entry.getValue().getDependents());
        }
        return map;
    }

    @Override
    public MethodIndex<T, D> getMethodIndex(TypeName typeName) {
        return (MethodIndex)this.m_methodSymbolTable.getIndex(typeName);
    }

    @Override
    public List<D> getMethodDependents(MethodName mtdName) {
        return this.m_methodSymbolTable.getDependents(mtdName);
    }

    @Override
    public Map<MethodName, List<D>> getUnresolvedMethodDependents() {
        HashMap<MethodName, List<D>> map = new HashMap<MethodName, List<D>>();
        for (Map.Entry<MethodName, DependencyIndexNode<D>> entry : this.m_unresolvedMtdDependents.entrySet()) {
            map.put(entry.getKey(), entry.getValue().getDependents());
        }
        return map;
    }

    public TypeSpaceLocker getLocker() {
        return this.m_locker;
    }

    public TypeSpace<T, D> addGroup(Group<T> group) {
        if (group == null || group.getName() == null) {
            return this;
        }
        try {
            this.m_locker.lockExclusive();
            String groupName = group.getName();
            if (this.m_groups.containsKey(groupName)) {
                if (this.m_groups.get(groupName) == group) {
                    TypeSpace typeSpace = this;
                    return typeSpace;
                }
                throw new RuntimeException("Group with same name already exists:" + groupName);
            }
            this.m_groups.put(groupName, group);
            this.m_groupSymbolMap.put(group, new GroupSymbolMapTable(group));
            group.setTypeSpace(this);
            GroupDependencyNode<T> node = this.getGroupDependencyNode(groupName);
            node.setGroup(group);
            TypeSpace typeSpace = this;
            return typeSpace;
        }
        finally {
            this.m_locker.releaseExclusive();
        }
    }

    public TypeSpace<T, D> removeGroup(String groupName) {
        if (groupName == null) {
            return this;
        }
        try {
            this.m_locker.lockExclusive();
            Group<T> group = this.m_groups.remove(groupName);
            this.m_groupSymbolMap.remove(group);
            GroupDependencyNode node = this.getGroupDependencyNode(groupName);
            node.setGroup(null);
            for (GroupDependencyNode d : node.getDependencies().values()) {
                d.removeDependent(node);
            }
            group = null;
            TypeSpace typeSpace = this;
            return typeSpace;
        }
        finally {
            this.m_locker.releaseExclusive();
        }
    }

    public List<String> getPackages() {
        ArrayList<String> listPackages = new ArrayList<String>();
        for (String packageName : this.m_packages.keySet()) {
            listPackages.add(packageName);
        }
        return listPackages;
    }

    public Map<TypeName, T> getTypes(String packageName) {
        return this.m_packages.get(packageName);
    }

    public List<T> getPackageDependents(String packageName) {
        Map<TypeName, T> types = this.m_packages.get(packageName);
        ArrayList<Object> dependents = new ArrayList<Object>();
        LinkedHashMap<T, T> uniqueDependents = new LinkedHashMap<T, T>();
        for (TypeName typeName : types.keySet()) {
            List<T> typeDependents = this.getDirectDependents(typeName);
            if (typeDependents != null) {
                for (T type : typeDependents) {
                    uniqueDependents.put(type, type);
                }
            }
            T currType = types.get(typeName);
            uniqueDependents.put(currType, currType);
        }
        for (Object type : uniqueDependents.keySet()) {
            dependents.add(type);
        }
        return dependents;
    }

    public void addTypeToPackage(String packageName, TypeName typeName, T type) {
        try {
            this.m_locker.lockExclusive();
            Map<TypeName, T> mapTypes = this.m_packages.get(packageName);
            if (mapTypes == null) {
                mapTypes = new LinkedHashMap<TypeName, T>();
                this.m_packages.put(packageName, mapTypes);
            }
            mapTypes.put(typeName, type);
        }
        finally {
            this.m_locker.releaseExclusive();
        }
    }

    public void removeTypeFromPackage(String packageName, TypeName typeName) {
        try {
            this.m_locker.lockExclusive();
            Map<TypeName, T> mapTypes = this.m_packages.get(packageName);
            if (mapTypes != null) {
                mapTypes.remove(typeName);
                if (mapTypes.isEmpty()) {
                    this.m_packages.remove(packageName);
                }
            }
        }
        finally {
            this.m_locker.releaseExclusive();
        }
    }

    public T renameType(TypeName oldName, String newName) {
        if (oldName == null || newName == null) {
            return null;
        }
        try {
            this.m_locker.lockExclusive();
            IGroup group = this.getGroup(oldName.groupName());
            if (group == null) {
                throw new RuntimeException("cannot find group for type:" + oldName);
            }
            Object type = ((Group)group).getEntity(oldName.typeName());
            if (type == null) {
                throw new RuntimeException("cannot find type:" + oldName);
            }
            ((Group)group).renameEntity(oldName.typeName(), newName);
            this.m_propertySymbolTable.renameType(oldName, newName);
            this.m_methodSymbolTable.renameType(oldName, newName);
            Object e = type;
            return (T)e;
        }
        finally {
            this.m_locker.releaseExclusive();
        }
    }

    public TypeSpace<T, D> addPropertyIndex(TypeName typeName, PropertyIndex<T, D> index) {
        this.m_propertySymbolTable.addIndex(typeName, index);
        return this;
    }

    public void renameProperty(PropertyName oldName, String newName) {
        if (oldName == null || newName == null) {
            return;
        }
        try {
            this.m_locker.lockExclusive();
            PropertyIndex<T, D> index = this.getPropertyIndex(oldName.typeName());
            if (index == null) {
                throw new RuntimeException("cannot find property index for type:" + oldName.typeName());
            }
            index.renameEntity(oldName.propertyName(), newName);
        }
        finally {
            this.m_locker.releaseExclusive();
        }
    }

    public TypeSpace<T, D> removePropertyIndex(TypeName typeName) {
        this.m_propertySymbolTable.removeIndex(typeName);
        return this;
    }

    public TypeSpace<T, D> addMethodIndex(TypeName typeName, MethodIndex<T, D> index) {
        this.m_methodSymbolTable.addIndex(typeName, index);
        return this;
    }

    public void renameMethod(MethodName oldName, String newName) {
        if (oldName == null || newName == null) {
            return;
        }
        try {
            this.m_locker.lockExclusive();
            MethodIndex<T, D> index = this.getMethodIndex(oldName.typeName());
            if (index == null) {
                throw new RuntimeException("cannot find method index for type:" + oldName.typeName());
            }
            index.renameEntity(oldName.methodName(), newName);
        }
        finally {
            this.m_locker.releaseExclusive();
        }
    }

    public TypeSpace<T, D> removeMethodIndex(TypeName typeName) {
        this.m_methodSymbolTable.removeIndex(typeName);
        return this;
    }

    public TypeSpace<T, D> addToUnresolvedIndexNode(PropertyName pty, DependencyIndexNode<D> indexNode) {
        if (pty == null || indexNode == null) {
            return this;
        }
        try {
            this.m_locker.lockExclusive();
            if (!indexNode.getDependents().isEmpty()) {
                this.m_unresolvedPtyDependents.put(pty, indexNode);
            }
            TypeSpace typeSpace = this;
            return typeSpace;
        }
        finally {
            this.m_locker.releaseExclusive();
        }
    }

    public TypeSpace<T, D> addToUnresolvedIndexNode(MethodName mtd, DependencyIndexNode<D> indexNode) {
        if (mtd == null || indexNode == null) {
            return this;
        }
        try {
            this.m_locker.lockExclusive();
            if (!indexNode.getDependents().isEmpty()) {
                this.m_unresolvedMtdDependents.put(mtd, indexNode);
            }
            TypeSpace typeSpace = this;
            return typeSpace;
        }
        finally {
            this.m_locker.releaseExclusive();
        }
    }

    public DependencyIndexNode<D> getUnresolvedIndexNode(MethodName mtd) {
        if (mtd == null) {
            return null;
        }
        return this.m_unresolvedMtdDependents.get(mtd);
    }

    public DependencyIndexNode<D> getUnresolvedIndexNode(PropertyName pty) {
        if (pty == null) {
            return null;
        }
        return this.m_unresolvedPtyDependents.get(pty);
    }

    public synchronized Map<String, DependencyNode<T>> getUnresolvedNodes() {
        return Collections.unmodifiableMap(this.m_unresolvedNodes);
    }

    public synchronized void removeUnresolvedNode(String name) {
        this.m_unresolvedNodes.remove(name);
    }

    public synchronized void addUnresolvedNode(DependencyNode<T> node) {
        this.m_unresolvedNodes.put(node.getName(), node);
    }

    @Override
    public Iterable<T> enumerateTypes() {
        IdentityHashSet retval = new IdentityHashSet();
        try {
            this.m_locker.lockExclusive();
            for (Group<T> g : this.m_groups.values()) {
                retval.addAll(g.getEntities().values());
            }
        }
        finally {
            this.m_locker.releaseExclusive();
        }
        return retval;
    }

    private void addToTempGroupGlobalNameTbl(Map<String, List<GlobalNameEntry>> table, String groupName, String shortName, String longName) {
        List<GlobalNameEntry> listOfNames = table.get(groupName);
        LinkedHashMap<String, GlobalNameEntry> listOfNamesSet = new LinkedHashMap<String, GlobalNameEntry>();
        if (listOfNames == null) {
            listOfNames = new ArrayList<GlobalNameEntry>();
            table.put(groupName, listOfNames);
        }
        GlobalNameEntry globalNameEntry = new GlobalNameEntry(shortName, longName);
        listOfNames.add(globalNameEntry);
        listOfNamesSet.put(shortName, globalNameEntry);
    }

    private void addToTempGroupGlobalVarTypeTable(Map<String, List<GlobalNameEntry>> table, TypeName typeName) {
        List<GlobalNameEntry> listOfNames = table.get(typeName.groupName());
        if (listOfNames == null) {
            listOfNames = new ArrayList<GlobalNameEntry>();
            table.put(typeName.groupName(), listOfNames);
        }
        listOfNames.add(new GlobalNameEntry(typeName));
    }

    private void addToTempGroupGlobalNameTbl(Map<String, List<GlobalNameEntry>> table, TypeName typeName) {
        List<GlobalNameEntry> listOfNames = table.get(typeName.groupName());
        if (listOfNames == null) {
            listOfNames = new ArrayList<GlobalNameEntry>();
            table.put(typeName.groupName(), listOfNames);
        }
        listOfNames.add(new GlobalNameEntry(typeName));
    }

    private void addTempGlobalNameToGroup(Group<T> group, Map<String, List<GlobalNameEntry>> nameTable, GlobalNameType type) {
        List<GlobalNameEntry> listNames;
        if (group != null && (listNames = nameTable.get(group.getName())) != null) {
            GroupSymbolMapTable<T, D> groupSymbolTable = this.m_groupSymbolMap.get(group);
            for (GlobalNameEntry entry : listNames) {
                switch (type) {
                    case TYPE: {
                        groupSymbolTable.addGlobal(entry.m_shortName, entry.m_longName, true);
                        break;
                    }
                    case MEMBER: {
                        groupSymbolTable.addGlobal(entry.m_shortName, TypeSpace.extractTypeName(entry.m_longName));
                        break;
                    }
                    case ALLMEMBER: {
                        groupSymbolTable.addGlobalType(entry.m_typeName.typeName());
                        break;
                    }
                }
            }
        }
    }

    private synchronized void addAllTempGlobalNameToGroup(Group<T> group) {
        this.addTempGlobalNameToGroup(group, this.m_globalTypeNameTbl, GlobalNameType.TYPE);
        this.addTempGlobalNameToGroup(group, this.m_globalMemberNameTbl, GlobalNameType.MEMBER);
        this.addTempGlobalNameToGroup(group, this.m_globalAllTypeMemberNameTbl, GlobalNameType.ALLMEMBER);
        this.addTempGlobalNameToGroup(group, this.m_globalVarTypeMemberNameTbl, GlobalNameType.GLOBALSONLY);
    }

    @Override
    public void addToGlobalSymbolMap(String groupName, String varName, String typeName, D node) {
        IGroup group = this.getGroup(groupName);
        try {
            this.m_locker.lockExclusive();
            if (group != null) {
                this.m_groupSymbolMap.get(group).addGlobal(varName, typeName, node);
            }
        }
        finally {
            this.m_locker.releaseExclusive();
        }
    }

    @Override
    public void addToGlobalTypeSymbolMap(String groupName, String globalTypeName, String fullyQualifiedTypeName) {
        IGroup group = this.getGroup(groupName);
        try {
            this.m_locker.lockExclusive();
            if (group != null) {
                this.m_groupSymbolMap.get(group).addGlobal(globalTypeName, fullyQualifiedTypeName, true);
            } else {
                this.addToTempGroupGlobalNameTbl(this.m_globalTypeNameTbl, groupName, globalTypeName, fullyQualifiedTypeName);
            }
        }
        finally {
            this.m_locker.releaseExclusive();
        }
    }

    @Override
    public void addToGlobalMemberSymbolMap(String groupName, String globalMemberName, String fullyQualifiedMethodName) {
        IGroup group = this.getGroup(groupName);
        try {
            this.m_locker.lockExclusive();
            if (group != null) {
                this.m_groupSymbolMap.get(group).addGlobal(globalMemberName, TypeSpace.extractTypeName(fullyQualifiedMethodName));
            } else {
                this.addToTempGroupGlobalNameTbl(this.m_globalMemberNameTbl, groupName, globalMemberName, fullyQualifiedMethodName);
            }
        }
        finally {
            this.m_locker.releaseExclusive();
        }
    }

    @Override
    public void addAllGlobalTypeMembers(TypeName typeName) {
        IGroup group = this.getGroup(typeName.groupName());
        try {
            this.m_locker.lockExclusive();
            if (group != null) {
                this.m_groupSymbolMap.get(group).addGlobalType(typeName.typeName());
            } else {
                this.addToTempGroupGlobalNameTbl(this.m_globalAllTypeMemberNameTbl, typeName);
            }
        }
        finally {
            this.m_locker.releaseExclusive();
        }
    }

    public List<GroupSymbolMapTable.GlobalSymbolMapEntry<D>> getAllGlobalTypes(String groupName) {
        if (groupName == null || groupName.length() == 0) {
            return this.getAllGlobalTypes();
        }
        IGroup group = this.getGroup(groupName);
        if (group != null) {
            this.addAllTempGlobalNameToGroup((Group<T>)group);
            return this.getAllGlobalTypes((Group<T>)group);
        }
        return Collections.emptyList();
    }

    public List<GroupSymbolMapTable.GlobalSymbolMapEntry<D>> getAllGlobalTypes() {
        ArrayList<GroupSymbolMapTable.GlobalSymbolMapEntry<D>> list = new ArrayList<GroupSymbolMapTable.GlobalSymbolMapEntry<D>>();
        for (Group<T> group : this.m_groups.values()) {
            this.addAllTempGlobalNameToGroup(group);
            list.addAll(this.getAllGlobalTypes(group));
        }
        return list;
    }

    public T getGlobalType(String groupName, String typeName) {
        if (groupName == null || groupName.length() == 0) {
            return this.getGlobalType(typeName);
        }
        IGroup group = this.getGroup(groupName);
        if (group != null) {
            this.addAllTempGlobalNameToGroup((Group<T>)group);
            return this.getGlobalType((Group<T>)group, typeName);
        }
        return null;
    }

    public T getGlobalType(String typeName) {
        for (Group<T> group : this.m_groups.values()) {
            this.addAllTempGlobalNameToGroup(group);
            T type = this.getGlobalType(group, typeName);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public D getGlobalMethod(String groupName, String methodName) {
        if (groupName == null || groupName.length() == 0) {
            return this.getGlobalMethod(methodName);
        }
        IGroup group = this.getGroup(groupName);
        if (group != null) {
            this.addAllTempGlobalNameToGroup((Group<T>)group);
            return this.getGlobalMethod((Group<T>)group, methodName);
        }
        return null;
    }

    public D getGlobalMethod(String methodName) {
        for (Group<T> group : this.m_groups.values()) {
            this.addAllTempGlobalNameToGroup(group);
            D method = this.getGlobalMethod(group, methodName);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public List<D> getAllGlobalVars(String groupName) {
        if (groupName == null || groupName.length() == 0) {
            return this.getAllGlobalVars();
        }
        IGroup group = this.getGroup(groupName);
        if (group != null) {
            this.addAllTempGlobalNameToGroup((Group<T>)group);
            return this.getAllGlobalVars((Group<T>)group);
        }
        return Collections.emptyList();
    }

    public List<D> getAllGlobalVars() {
        ArrayList<D> list = new ArrayList<D>();
        for (Group<T> group : this.m_groups.values()) {
            this.addAllTempGlobalNameToGroup(group);
            list.addAll(this.getAllGlobalVars(group));
        }
        return list;
    }

    public D getGlobalVar(String groupName, String varName) {
        if (groupName == null || groupName.length() == 0) {
            return this.getGlobalVar(varName);
        }
        IGroup group = this.getGroup(groupName);
        if (group != null) {
            this.addAllTempGlobalNameToGroup((Group<T>)group);
            return this.getGlobalVar((Group<T>)group, varName);
        }
        return null;
    }

    public D getGlobalVar(String propertyName) {
        for (Group<T> group : this.m_groups.values()) {
            this.addAllTempGlobalNameToGroup(group);
            D property = this.getGlobalVar(group, propertyName);
            if (property == null) continue;
            return property;
        }
        return null;
    }

    @Override
    public void removeGlobalsFromType(String groupName, String typeName) {
        IGroup group = this.getGroup(groupName);
        try {
            this.m_locker.lockExclusive();
            if (group != null) {
                this.removeTypesGlobals((Group<T>)group, typeName);
            }
        }
        finally {
            this.m_locker.releaseExclusive();
        }
    }

    @Override
    public boolean hasGlobalExtension(String globalVarName) {
        for (GroupSymbolMapTable<T, D> map : this.m_groupSymbolMap.values()) {
            if (!map.hasExtension(globalVarName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<D> getGlobalExtensions(String globalVarName) {
        ArrayList<D> extensions = new ArrayList<D>();
        for (GroupSymbolMapTable<T, D> map : this.m_groupSymbolMap.values()) {
            if (!map.hasExtension(globalVarName)) continue;
            extensions.addAll(map.getExtensions(globalVarName));
        }
        return extensions;
    }

    private List<GroupSymbolMapTable.GlobalSymbolMapEntry<D>> getAllGlobalTypes(Group<T> group) {
        GroupSymbolMapTable<T, D> map = this.m_groupSymbolMap.get(group);
        map.promoteGlobalTypeMembers();
        return map.getAllGlobalTypes();
    }

    private T getGlobalType(Group<T> group, String typeName) {
        GroupSymbolMapTable<T, D> map = this.m_groupSymbolMap.get(group);
        map.promoteGlobalTypeMembers();
        return map.getGlobalType(typeName);
    }

    private D getGlobalMethod(Group<T> group, String methodName) {
        GroupSymbolMapTable<T, D> map = this.m_groupSymbolMap.get(group);
        map.promoteGlobalTypeMembers();
        return map.getGlobalMethod(methodName);
    }

    private List<D> getAllGlobalVars(Group<T> group) {
        GroupSymbolMapTable<T, D> map = this.m_groupSymbolMap.get(group);
        map.promoteGlobalTypeMembers();
        return map.getAllGlobalVars();
    }

    private D getGlobalVar(Group<T> group, String propertyName) {
        GroupSymbolMapTable<T, D> map = this.m_groupSymbolMap.get(group);
        map.promoteGlobalTypeMembers();
        return this.m_groupSymbolMap.get(group).getGlobalVar(propertyName);
    }

    private void removeTypesGlobals(Group<T> group, String typeName) {
        this.m_groupSymbolMap.get(group).removeGlobalVarsFromType(typeName);
    }

    private static String extractTypeName(String fullyQualifiedName) {
        int idx = fullyQualifiedName.lastIndexOf(".");
        if (idx > 0) {
            return fullyQualifiedName.substring(0, idx);
        }
        return fullyQualifiedName;
    }

    @Override
    public Map<String, T> getAllVisibleAliasNames(IGroup<T> fromGroup) {
        if (fromGroup == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, T> map = new HashMap<String, T>();
        map.putAll(fromGroup.getAliasTypeNames());
        for (IGroup<T> g : fromGroup.getGroupDependency()) {
            map.putAll(g.getAliasTypeNames());
        }
        return map;
    }

    private static class GlobalNameEntry {
        private String m_shortName;
        private String m_longName;
        private TypeName m_typeName;

        GlobalNameEntry(String shortName, String longName) {
            this.m_shortName = shortName;
            this.m_longName = longName;
        }

        GlobalNameEntry(TypeName typeName) {
            this.m_typeName = typeName;
        }
    }

    private static enum GlobalNameType {
        TYPE,
        MEMBER,
        ALLMEMBER,
        GLOBALSONLY;

    }
}

