/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.ts.event.type;

import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.ts.event.ISourceEventCallback;
import org.eclipse.vjet.dsf.ts.event.ISourceEventListener;
import org.eclipse.vjet.dsf.ts.event.dispatch.IEventListenerHandle;
import org.eclipse.vjet.dsf.ts.event.type.ITypeEventListener;
import org.eclipse.vjet.dsf.ts.event.type.TypeEvent;
import org.eclipse.vjet.dsf.ts.type.TypeName;

public final class ModifyTypeEvent
extends TypeEvent {
    private String m_src;
    private String m_groupName;
    private String m_fileName;
    private IJstType m_type;

    public ModifyTypeEvent(TypeName typeName, IJstType jstType) {
        super(typeName);
        if (typeName == null) {
            throw new AssertionError((Object)"typeName cannot be null");
        }
        this.m_src = null;
        this.m_groupName = typeName.groupName();
        this.m_fileName = typeName.typeName();
        this.m_type = jstType;
    }

    public ModifyTypeEvent(String groupName, String fileName, String src) {
        super(new TypeName(groupName, fileName));
        this.m_src = src;
        this.m_groupName = groupName;
        this.m_fileName = fileName;
        this.m_type = null;
    }

    @Override
    public void dispatch(ISourceEventListener listener) {
        if (listener == null || !this.isAppropriateListener(listener)) {
            return;
        }
        ((ITypeEventListener)listener).onTypeModified(this, null, null);
    }

    @Override
    public void dispatch(ISourceEventListener listener, IEventListenerHandle handle, ISourceEventCallback callback) {
        if (listener == null || !this.isAppropriateListener(listener)) {
            return;
        }
        ((ITypeEventListener)listener).onTypeModified(this, handle, callback);
    }

    public String getGroupName() {
        return this.m_groupName;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public String getTypeSource() {
        return this.m_src;
    }

    public IJstType getType() {
        return this.m_type;
    }

    @Override
    public boolean shouldLock() {
        return true;
    }
}

