/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.ts.graph;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.ts.graph.DependencyGraph;
import org.eclipse.vjet.dsf.ts.graph.IDependencyNode;

public class DependencyNode<E>
implements IDependencyNode<E> {
    private final String m_name;
    private final E m_entity;
    private Map<String, DependencyNode<E>> m_dependencies;
    private Map<String, DependencyNode<E>> m_dependents;
    private DependencyGraph<E> m_graph;

    public DependencyNode(String name, E entity, DependencyGraph<E> graph) {
        assert (name != null) : "name cannot be null";
        assert (entity != null) : "entity cannot be null";
        this.m_name = name;
        this.m_entity = entity;
        this.m_graph = graph;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public E getEntity() {
        return this.m_entity;
    }

    @Override
    public synchronized Map<String, DependencyNode<E>> getDependencies() {
        if (this.m_dependencies == null || this.m_dependencies.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.m_dependencies);
    }

    @Override
    public synchronized Map<String, DependencyNode<E>> getDependents() {
        if (this.m_dependents == null || this.m_dependents.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.m_dependents);
    }

    public synchronized void addDependency(DependencyNode<E> node) {
        assert (node != null) : "node cannot be null";
        if (this.m_dependencies == null) {
            this.m_dependencies = new LinkedHashMap<String, DependencyNode<E>>();
        }
        this.m_dependencies.put(node.getName(), node);
    }

    public synchronized void removeDependency(DependencyNode<E> node) {
        assert (node != null) : "node cannot be null";
        if (this.m_dependencies != null) {
            this.m_dependencies.remove(node.getName());
        }
    }

    public synchronized void clearAllDependencies() {
        if (this.m_dependencies != null) {
            this.m_dependencies.clear();
        }
    }

    public synchronized void addDependent(DependencyNode<E> node) {
        assert (node != null) : "node cannot be null";
        if (this.m_dependents == null) {
            this.m_dependents = new LinkedHashMap<String, DependencyNode<E>>();
        }
        this.m_dependents.put(node.getName(), node);
    }

    public synchronized void removeDependent(DependencyNode<E> node) {
        assert (node != null) : "node cannot be null";
        if (this.m_dependents != null) {
            this.m_dependents.remove(node.getName());
        }
    }

    public DependencyGraph<E> getGraph() {
        return this.m_graph;
    }

    public DependencyGraph<E> setGraph(DependencyGraph<E> graph) {
        this.m_graph = graph;
        return this.m_graph;
    }

    public String toString() {
        Z z = new Z();
        z.format((Object)("Node: " + this.m_name));
        if (this.m_dependencies != null) {
            z.format((Object)"   Dependencies:");
            for (String key : this.getDependencies().keySet()) {
                z.format((Object)("   - " + key));
            }
        }
        if (this.m_dependents != null) {
            z.format((Object)"   Dependents:");
            for (String key : this.getDependents().keySet()) {
                z.format((Object)("   - " + key));
            }
        }
        return z.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !IDependencyNode.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        DependencyNode that = (DependencyNode)o;
        if (this.getName() == null && that.getName() != null) {
            return false;
        }
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        String name = this.getName();
        return name == null ? 0 : name.hashCode();
    }
}

