/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.tool.codecompletion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jsgen.shared.validation.common.ScopeId;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.ObjLiteral;
import org.eclipse.vjet.dsf.jst.term.SimpleLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceMgr;
import org.eclipse.vjet.dsf.jstojava.translator.JstUtil;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.IJstCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstComletionOnMessageSend;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCommentCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletionOnQualifiedNameReference;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletionOnSingleNameReference;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstFieldOrMethodCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstKeywordCompletion;
import org.eclipse.vjet.dsf.ts.type.TypeName;
import org.eclipse.vjet.vjo.tool.codecompletion.CodeCompletionUtils;
import org.eclipse.vjet.vjo.tool.codecompletion.IVjoCcProposalData;
import org.eclipse.vjet.vjo.tool.codecompletion.IVjoCcReporter;
import org.eclipse.vjet.vjo.tool.codecompletion.StringUtils;
import org.eclipse.vjet.vjo.tool.codecompletion.VjoCcCtxUtil;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcConstructorGenProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcDerivedPropMethodAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcFunctionGenProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcOverrideProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcPropMethodProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcStaticPropMethodProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.comment.VjoCcCommentUtil;
import org.eclipse.vjet.vjo.tool.codecompletion.handler.VjoCcAdvisorSorter;
import org.eclipse.vjet.vjo.tool.codecompletion.reporter.VjoCcReporter;

public class VjoCcCtx {
    public static final int POSITION_UNKNOWN = 0;
    public static final int POSITION_AFTER_THIS = 1;
    public static final int POSITION_AFTER_THISVJO = 2;
    public static final int POSITION_AFTER_THISVJOTYPE = 3;
    public static final String INFO_KEY_IN_TYPE_SCOPE = "TYPE_SHOW_FULLNAME";
    public static final String INFO_KEY_PARAMETER_HINT = "PARAMETER_HINT_MTDINVOEXPR";
    public static final String INFO_KEY_ARGUMENT = "ARGUMENT_MTDINVOEXPR";
    private List<String> matchAdvisorList = new ArrayList<String>();
    private JstCompletion completion;
    private IJstType actingType;
    private int offset;
    private String m_content;
    private TypeName m_typeName;
    private Map<String, Object> infoMap = new HashMap<String, Object>();
    private IVjoCcReporter reporter = new VjoCcReporter();
    private String actingToken;
    private String actingPackageToken;
    private JstTypeSpaceMgr m_jstTypeSpaceMgr;
    private IJstType calledType;
    private IJstType m_scriptUnit;
    private List<IJstNode> m_scriptNodes = new ArrayList<IJstNode>();
    private List<JstIdentifier> m_identifers = new ArrayList<JstIdentifier>();
    private IJstType m_objType = null;
    private IJstType m_globalType = null;
    private IJstType vjoType;
    private int positionType = 0;
    private boolean mtypeEabled = false;
    private List<String> advisors;
    private boolean commonJsCtx = false;

    public boolean isCommonJsCtx() {
        return this.commonJsCtx;
    }

    public void setCommonJsCtx(boolean commonJsCtx) {
        this.commonJsCtx = commonJsCtx;
    }

    public VjoCcCtx(JstTypeSpaceMgr jstTypeSpaceMgr, TypeName name) {
        this.m_jstTypeSpaceMgr = jstTypeSpaceMgr;
        this.m_typeName = name;
    }

    public IJstNode getJstNode() {
        return this.completion.getParentNode();
    }

    public void putInfo(String key, Object info) {
        this.infoMap.put(key, info);
    }

    public IVjoCcReporter getReporter() {
        return this.reporter;
    }

    public List<IVjoCcProposalData> getProposals() {
        List<IVjoCcProposalData> datas = this.reporter.getProposalData();
        if (!datas.isEmpty()) {
            Collections.sort(datas, new VjoCcAdvisorSorter(this.getActingToken()));
        }
        return datas;
    }

    public IJstType getJstType() {
        if (this.actingType != null) {
            return this.actingType;
        }
        IJstType type = this.completion.getOwnerType();
        if (type == null) {
            type = this.completion.getParentNode();
        }
        return type;
    }

    public JstCompletion getCompletion() {
        return this.completion;
    }

    public boolean isInStaticMethod() {
        return this.isInStatic() && this.completion.inScope(ScopeIds.METHOD);
    }

    public void setCompletion(IJstCompletion completion) {
        this.completion = (JstCompletion)completion;
    }

    public String getToken() {
        return this.getActingToken();
    }

    public JstTypeSpaceMgr getJstTypeSpaceMgr() {
        return this.m_jstTypeSpaceMgr;
    }

    public IJstMethod getContaindMethod() {
        IJstNode node = this.getJstNode();
        while (!(node instanceof IJstMethod) && !(node instanceof IJstType)) {
            node = node.getParentNode();
        }
        if (node instanceof IJstMethod) {
            return (IJstMethod)node;
        }
        return null;
    }

    public boolean isInStatic() {
        Stack ss = this.completion.getScopeStack();
        Iterator it = ss.iterator();
        ScopeId lastScope = null;
        while (it.hasNext()) {
            ScopeId scope = (ScopeId)it.next();
            if (!this.ifConsider(scope)) continue;
            lastScope = scope;
        }
        return lastScope == null || lastScope != ScopeIds.PROTOS;
    }

    private boolean ifConsider(ScopeId scope) {
        return scope == ScopeIds.PROPS || scope == ScopeIds.PROTOS || scope == ScopeIds.DEFS || scope == ScopeIds.INITS;
    }

    public IJstType getCalledType() {
        if (this.calledType != null) {
            return this.calledType;
        }
        if (this.completion == null) {
            return this.getActingType();
        }
        String token = this.completion.getToken();
        if (StringUtils.isBlankOrEmpty(token)) {
            return this.getActingType();
        }
        IJstNode node = this.getJstNode();
        IJstType type = this.getTypeFromNode(node);
        return type;
    }

    public IJstType getActingType() {
        if (this.actingType == null) {
            if (this.completion == null) {
                return null;
            }
            if (this.completion.getOwnerType() != null) {
                return this.completion.getOwnerType();
            }
            return this.completion.getParentNode();
        }
        return this.actingType;
    }

    public void setActingType(IJstType actingType) {
        this.actingType = actingType;
    }

    public void setActingToken(String string) {
        this.actingToken = string;
    }

    public String getActingToken() {
        if (this.actingToken == null) {
            if (this.completion != null) {
                if (this.completion instanceof JstFieldOrMethodCompletion) {
                    return this.completion.getCompositeToken();
                }
                return this.completion.getToken();
            }
            return this.calculateToken();
        }
        return this.actingToken;
    }

    public String getActingPackageToken() {
        if (this.actingPackageToken == null) {
            return this.getActingToken();
        }
        return this.actingPackageToken;
    }

    public String calculateToken() {
        int i = this.offset - 1;
        while (i >= 0) {
            char c = this.m_content.charAt(i);
            if (!StringUtils.isLetter(c)) break;
            --i;
        }
        if (i == this.offset - 1) {
            return "";
        }
        return this.m_content.substring(i + 1, this.offset);
    }

    public void setCalledType(IJstType calledType) {
        this.calledType = calledType;
    }

    protected IJstType getTypeFromNode(IJstNode jstNode) {
        if (jstNode instanceof IJstType) {
            return (IJstType)jstNode;
        }
        if (jstNode instanceof JstIdentifier) {
            JstIdentifier ji = (JstIdentifier)jstNode;
            return ji.getType();
        }
        return null;
    }

    public List<IJstNode> getSelectedJstNodes() {
        ArrayList<IJstNode> result = new ArrayList<IJstNode>();
        this.innerGetSelectedNode((IJstNode)this.getActingType(), this.offset, result);
        return result;
    }

    public IJstMethod getSelectedJstMethod() {
        List<IJstNode> nodes = this.getSelectedJstNodes();
        if (nodes.isEmpty()) {
            return null;
        }
        for (IJstNode node : nodes) {
            if (!(node instanceof IJstMethod)) continue;
            return (IJstMethod)node;
        }
        return null;
    }

    public List<IJstMethod> getSelectedJstMethods() {
        List<IJstNode> nodes = this.getSelectedJstNodes();
        if (nodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IJstMethod> methods = new ArrayList<IJstMethod>();
        for (IJstNode node : nodes) {
            if (node instanceof IJstMethod) {
                methods.add((IJstMethod)node);
            }
            if (!(node instanceof JstBlock) || !(node.getParentNode() instanceof IJstMethod)) continue;
            methods.add((IJstMethod)node.getParentNode());
        }
        return methods;
    }

    private void innerGetSelectedNode(IJstNode pnode, int i, List<IJstNode> result) {
        if (pnode == null) {
            return;
        }
        List nodes = pnode.getChildren();
        for (IJstNode node : nodes) {
            if (node == null) continue;
            if (this.isInNode(node, i)) {
                result.add(node);
            }
            this.innerGetSelectedNode(node, i, result);
        }
    }

    private boolean isInNode(IJstNode jnode, int i) {
        if (jnode instanceof JstCompletion) {
            return false;
        }
        JstSource source = jnode.getSource();
        return source != null && source.getStartOffSet() < i && source.getEndOffSet() >= i;
    }

    public void setOffset(int position) {
        this.offset = position;
    }

    public List<JstVars> getJstVars(IJstMethod method) {
        ArrayList<JstVars> result = new ArrayList<JstVars>();
        this.innerGetJstVars((IJstNode)method, result);
        return result;
    }

    public static List<String> getArgStringList(IJstMethod method) {
        List list = method.getArgs();
        ArrayList<String> argList = new ArrayList<String>();
        for (JstArg arg : list) {
            argList.add(arg.getName());
        }
        return argList;
    }

    private void innerGetJstVars(IJstNode pnode, List<JstVars> result) {
        List nodes = pnode.getChildren();
        for (IJstNode node : nodes) {
            JstVars jnode;
            if (node != null && node instanceof JstVars && this.isVariableBeforeOffset(jnode = (JstVars)node, this.offset)) {
                result.add(jnode);
            }
            this.innerGetJstVars(node, result);
        }
    }

    private boolean isVariableBeforeOffset(JstVars jstVar, int i) {
        return true;
    }

    public void setScriptUnit(IJstType scriptUnit) {
        this.m_scriptUnit = scriptUnit;
        if (this.m_scriptUnit == null) {
            return;
        }
        this.m_scriptNodes = this.getJstNodeFromScriptUnit(this.m_scriptUnit, this.offset);
        this.m_identifers = this.getJstIdentifierFromScriptUnit(this.m_scriptUnit, this.offset);
        Collections.reverse(this.m_scriptNodes);
    }

    public boolean isInSciptUnitArea() {
        if (this.completion != null && !(this.completion instanceof JstKeywordCompletion)) {
            return false;
        }
        for (IJstNode child : this.m_scriptNodes) {
            if (!(child instanceof ObjLiteral)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmptyScriptNodes() {
        return this.m_scriptNodes.isEmpty();
    }

    private List<IJstNode> getJstNodeFromScriptUnit(IJstType unit, int position) {
        ArrayList<IJstNode> result = new ArrayList<IJstNode>();
        JstBlock block = VjoCcCtxUtil.getExactBlock(unit, position);
        if (block != null) {
            this.innerSFindNode((IJstNode)block, position, result);
        }
        return result;
    }

    private void innerSFindNode(IJstNode node, int position, List<IJstNode> result) {
        List nodes;
        if (node == null) {
            return;
        }
        JstSource source = node.getSource();
        if (source != null) {
            int endPos = source.getEndOffSet();
            if (node instanceof JstIdentifier) {
                ++endPos;
            }
            if (source.getStartOffSet() <= position && source.getEndOffSet() + 1 >= position) {
                result.add(node);
            }
        }
        if ((nodes = node.getChildren()).isEmpty()) {
            return;
        }
        for (IJstNode temp : nodes) {
            this.innerSFindNode(temp, position, result);
        }
    }

    private void innerSFindIdentifer(IJstNode node, int position, List<JstIdentifier> result) {
        List nodes;
        JstSource source;
        if (node == null) {
            return;
        }
        if (node instanceof JstIdentifier && (source = node.getSource()) != null && source.getEndOffSet() + 1 < position) {
            result.add((JstIdentifier)node);
        }
        if ((nodes = node.getChildren()).isEmpty()) {
            return;
        }
        for (IJstNode temp : nodes) {
            this.innerSFindIdentifer(temp, position, result);
        }
    }

    private List<JstIdentifier> getJstIdentifierFromScriptUnit(IJstType unit, int position) {
        ArrayList<JstIdentifier> result = new ArrayList<JstIdentifier>();
        JstBlock block = VjoCcCtxUtil.getExactBlock(unit, position);
        if (block != null) {
            this.innerSFindIdentifer((IJstNode)block, position, result);
        }
        return result;
    }

    public MtdInvocationExpr getSMtdInvo() {
        if (this.m_scriptNodes.isEmpty()) {
            return null;
        }
        for (IJstNode child : this.m_scriptNodes) {
            MtdInvocationExpr mtd;
            if (child instanceof MtdInvocationExpr) {
                return (MtdInvocationExpr)child;
            }
            if (!(child instanceof FieldAccessExpr) || (mtd = this.getMtdFromFieldAccExpr((FieldAccessExpr)child)) == null) continue;
            return mtd;
        }
        return null;
    }

    private MtdInvocationExpr getMtdFromFieldAccExpr(FieldAccessExpr fieldAccExpr) {
        List nodes = fieldAccExpr.getChildren();
        if (nodes == null) {
            return null;
        }
        for (BaseJstNode node : nodes) {
            if (!(node instanceof MtdInvocationExpr)) continue;
            return (MtdInvocationExpr)node;
        }
        return null;
    }

    public JstIdentifier getSIdentifer() {
        if (this.m_identifers.isEmpty()) {
            return null;
        }
        return this.m_identifers.get(0);
    }

    public JstIdentifier getSFirstIdentifer() {
        if (this.m_identifers.isEmpty()) {
            return null;
        }
        return this.m_identifers.get(this.m_identifers.size() - 1);
    }

    public String[] getSKeywordStack() {
        Iterator<JstIdentifier> it = this.m_identifers.iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            list.add(it.next().getName());
        }
        String[] ss = new String[list.size()];
        list.toArray(ss);
        return ss;
    }

    public String getSSimpleToken() {
        SimpleLiteral sl = this.getSSimpleLiteral();
        String str = sl.getValue();
        JstSource source = sl.getSource();
        if (StringUtils.isBlankOrEmpty(str) || source == null) {
            return "";
        }
        int subp = this.offset - source.getStartOffSet();
        if (subp <= 0 || subp > str.length() + 1) {
            return null;
        }
        return str.substring(0, subp - 1);
    }

    public String getSLastToken() {
        SimpleLiteral sl = this.getSSimpleLiteral();
        String str = sl.getValue();
        JstSource source = sl.getSource();
        if (StringUtils.isBlankOrEmpty(str) || source == null) {
            return "";
        }
        int subp = this.offset - source.getStartOffSet();
        if (subp <= 0 || subp > str.length() + 1) {
            return null;
        }
        return str.substring(0, subp - 1);
    }

    private void innerGetStack(MtdInvocationExpr mtd, List<String> list) {
        List nodes = mtd.getChildren();
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        for (IJstNode node : nodes) {
            if (node == null || !(node instanceof JstIdentifier)) continue;
            JstIdentifier jid = (JstIdentifier)node;
            list.add(jid.getName());
        }
        for (IJstNode node : nodes) {
            if (node == null || !(node instanceof MtdInvocationExpr)) continue;
            MtdInvocationExpr mtdEx = (MtdInvocationExpr)node;
            this.innerGetStack(mtdEx, list);
        }
    }

    public SimpleLiteral getSSimpleLiteral() {
        if (this.m_scriptNodes.isEmpty()) {
            return null;
        }
        for (IJstNode child : this.m_scriptNodes) {
            if (!(child instanceof SimpleLiteral)) continue;
            return (SimpleLiteral)child;
        }
        return null;
    }

    public TypeName getTypeNameObj() {
        return this.m_typeName;
    }

    public String getTypeName() {
        return this.m_typeName.typeName();
    }

    public String getGroupName() {
        return this.m_typeName.groupName();
    }

    public String getReplacedToken() {
        return this.getActingToken();
    }

    public String getReplacedPackageToken() {
        if (StringUtils.isBlankOrEmpty(this.actingPackageToken)) {
            return this.getReplacedToken();
        }
        return this.actingPackageToken;
    }

    public void setActingPackageToken(String token) {
        this.actingPackageToken = token;
    }

    public String getTypeStr() {
        String[] ss = this.getSKeywordStack();
        int i = 0;
        while (i < ss.length) {
            String s = ss[i];
            if (CodeCompletionUtils.isTypeDeclare(s)) {
                return s;
            }
            ++i;
        }
        return "";
    }

    public String getSTypeStrForCC() {
        String[] ss = this.getSKeywordStack();
        if (ss.length < 2) {
            return "";
        }
        int i = 0;
        if (!this.ifSContainKeyword(ss[0])) {
            i = 1;
        }
        while (i < ss.length) {
            String s = ss[i];
            if (CodeCompletionUtils.isTypeDeclare(s)) {
                return s;
            }
            ++i;
        }
        return "";
    }

    public boolean ifSContainKeyword(String vjoKeyword) {
        String[] ss = this.getSKeywordStack();
        if (ss.length < 2) {
            return false;
        }
        if (!vjoKeyword.equals(ss[0])) {
            return false;
        }
        String t = this.m_content.substring(0, this.offset - 1);
        return t.contains(vjoKeyword);
    }

    public Object getInfo(String key) {
        return this.infoMap.get(key);
    }

    public IJstType findBaseType(String name) {
        if (name == null) {
            return null;
        }
        IJstType type = this.getVjoType();
        if ("vjo".equals(name)) {
            return type;
        }
        List nodes = type.getChildren();
        for (IJstNode node : nodes) {
            JstTypeReference rtype;
            IJstType ttype;
            if (node instanceof IJstType) {
                IJstType ttype2 = (IJstType)node;
                if (!name.equals(ttype2.getSimpleName())) continue;
                return ttype2;
            }
            if (!(node instanceof JstTypeReference) || (ttype = (rtype = (JstTypeReference)node).getReferencedType()) == null || !name.equals(ttype.getSimpleName())) continue;
            return ttype;
        }
        return null;
    }

    private IJstType getVjoType() {
        if (this.vjoType == null) {
            this.vjoType = this.getJstTypeSpaceMgr().getQueryExecutor().findType(new TypeName("VjoSelfDescribed", "vjo"));
        }
        return this.vjoType;
    }

    public boolean callFromDifferentType(IJstMethod method) {
        IJstType calledType;
        IJstType callingType = this.getActingType();
        return callingType != (calledType = method.getOwnerType());
    }

    public boolean callFromDifferentType(IJstProperty property) {
        IJstType calledType;
        IJstType callingType = this.getActingType();
        return callingType != (calledType = property.getOwnerType());
    }

    public IJstType getGlobalType() {
        if (this.m_globalType == null) {
            this.m_globalType = this.getJstTypeSpaceMgr().getQueryExecutor().findType(new TypeName("JsNativeLib", "Global"));
        }
        return this.m_globalType;
    }

    public IJstType getObjectType() {
        if (this.m_objType == null) {
            this.m_objType = this.getJstTypeSpaceMgr().getQueryExecutor().findType(new TypeName("JsNativeLib", "Object"));
        }
        return this.m_objType;
    }

    public void setContent(String content) {
        this.m_content = content;
    }

    public String getOriginalToken() {
        if (this.completion == null) {
            return "";
        }
        String t = this.completion.getToken();
        if (StringUtils.isBlankOrEmpty(t)) {
            return "";
        }
        return t;
    }

    public int getPositionType() {
        return this.positionType;
    }

    public void setPositionType(int positionType) {
        this.positionType = positionType;
    }

    public boolean isVjoMethod(IJstMethod method) {
        IJstType type = method.getOwnerType();
        IJstType rtype = method.getRtnType();
        return this.isSelfDescibedType(type) && this.isSelfDescibedType(rtype);
    }

    public boolean isSelfDescibedType(IJstType type) {
        if (type == null || type.getName() == null) {
            return false;
        }
        String typeName = type.getName();
        if (typeName.startsWith("vjo.") || typeName.equals("vjo")) {
            return type.getPackage() != null && "VjoSelfDescribed".equals(type.getPackage().getGroupName());
        }
        return false;
    }

    public boolean callFromClass(JstCompletion jstCompl, IJstType jstType) {
        return jstType instanceof IJstRefType;
    }

    private boolean nameCheck(String token, String name) {
        if (name == null) {
            return false;
        }
        if (!token.startsWith(name)) {
            return false;
        }
        String subStr = token.substring(name.length());
        if (subStr.startsWith(".")) {
            subStr = subStr.substring(1, subStr.length());
        }
        return !subStr.contains(".");
    }

    public boolean hasNoPrefix() {
        return this.completion != null && (this.completion instanceof JstCompletionOnSingleNameReference || this.completion instanceof JstComletionOnMessageSend);
    }

    public void exactMatch(String advisorId) {
        if (!this.matchAdvisorList.contains(advisorId)) {
            this.matchAdvisorList.add(advisorId);
        }
    }

    private boolean hasExactmatch(String advisorId) {
        return this.matchAdvisorList.contains(advisorId);
    }

    public boolean needAdvisor(String id) {
        if (VjoCcFunctionGenProposalAdvisor.ID.equals(id)) {
            return !this.hasExactmatch(VjoCcConstructorGenProposalAdvisor.ID) && !this.hasExactmatch(VjoCcOverrideProposalAdvisor.ID);
        }
        return true;
    }

    public static boolean isVoidType(IJstType type) {
        return type == null || "void".equals(type.getName());
    }

    public boolean isInObjectCreateExpr() {
        String s;
        int i = this.offset - 1;
        while (i >= 0) {
            char c = this.m_content.charAt(i);
            if (!StringUtils.isLetter(c)) break;
            --i;
        }
        if ((s = this.m_content.substring(0, i)).trim().endsWith("new")) {
            return !StringUtils.isLetter(s.charAt(s.length() - 4));
        }
        return false;
    }

    public IJstNode findNearestNode() {
        IJstType type = this.completion.getOwnerType();
        if (type == null) {
            return null;
        }
        BaseJstNode obj = JstUtil.getLeafNode((IJstType)type, (int)this.offset, (int)this.offset);
        return obj;
    }

    public boolean isMtypeEabled() {
        return this.mtypeEabled;
    }

    public void setMtypeEabled(boolean mtypeEabled) {
        this.mtypeEabled = mtypeEabled;
    }

    public boolean isInMtdCall() {
        Stack ss = this.completion.getScopeStack();
        if (ss.isEmpty()) {
            return false;
        }
        return ScopeIds.METHOD_CALL == ss.peek();
    }

    public int getRelativePosInMtdCall(MtdInvocationExpr mtd) {
        List args = mtd.getArgs();
        if (args == null || args.isEmpty()) {
            return 0;
        }
        int pos = 0;
        for (IExpr node : args) {
            JstSource source = node.getSource();
            if (source == null) {
                ++pos;
                continue;
            }
            if (source.getEndOffSet() >= this.offset) {
                return pos;
            }
            ++pos;
        }
        return pos;
    }

    public boolean ifContainsFullNameCheck() {
        return this.actingPackageToken != null;
    }

    /*
     * Unable to fully structure code
     */
    public int getNeedsPosition() {
        if (this.m_identifers == null || this.m_identifers.isEmpty()) {
            return -1;
        }
        it = this.m_identifers.iterator();
        start = -1;
        preIdentifier = null;
        posFound = false;
        while (it.hasNext()) {
            identifier = it.next();
            exprText = identifier.toExprText();
            if ("needs".equals(exprText) || CodeCompletionUtils.isTypeDeclare(identifier.toExprText())) {
                posFound = true;
                break;
            }
            preIdentifier = identifier;
        }
        if (preIdentifier == null || !posFound) {
            return -1;
        }
        node = preIdentifier.getParentNode();
        if (node instanceof MtdInvocationExpr) {
            source = preIdentifier.getSource();
            start = source.getStartOffSet();
        }
        if (start != -1) ** GOTO lbl26
        return start;
lbl-1000:
        // 1 sources

        {
            if (this.m_content.charAt(start) == '.') {
                return start + 1;
            }
            --start;
lbl26:
            // 2 sources

            ** while (start > 0)
        }
lbl27:
        // 1 sources

        return -1;
    }

    private boolean needInsertNeedsExpr(IJstType type, String typeName) {
        List etypes = type.getImports();
        for (IJstType temp : etypes) {
            if (!typeName.equals(temp.getName())) continue;
            return false;
        }
        IJstType inheritType = type.getExtend();
        if (inheritType != null && typeName.equals(inheritType.getName())) {
            return false;
        }
        List stypes = type.getSatisfies();
        for (IJstType temp : stypes) {
            if (!typeName.equals(temp.getName())) continue;
            return false;
        }
        List innerTypes = type.getEmbededTypes();
        for (IJstType temp : innerTypes) {
            if (!typeName.equals(temp.getName())) continue;
            return false;
        }
        return true;
    }

    public boolean needInsertNeedsExpr(IJstType insertedType) {
        if (this.isCommonJsCtx()) {
            return false;
        }
        String typeName = insertedType.getName();
        if (insertedType.isImpliedImport()) {
            return false;
        }
        IJstType type = this.getActingType();
        IJstNode node = type.getParentNode();
        while (node != null && node instanceof IJstType) {
            type = (IJstType)node;
            node = node.getParentNode();
        }
        if (typeName.equals(type.getName())) {
            return false;
        }
        IJstType insertedOuterType = insertedType.getOuterType();
        if (this.isSelfDescibedType(insertedOuterType)) {
            return false;
        }
        if (!this.needInsertNeedsExpr(type, typeName)) {
            return false;
        }
        List list = type.getEmbededTypes();
        if (list != null && !list.isEmpty()) {
            for (IJstType temp : list) {
                if (this.needInsertNeedsExpr(temp, typeName)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean needInsertInactiveNeedsExpr(IJstType insertedType) {
        if (!this.needInsertNeedsExpr(insertedType)) {
            return false;
        }
        if (CodeCompletionUtils.isNativeType(insertedType)) {
            return false;
        }
        String typeName = insertedType.getName();
        IJstType type = this.getActingType();
        List typeRefs = type.getInactiveImportsRef();
        if (typeRefs.isEmpty()) {
            return true;
        }
        for (IJstTypeReference typeRef : typeRefs) {
            if (!typeName.equals(typeRef.getReferencedType().getName())) continue;
            return false;
        }
        return true;
    }

    public void setAdvisors(String[] advisors) {
        this.advisors = Arrays.asList(advisors);
    }

    public boolean containsFieldAdvisors() {
        return this.advisors != null && (this.advisors.contains(VjoCcStaticPropMethodProposalAdvisor.ID) || this.advisors.contains(VjoCcPropMethodProposalAdvisor.ID) || this.advisors.contains(VjoCcDerivedPropMethodAdvisor.ID));
    }

    public boolean isInSimpeLiteral() {
        BaseJstNode node = JstUtil.getLeafNode((IJstType)this.getActingType(), (int)this.offset, (int)this.offset);
        if (node != null && node instanceof SimpleLiteral) {
            SimpleLiteral sl = (SimpleLiteral)node;
            return sl.getSource().getStartOffSet() != this.offset;
        }
        return false;
    }

    public boolean isCalledFromInnerType() {
        IJstType callingType = this.getCalledType();
        IJstType calledType = this.getCalledType();
        if (callingType == null) {
            return false;
        }
        if (calledType != null && callingType != calledType) {
            return false;
        }
        IJstNode outer = callingType.getParentNode();
        return outer != null && outer instanceof IJstType;
    }

    public boolean isAfterFieldAccess() {
        return this.completion != null && this.completion instanceof JstCompletionOnQualifiedNameReference;
    }

    public boolean isInSyntaxScope() {
        Object info = this.getInfo(INFO_KEY_IN_TYPE_SCOPE);
        if (info != null && info instanceof Boolean) {
            return (Boolean)info;
        }
        return false;
    }

    public boolean isInCommentArea() {
        return this.getCompletion() instanceof JstCommentCompletion;
    }

    public boolean isInInactiveArea() {
        if (!this.isInCommentArea()) {
            return false;
        }
        JstCommentCompletion commentCompletion = (JstCommentCompletion)this.completion;
        return VjoCcCommentUtil.isInactiveNeed(commentCompletion);
    }
}

