/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.tool.codecompletion.advisor;

import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstFuncType;
import org.eclipse.vjet.dsf.jst.declaration.JstFunctionRefType;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.vjo.tool.codecompletion.IVjoCcAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.VjoCcCtx;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.AbstractVjoCcAdvisor;

public class VjoCcFunctionArgumentAdvisor
extends AbstractVjoCcAdvisor
implements IVjoCcAdvisor {
    public static final String ID = VjoCcFunctionArgumentAdvisor.class.getName();

    @Override
    public void advise(VjoCcCtx ctx) {
        Object valueOfInfoKeyArgument = ctx.getInfo("ARGUMENT_MTDINVOEXPR");
        if (!(valueOfInfoKeyArgument instanceof IExpr)) {
            return;
        }
        IExpr argument = (IExpr)valueOfInfoKeyArgument;
        if (!(argument.getParentNode() instanceof MtdInvocationExpr)) {
            return;
        }
        MtdInvocationExpr mtdInvocationExpr = (MtdInvocationExpr)argument.getParentNode();
        int position = mtdInvocationExpr.getArgs().indexOf(argument);
        IJstNode node = mtdInvocationExpr.getMethod();
        if (node instanceof JstIdentifier) {
            node = ((JstIdentifier)node).getJstBinding();
        }
        if (node == null || !(node instanceof IJstMethod)) {
            return;
        }
        IJstMethod method = (IJstMethod)node;
        IJstType calledType = method.getOwnerType();
        if (calledType == null) {
            return;
        }
        List arguments = method.getArgs();
        if (arguments.size() <= position) {
            return;
        }
        IJstType parameterType = null;
        IExpr parameterAtPos = (IExpr)mtdInvocationExpr.getArgs().get(position);
        JstArg argAtPosition = (JstArg)arguments.get(position);
        if (!(parameterAtPos instanceof JstIdentifier)) {
            return;
        }
        parameterType = ((JstIdentifier)parameterAtPos).getType();
        if (parameterType == null) {
            parameterType = argAtPosition.getType();
        }
        if (parameterType instanceof JstFuncType) {
            IJstMethod function = ((JstFuncType)parameterType).getFunction();
            if (function.isDispatcher()) {
                for (IJstMethod overload : function.getOverloaded()) {
                    this.appendData(ctx, (IJstNode)this.getParamNamedMethodProposal(argAtPosition, overload), false);
                }
            } else {
                this.appendData(ctx, (IJstNode)this.getParamNamedMethodProposal(argAtPosition, function), true);
            }
        } else if (parameterType instanceof JstFunctionRefType) {
            this.appendData(ctx, (IJstNode)this.getParamNamedMethodProposal(argAtPosition, ((JstFunctionRefType)parameterType).getMethodRef()), true);
        }
    }

    private IJstMethod getParamNamedMethodProposal(JstArg parameterAtPos, IJstMethod method) {
        if (parameterAtPos == null || parameterAtPos.getName() == null) {
            return method;
        }
        return new TranslateHelper.RenameableSynthJstProxyMethod(method, parameterAtPos.getName());
    }
}

