/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.tool.codecompletion.advisor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;
import org.eclipse.vjet.vjo.tool.codecompletion.CodeCompletionUtils;
import org.eclipse.vjet.vjo.tool.codecompletion.IVjoCcAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.VjoCcCtx;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.AbstractVjoCcAdvisor;

public class VjoCcParameterHintAdvisor
extends AbstractVjoCcAdvisor
implements IVjoCcAdvisor {
    public static final String ID = VjoCcParameterHintAdvisor.class.getName();

    @Override
    public void advise(VjoCcCtx ctx) {
        IJstType calledType;
        IJstType callingType = ctx.getActingType();
        Object obj = ctx.getInfo("PARAMETER_HINT_MTDINVOEXPR");
        if (obj == null || !(obj instanceof MtdInvocationExpr)) {
            return;
        }
        MtdInvocationExpr mtd = (MtdInvocationExpr)obj;
        int paraPos = ctx.getRelativePosInMtdCall(mtd);
        IJstNode node = mtd.getMethod();
        if (node == null || !(node instanceof IJstMethod)) {
            return;
        }
        IJstMethod method2 = (IJstMethod)node;
        if (!method2.isDispatcher() && method2.getParentNode() instanceof IJstMethod) {
            method2 = (IJstMethod)method2.getParentNode();
        }
        if ((calledType = method2.getOwnerType()) == null) {
            return;
        }
        boolean isNative = CodeCompletionUtils.isNativeType(calledType);
        int[] levels = this.getCallLevel(callingType, calledType);
        ArrayList<String> tempString = new ArrayList<String>();
        List overloads = JstTypeHelper.getSignatureMethods((IJstMethod)method2);
        if (overloads != null) {
            for (IJstMethod method2 : overloads) {
                if (method2.getArgs().size() < paraPos) continue;
                this.addMethod(method2, levels, isNative, ctx, tempString, true);
            }
        }
    }

    public static boolean isAvailable(MtdInvocationExpr mtd, VjoCcCtx ctx) {
        IJstType callingType = ctx.getActingType();
        int paraPos = ctx.getRelativePosInMtdCall(mtd);
        IJstNode node = mtd.getMethod();
        if (node == null || !(node instanceof IJstMethod)) {
            return false;
        }
        IJstMethod method2 = (IJstMethod)node;
        IJstType calledType = method2.getOwnerType();
        int[] levels = CodeCompletionUtils.getGeneralFieldCallLevel(callingType, calledType);
        List overloads = JstTypeHelper.getSignatureMethods((IJstMethod)method2);
        if (overloads != null) {
            for (IJstMethod method2 : overloads) {
                if (method2.getArgs().size() < paraPos || !CodeCompletionUtils.levelCheck(method2.getModifiers(), levels)) continue;
                return true;
            }
        }
        return false;
    }

    private void addMethod(IJstMethod method, int[] levels, boolean isNative, VjoCcCtx ctx, List<String> tempString, boolean exactMatch) {
        String str;
        if (!(!this.levelCheck(method.getModifiers(), levels) || isNative && method.getName().getName().startsWith("_") || tempString.contains(str = CodeCompletionUtils.getMthodsStr(method)))) {
            tempString.add(str);
            this.appendData(ctx, (IJstNode)method, exactMatch);
        }
    }

    @Override
    protected int[] getCallLevel(IJstType callingType, IJstType calledType) {
        return CodeCompletionUtils.getGeneralFieldCallLevel(callingType, calledType);
    }
}

