/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.tool.codecompletion.advisor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstAttributedType;
import org.eclipse.vjet.dsf.jst.declaration.JstFuncType;
import org.eclipse.vjet.dsf.jst.declaration.JstMixedType;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;
import org.eclipse.vjet.vjo.tool.codecompletion.CodeCompletionUtils;
import org.eclipse.vjet.vjo.tool.codecompletion.IVjoCcAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.VjoCcCtx;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.AbstractVjoCcAdvisor;

public class VjoCcPropMethodProposalAdvisor
extends AbstractVjoCcAdvisor
implements IVjoCcAdvisor {
    public static final String ID = VjoCcPropMethodProposalAdvisor.class.getName();

    @Override
    public void advise(VjoCcCtx ctx) {
        String token = ctx.getActingToken();
        IJstType callingType = ctx.getActingType();
        IJstType calledType = ctx.getCalledType();
        if (calledType == null && callingType == null) {
            return;
        }
        if (calledType == null) {
            calledType = callingType;
        }
        boolean isNative = CodeCompletionUtils.isNativeType(calledType);
        IJstType tempCalledType = calledType;
        int[] levels = this.getCallLevel(callingType, calledType);
        ArrayList<String> tempString = new ArrayList<String>();
        if (calledType instanceof JstFuncType) {
            calledType = ((JstFuncType)calledType).getType();
        }
        List methods = JstTypeHelper.getSignatureMethods((IJstType)calledType, (boolean)false, (boolean)false);
        for (IJstMethod method : methods) {
            boolean exactMatch;
            if (!this.isReferenceByDot(method)) continue;
            if (tempCalledType != method.getOwnerType()) {
                tempCalledType = method.getOwnerType();
                if (tempCalledType == null) {
                    tempCalledType = calledType;
                }
                levels = this.getCallLevel(callingType, tempCalledType);
                isNative = CodeCompletionUtils.isNativeType(tempCalledType);
            }
            boolean bl = exactMatch = this.exactMatch(method.getName().getName(), token);
            if (!exactMatch) {
                bl = this.basicMatch(method.getName().getName(), token);
            }
            if (!exactMatch && !bl) continue;
            this.addMethod(method, levels, isNative, ctx, tempString, exactMatch);
        }
        List<Object> properties = new ArrayList();
        properties = calledType instanceof JstMixedType ? this.handleMixedType((JstMixedType)calledType) : this.getTypeProperties(calledType);
        for (IJstProperty iJstProperty : properties) {
            boolean exactMatch;
            if (tempCalledType != iJstProperty.getOwnerType()) {
                tempCalledType = iJstProperty.getOwnerType();
                levels = this.getCallLevel(callingType, tempCalledType);
                isNative = CodeCompletionUtils.isNativeType(tempCalledType);
            }
            boolean basicMatch = exactMatch = this.exactMatch(iJstProperty.getName().getName(), token);
            if (!exactMatch) {
                basicMatch = this.basicMatch(iJstProperty.getName().getName(), token);
            }
            if (!this.levelCheck(iJstProperty.getModifiers(), levels) || !exactMatch && !basicMatch) continue;
            this.appendData(ctx, (IJstNode)iJstProperty, exactMatch && basicMatch);
        }
    }

    private List<IJstProperty> handleMixedType(JstMixedType calledType) {
        ArrayList<IJstProperty> props = new ArrayList<IJstProperty>();
        for (IJstType type : calledType.getMixedTypes()) {
            JstObjectLiteralType otype;
            JstAttributedType atype;
            IJstNode otypecandidate;
            if (type instanceof JstAttributedType && (otypecandidate = (atype = (JstAttributedType)type).getJstBinding()) != null && otypecandidate instanceof JstObjectLiteralType) {
                JstObjectLiteralType otype2 = (JstObjectLiteralType)otypecandidate;
                props.addAll(this.getTypeProperties((IJstType)otype2));
            }
            if (!(type instanceof JstObjectLiteralType) || (otype = (JstObjectLiteralType)type) == null) continue;
            props.addAll(this.getTypeProperties((IJstType)otype));
        }
        return props;
    }

    private List<IJstProperty> getTypeProperties(IJstType calledType) {
        return calledType.getAllPossibleProperties(false, false);
    }

    private boolean isReferenceByDot(IJstMethod method) {
        if (method.getName() != null) {
            if (method.getName().getName().startsWith("'")) {
                return false;
            }
            if (method.getName().getName().startsWith("\"")) {
                return false;
            }
        }
        return true;
    }

    private void addMethod(IJstMethod method, int[] levels, boolean isNative, VjoCcCtx ctx, List<String> tempString, boolean exactMatch) {
        String str;
        if (!(method.isConstructor() || !this.levelCheck(method.getModifiers(), levels) || isNative && method.getName().getName().startsWith("_") || tempString.contains(str = CodeCompletionUtils.getMthodsStr(method)))) {
            tempString.add(str);
            this.appendData(ctx, (IJstNode)method, exactMatch);
        }
    }

    @Override
    protected int[] getCallLevel(IJstType callingType, IJstType calledType) {
        return CodeCompletionUtils.getGeneralFieldCallLevel(callingType, calledType);
    }
}

