/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.tool.codecompletion.advisor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceMgr;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCommentCompletion;
import org.eclipse.vjet.dsf.ts.ITypeSpace;
import org.eclipse.vjet.vjo.tool.codecompletion.IVjoCcAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.StringUtils;
import org.eclipse.vjet.vjo.tool.codecompletion.VjoCcCtx;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.AbstractVjoCcAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcAdvisorConstances;
import org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.VjoCcStringProposalData;

public class VjoCcTypeNameAliasProposalAdvisor
extends AbstractVjoCcAdvisor
implements IVjoCcAdvisor {
    public static final String ID = VjoCcTypeNameAliasProposalAdvisor.class.getName();
    private boolean fullNameCheck = true;

    @Override
    public void advise(VjoCcCtx ctx) {
        JstTypeSpaceMgr tsMrg = ctx.getJstTypeSpaceMgr();
        ITypeSpace tsds = tsMrg.getTypeSpace();
        Map aliasMap = tsds.getAllVisibleAliasNames(tsds.getGroup(ctx.getGroupName()));
        Collection types = aliasMap.values();
        IJstType otype = ctx.getActingType();
        boolean fullNameCheck = ctx.ifContainsFullNameCheck();
        String token = ctx.getActingPackageToken();
        Object info = ctx.getInfo("TYPE_SHOW_FULLNAME");
        boolean hideSelf = false;
        if (info != null && info instanceof Boolean) {
            hideSelf = true;
        }
        ArrayList<String> nameList = new ArrayList<String>();
        for (IJstType type : types) {
            VjoCcStringProposalData data;
            boolean exactMatch;
            String sTypeName;
            IJstType calledType;
            if (type.isFakeType() && !type.isMetaType() || !(ctx.getCompletion() instanceof JstCommentCompletion) && type.isMetaType() || nameList.contains(type.getName())) continue;
            if (this.isSameType(type, otype)) {
                if (hideSelf) continue;
                type = otype;
            } else if (ctx.containsFieldAdvisors() && (calledType = ctx.getCalledType()) != null) {
                String cTypeName = calledType.getName();
                IJstType tempType = calledType;
                if (calledType instanceof IJstRefType) {
                    tempType = ((IJstRefType)calledType).getReferencedNode();
                    cTypeName = tempType.getName();
                }
                if (type.getName() == null || type.getName().contains(cTypeName) && type.getParentNode() == tempType) continue;
            }
            if (!this.mtypeCheck(ctx, type) || VjoCcAdvisorConstances.UNEXIST_TYPES.contains(sTypeName = type.getAliasTypeName()) || StringUtils.isBlankOrEmpty(sTypeName)) continue;
            boolean basicMatch = exactMatch = this.exactMatch(sTypeName, token);
            if (!exactMatch) {
                basicMatch = this.basicMatch(sTypeName, token);
            }
            if (exactMatch || basicMatch) {
                data = new VjoCcStringProposalData(type.getAliasTypeName(), ctx, ID);
                data.setAccurateMatch(false);
                ctx.getReporter().addPropsal(data);
                nameList.add(type.getAliasTypeName());
                continue;
            }
            if (!fullNameCheck || !this.isInPackage(type.getName(), token)) continue;
            data = new VjoCcStringProposalData(type.getAliasTypeName(), ctx, ID);
            data.setAccurateMatch(false);
            ctx.getReporter().addPropsal(data);
            nameList.add(type.getAliasTypeName());
        }
    }

    private boolean isInPackage(String typeName, String packageName) {
        if (!typeName.startsWith(packageName)) {
            return false;
        }
        String s = typeName.substring(packageName.length());
        return s != null && s.indexOf(".") == -1;
    }

    private boolean mtypeCheck(VjoCcCtx ctx, IJstType type) {
        return ctx.isMtypeEabled() || !type.isMixin();
    }

    private boolean isSameType(IJstType type, IJstType otype) {
        String name;
        if (type == null || otype == null) {
            return false;
        }
        String oname = otype.getName();
        if (!StringUtils.compare(oname, name = type.getName())) {
            return false;
        }
        String ogroupName = null;
        JstPackage pck = otype.getPackage();
        if (pck != null) {
            ogroupName = pck.getGroupName();
        }
        String groupName = type.getPackage().getGroupName();
        return StringUtils.compare(ogroupName, groupName);
    }

    protected boolean ifContainsFullNameCheck() {
        return this.fullNameCheck;
    }
}

