/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.tool.codecompletion.handler;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.vjo.tool.codecompletion.IVjoCcProposalData;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoAttributedProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCCVjoUtilityAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcAliasProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcCTypeProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcConstructorGenProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcDerivedPropMethodAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcEnumElementAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcFunctionArgumentAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcFunctionGenProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcGlobalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcGlobalExtensionAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcInterfaceProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcKeywordAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcKeywordInCommentProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcKeywordInMethodProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcMTypeProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcNeedsItemProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcObjLiteralAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcOuterPropMethodProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcOverrideProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcOwnerTypeProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcPackageProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcParameterHintAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcParameterProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcPropMethodProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcStaticPropMethodProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcThisProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcTypeNameAliasProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcTypeProposalAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.VjoCcVariableProposalAdvisor;

public class VjoCcAdvisorSorter
implements Comparator<IVjoCcProposalData>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<String, Integer> SORT_MAP = new HashMap<String, Integer>();
    private static final int EXACT_CON = -20;
    private String token = "";

    static {
        int i = 0;
        SORT_MAP.put(VjoCcVariableProposalAdvisor.ID, i);
        SORT_MAP.put(VjoCcFunctionArgumentAdvisor.ID, ++i);
        SORT_MAP.put(VjoCcParameterProposalAdvisor.ID, ++i);
        SORT_MAP.put(VjoCcObjLiteralAdvisor.ID, i++);
        SORT_MAP.put(VjoCcPropMethodProposalAdvisor.ID, i);
        SORT_MAP.put(VjoCcParameterHintAdvisor.ID, ++i);
        SORT_MAP.put(VjoCcStaticPropMethodProposalAdvisor.ID, ++i);
        ++i;
        ++i;
        SORT_MAP.put(VjoCcOuterPropMethodProposalAdvisor.ID, ++i);
        ++i;
        ++i;
        ++i;
        ++i;
        SORT_MAP.put(VjoCcDerivedPropMethodAdvisor.ID, ++i);
        SORT_MAP.put(VjoCcEnumElementAdvisor.ID, ++i);
        SORT_MAP.put(VjoCcKeywordInCommentProposalAdvisor.ID, ++i);
        SORT_MAP.put(VjoCcOwnerTypeProposalAdvisor.ID, ++i);
        SORT_MAP.put(VjoCcAliasProposalAdvisor.ID, ++i);
        SORT_MAP.put(VjoCcTypeNameAliasProposalAdvisor.ID, ++i);
        SORT_MAP.put(VjoCcTypeProposalAdvisor.ID, ++i);
        SORT_MAP.put(VjoAttributedProposalAdvisor.ID, ++i);
        SORT_MAP.put(VjoCcNeedsItemProposalAdvisor.ID, i);
        SORT_MAP.put(VjoCcCTypeProposalAdvisor.ID, i);
        SORT_MAP.put(VjoCcInterfaceProposalAdvisor.ID, i);
        SORT_MAP.put(VjoCcMTypeProposalAdvisor.ID, i);
        SORT_MAP.put(VjoCcFunctionGenProposalAdvisor.ID, ++i);
        SORT_MAP.put(VjoCcOverrideProposalAdvisor.ID, ++i);
        SORT_MAP.put(VjoCcConstructorGenProposalAdvisor.ID, ++i);
        SORT_MAP.put(VjoCcGlobalAdvisor.ID, ++i);
        SORT_MAP.put(VjoCcGlobalExtensionAdvisor.ID, ++i);
        SORT_MAP.put(VjoCcKeywordAdvisor.ID, ++i);
        SORT_MAP.put(VjoCcKeywordInMethodProposalAdvisor.ID, i);
        SORT_MAP.put(VjoCcKeywordInMethodProposalAdvisor.ID, i);
        SORT_MAP.put(VjoCcThisProposalAdvisor.ID, i);
        SORT_MAP.put(VjoCCVjoUtilityAdvisor.ID, i);
        SORT_MAP.put(VjoCcPackageProposalAdvisor.ID, ++i);
    }

    public VjoCcAdvisorSorter(String token) {
        if (token == null || "".equals(token.trim())) {
            return;
        }
        this.token = token;
    }

    private int getOriginalRace(IVjoCcProposalData data) {
        String ad = data.getAdvisor();
        int i = SORT_MAP.get(ad);
        if (VjoCcPropMethodProposalAdvisor.ID.equals(ad) || VjoCcStaticPropMethodProposalAdvisor.ID.equals(ad)) {
            Object obj = data.getData();
            if (obj instanceof IJstMethod) {
                i += 2;
            }
        } else if (VjoCcOuterPropMethodProposalAdvisor.ID.equals(ad)) {
            Object obj = data.getData();
            if (obj instanceof IJstMethod) {
                ++i;
                if (((IJstMethod)obj).isStatic()) {
                    i += 2;
                }
            } else if (obj instanceof IJstProperty && ((IJstProperty)obj).isStatic()) {
                i += 2;
            }
        }
        return i;
    }

    @Override
    public int compare(IVjoCcProposalData o1, IVjoCcProposalData o2) {
        int i1 = this.getOriginalRace(o1);
        int i2 = this.getOriginalRace(o2);
        if (this.isExactProposal(o1)) {
            i1 -= 20;
        }
        if (this.isExactProposal(o2)) {
            i2 -= 20;
        }
        if (!o1.isAccurateMatch()) {
            i1 += 20;
        }
        if (!o2.isAccurateMatch()) {
            i2 += 20;
        }
        if (i2 != i1) {
            return i1 - i2;
        }
        String name1 = o1.getName();
        String name2 = o2.getName();
        int val = name1.compareTo(name2);
        if (!name1.startsWith("_") && name2.startsWith("_")) {
            return -100;
        }
        if (name1.startsWith("_") && !name2.startsWith("_")) {
            return 10;
        }
        return val;
    }

    private int clarifyPropertyAndMethod(IVjoCcProposalData o1, int i1) {
        return 0;
    }

    private boolean isExactProposal(IVjoCcProposalData o2) {
        if ("".equals(this.token)) {
            return false;
        }
        String name = o2.getName();
        return name.equals(this.token);
    }
}

