/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.tool.typespace;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstParseController;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.ts.JstQueryExecutor;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceMgr;
import org.eclipse.vjet.dsf.jst.ts.TypeSpaceConfig;
import org.eclipse.vjet.dsf.jst.ts.TypeSpaceLocker;
import org.eclipse.vjet.dsf.jstojava.controller.JstParseController;
import org.eclipse.vjet.dsf.ts.ITypeSpace;
import org.eclipse.vjet.dsf.ts.event.EventListenerStatus;
import org.eclipse.vjet.dsf.ts.event.ISourceEvent;
import org.eclipse.vjet.dsf.ts.event.ISourceEventCallback;
import org.eclipse.vjet.dsf.ts.event.dispatch.IEventListenerHandle;
import org.eclipse.vjet.dsf.ts.event.group.AddGroupEvent;
import org.eclipse.vjet.dsf.ts.event.group.BatchGroupLoadingEvent;
import org.eclipse.vjet.dsf.ts.event.group.RemoveGroupEvent;
import org.eclipse.vjet.dsf.ts.event.type.AddTypeEvent;
import org.eclipse.vjet.dsf.ts.event.type.ModifyTypeEvent;
import org.eclipse.vjet.dsf.ts.event.type.RemoveTypeEvent;
import org.eclipse.vjet.dsf.ts.group.IGroup;
import org.eclipse.vjet.dsf.ts.method.MethodName;
import org.eclipse.vjet.dsf.ts.property.PropertyName;
import org.eclipse.vjet.dsf.ts.type.TypeName;
import org.eclipse.vjet.vjo.lib.TsLibLoader;
import org.eclipse.vjet.vjo.tool.typespace.EmptyTypeLoadMonitor;
import org.eclipse.vjet.vjo.tool.typespace.GroupInfo;
import org.eclipse.vjet.vjo.tool.typespace.ITypeSpaceLoader;
import org.eclipse.vjet.vjo.tool.typespace.ITypeSpaceRunnable;
import org.eclipse.vjet.vjo.tool.typespace.ModifyTypeCallback;
import org.eclipse.vjet.vjo.tool.typespace.SourceTypeName;
import org.eclipse.vjet.vjo.tool.typespace.TypeLoadMonitor;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceListener;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceLoadEvent;

public class TypeSpaceMgr {
    public static final String WINDOW = "Window";
    public static final String GLOBAL = "Global";
    public static final String OBJECT = "Object";
    private static TypeSpaceMgr s_instance = new TypeSpaceMgr();
    public static final String NATIVE_GROUP = "JsNativeLib";
    private JstParseController m_controller;
    private ITypeSpaceLoader m_typeLoader;
    private Map<String, List<String>> m_groupDepends = Collections.emptyMap();
    public static final String WINDOW_VAR = "window";
    private final TypeSpaceLocker m_locker = new TypeSpaceLocker();
    private Collection<TypeSpaceListener> m_listeners = new ArrayList<TypeSpaceListener>();
    private Map<String, URI> m_typeToFileMap = new HashMap<String, URI>();
    private ModifyTypeCallback modifyTypeCallback = new ModifyTypeCallback();
    private Map<String, URI> m_typeToFileMapSync;
    public static final List<String> NATIVE_GLOBAL_OBJECTS;

    static {
        ArrayList<String> nativeGlobalObjects = new ArrayList<String>(16);
        nativeGlobalObjects.add("Array");
        nativeGlobalObjects.add("Boolean");
        nativeGlobalObjects.add("Date");
        nativeGlobalObjects.add("Error");
        nativeGlobalObjects.add("EvalError");
        nativeGlobalObjects.add("Function");
        nativeGlobalObjects.add("Math");
        nativeGlobalObjects.add("Number");
        nativeGlobalObjects.add(OBJECT);
        nativeGlobalObjects.add("RangeError");
        nativeGlobalObjects.add("ReferenceError");
        nativeGlobalObjects.add("RegExp");
        nativeGlobalObjects.add("String");
        nativeGlobalObjects.add("SyntaxError");
        nativeGlobalObjects.add("TypeError");
        nativeGlobalObjects.add("URIError");
        nativeGlobalObjects.add(WINDOW);
        nativeGlobalObjects.add(GLOBAL);
        nativeGlobalObjects.add(OBJECT);
        NATIVE_GLOBAL_OBJECTS = Collections.unmodifiableList(nativeGlobalObjects);
    }

    private TypeSpaceMgr() {
    }

    public void init(IJstParseController controller) {
        this.m_controller = (JstParseController)controller;
        JstTypeSpaceMgr jstTypeSpaceMgr = this.m_controller.getJstTypeSpaceMgr();
        jstTypeSpaceMgr.initialize();
        TsLibLoader.loadDefaultLibs((JstTypeSpaceMgr)jstTypeSpaceMgr);
        this.promoteGlobals(jstTypeSpaceMgr);
    }

    private void promoteGlobals(JstTypeSpaceMgr jstTypeSpaceMgr) {
        jstTypeSpaceMgr.getTypeSpace().addAllGlobalTypeMembers(new TypeName("JsBrowserLib", GLOBAL));
        jstTypeSpaceMgr.getTypeSpace().addToGlobalTypeSymbolMap("VjoSelfDescribed", "vjo", "vjo");
    }

    public ITypeSpace<IJstType, IJstNode> getTypeSpace() {
        return this.getController().getJstTypeSpaceMgr().getTypeSpace();
    }

    public void processEvent(ISourceEvent<IEventListenerHandle> event) {
        try {
            this.getController().getJstTypeSpaceMgr().processEvent(event);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void processEvent(ISourceEvent<IEventListenerHandle> event, ISourceEventCallback<IJstType> callback) {
        try {
            TypeSpaceMgr.getInstance().getController().getJstTypeSpaceMgr().processEvent(event);
            if (callback != null) {
                callback.onComplete(new EventListenerStatus(EventListenerStatus.Code.Successful));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public JstTypeSpaceMgr setConfig(TypeSpaceConfig config) {
        return this.getController().getJstTypeSpaceMgr().setConfig(config);
    }

    public static TypeSpaceMgr getInstance() {
        return s_instance;
    }

    public AddGroupEvent createGroupEvent(GroupInfo group, List<String> groups) {
        if (!groups.contains(group.getGroupName())) {
            groups.add(group.getGroupName());
            return this.createGroupEvent(group);
        }
        return null;
    }

    private AddGroupEvent createGroupEvent(GroupInfo group) {
        List<String> inclusionRules = group.getSrcPath().getInclusionRules();
        List<String> exclusionRules = group.getSrcPath().getExclusionRules();
        return new AddGroupEvent(group.getGroupName(), group.getGroupPath(), group.isLibrary() ? group.getSrcPath().getSourcePaths() : null, group.getClassPath(), group.getDirectDependency(), group.getBootstrapPath(), inclusionRules, exclusionRules);
    }

    public IJstType findType(TypeName typeName) {
        return this.getController().getJstTypeSpaceMgr().getQueryExecutor().findType(typeName);
    }

    public List<IJstType> findSatisfiers(TypeName name) {
        return this.getController().getJstTypeSpaceMgr().getQueryExecutor().findSatisfiers(name);
    }

    public List<IJstType> findSubTypes(TypeName name) {
        return this.getController().getJstTypeSpaceMgr().getQueryExecutor().findSubTypes(name);
    }

    public synchronized void load(TypeLoadMonitor monitor, ISourceEventCallback<IJstType> callback) {
        this.doLoad(monitor, callback);
    }

    private void doLoad(TypeLoadMonitor monitor, ISourceEventCallback<IJstType> callback) {
        if (this.m_typeLoader != null) {
            this.loadTypes(monitor, callback);
        }
    }

    public void clean() {
        LinkedHashSet set = new LinkedHashSet(this.getController().getJstTypeSpaceMgr().getTypeSpace().getGroups().keySet());
        for (String group : set) {
            this.cleanGroup(group);
        }
        this.m_groupDepends = null;
    }

    public void cleanGroup(String group) {
        if (!TsLibLoader.isDefaultLibName((String)group)) {
            this.processEvent((ISourceEvent<IEventListenerHandle>)new RemoveGroupEvent(group, group));
        }
    }

    private void loadGroupDepends() {
        this.m_groupDepends = this.m_typeLoader.getGroupDepends();
    }

    private void loadTypes(TypeLoadMonitor monitor, ISourceEventCallback<IJstType> callback) {
        monitor.preparationTypeListStarted();
        List<GroupInfo> list = this.m_typeLoader.getGroupInfo();
        monitor.preparationTypeListFinished();
        this.loadTypes(monitor, list);
    }

    private void loadTypes(TypeLoadMonitor monitor, List<GroupInfo> list) {
        if (list.size() == 0) {
            return;
        }
        monitor.loadTypeListStarted(list.size());
        int initGroupSize = this.m_controller.getJstTypeSpaceMgr().getTypeSpace().getGroups().size();
        int totalGroups = initGroupSize + list.size();
        this.loadToTypeSpace(monitor, list, new TypeSpaceLoadEvent(totalGroups, this.m_locker, monitor));
    }

    private void loadToTypeSpace(TypeLoadMonitor monitor, List<GroupInfo> list, ISourceEventCallback<IJstType> callback) {
        BatchGroupLoadingEvent batch = new BatchGroupLoadingEvent();
        ArrayList<String> groups = new ArrayList<String>();
        for (GroupInfo stn : list) {
            AddGroupEvent event = this.createGroupEvent(stn, groups);
            if (event == null) continue;
            batch.addGroupEvent(event);
        }
        TypeSpaceMgr.processEvent((ISourceEvent<IEventListenerHandle>)batch, null);
    }

    public ITypeSpaceLoader getTypeLoader() {
        return this.m_typeLoader;
    }

    public void setTypeLoader(ITypeSpaceLoader typeLoader) {
        this.m_typeLoader = typeLoader;
    }

    public List<IJstType> findSuperTypes(TypeName typeName) {
        IJstType type = (IJstType)this.getTypeSpace().getType(typeName);
        if (type == null) {
            return Collections.emptyList();
        }
        ArrayList<IJstType> superTypes = new ArrayList<IJstType>();
        while (type != null) {
            if (superTypes.contains(type = type.getExtend())) break;
            if (type == null) continue;
            superTypes.add(0, type);
        }
        return superTypes;
    }

    public List<IJstType> findType(String pattern) {
        return this.getTypeSpace().getType(pattern);
    }

    public Collection<IJstType> getAllTypes() {
        return this.getTypeSpace().getTypes().values();
    }

    public List<String> getGroupDepends(String group) {
        List<String> list;
        if (this.m_groupDepends == null) {
            this.loadGroupDepends();
        }
        if ((list = this.m_groupDepends.get(group)) == null) {
            list = new ArrayList<String>(1);
        }
        if (!list.contains(NATIVE_GROUP)) {
            list.add(NATIVE_GROUP);
        }
        return list;
    }

    public synchronized void reload(TypeLoadMonitor monitor, ISourceEventCallback<IJstType> callback) {
        this.clean();
        this.load(monitor, callback);
    }

    public synchronized void reloadGroup(TypeLoadMonitor monitor, String group, ISourceEventCallback<IJstType> callback) {
        this.cleanGroup(group);
        this.loadGroup(monitor, group, callback);
    }

    private void loadGroup(TypeLoadMonitor monitor, String group, ISourceEventCallback<IJstType> callback) {
        if (this.m_typeLoader != null) {
            monitor.preparationTypeListStarted();
            List<GroupInfo> list = this.m_typeLoader.getGroupInfo(group);
            monitor.preparationTypeListFinished();
            this.loadTypes(monitor, list);
        }
    }

    public synchronized void reload(ISourceEventCallback<IJstType> callback) {
        this.reload(new EmptyTypeLoadMonitor(), callback);
    }

    public List<IJstNode> getMethodDependents(MethodName mtdName) {
        List dependents = this.getController().getJstTypeSpaceMgr().getTypeSpace().getMethodDependents(mtdName);
        return dependents;
    }

    public List<IJstNode> getPropertyDependents(PropertyName ptyName) {
        List dependents = this.getController().getJstTypeSpaceMgr().getTypeSpace().getPropertyDependents(ptyName);
        return this.getVisibleDependents(dependents, ptyName.getGroupName());
    }

    public List<IJstType> getDirectDependents(TypeName typeName) {
        List dependents = this.getController().getJstTypeSpaceMgr().getTypeSpace().getDirectDependents(typeName);
        return this.getVisibleDependents(dependents, typeName.groupName());
    }

    public Collection<IJstType> getTypes(String jsNativeGrp) {
        Collection<Object> collection = Collections.emptyList();
        IGroup group = this.getController().getJstTypeSpaceMgr().getTypeSpace().getGroup(jsNativeGrp);
        if (group != null) {
            collection = group.getEntities().values();
        }
        return collection;
    }

    public boolean existType(String group, String name) {
        TypeName typeName = new TypeName(group, name);
        return TypeSpaceMgr.existType(typeName);
    }

    public static boolean existType(TypeName typeName) {
        return TypeSpaceMgr.getInstance().findType(typeName) != null;
    }

    public IJstType getNativeType(String name) {
        TypeName typeName = new TypeName(NATIVE_GROUP, name);
        return this.findType(typeName);
    }

    public void addTypeSpaceListener(TypeSpaceListener listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    protected void fireLoadTypesFinished() {
        ArrayList<TypeSpaceListener> listeners = new ArrayList<TypeSpaceListener>(this.m_listeners);
        for (TypeSpaceListener listener : listeners) {
            listener.loadTypesFinished();
        }
    }

    public void removeTypeSpaceListener(TypeSpaceListener listener) {
        this.m_listeners.remove(listener);
    }

    public synchronized void refresh(TypeLoadMonitor monitor, ISourceEventCallback<IJstType> callback) {
        try {
            this.doRefresh(monitor, callback);
        }
        finally {
            this.fireRefreshTypesFinished();
        }
    }

    private void fireRefreshTypesFinished() {
        ArrayList<TypeSpaceListener> listeners = new ArrayList<TypeSpaceListener>(this.m_listeners);
        List<SourceTypeName> list = this.m_typeLoader.getChangedTypes();
        for (TypeSpaceListener listener : listeners) {
            listener.refreshFinished(list);
        }
    }

    private void doRefresh(TypeLoadMonitor monitor, ISourceEventCallback<IJstType> callback) {
        if (this.m_typeLoader != null) {
            this.loadChangedTypes(monitor, this.modifyTypeCallback);
        }
    }

    private void loadChangedTypes(TypeLoadMonitor monitor, ISourceEventCallback<IJstType> callback) {
        monitor.preparationTypeListStarted();
        List<SourceTypeName> changedTypes = this.m_typeLoader.getChangedTypes();
        for (SourceTypeName source : changedTypes) {
            TypeSpaceMgr.doProcessType(source, callback);
        }
    }

    private void resolveAll() {
        Collection<IJstType> types = this.getAllTypes();
        for (IJstType jstType : types) {
            this.getController().resolve(jstType);
        }
    }

    public void setAllowChanges(boolean isAllowChanges) {
    }

    public void run(ITypeSpaceRunnable runnable) {
        runnable.run();
    }

    public boolean existGroup(String groupName) {
        return this.getController().getJstTypeSpaceMgr().getTypeSpace().getGroup(groupName) != null;
    }

    public static IJstType findType(String group, String name) {
        TypeName typeName = new TypeName(group, name);
        IJstType jstType = TypeSpaceMgr.getInstance().findType(typeName);
        return jstType;
    }

    public static JstTypeSpaceMgr TS() {
        return TypeSpaceMgr.getInstance().getController().getJstTypeSpaceMgr();
    }

    public static IJstParseController parser() {
        return TypeSpaceMgr.getInstance().getController();
    }

    public JstParseController getController() {
        return this.m_controller;
    }

    public static JstQueryExecutor QE() {
        return TypeSpaceMgr.TS().getQueryExecutor();
    }

    public static boolean isNativeGlobalObject(String token) {
        return NATIVE_GLOBAL_OBJECTS.contains(token);
    }

    public void waitUntilLoaded() {
    }

    public static void doProcessType(SourceTypeName name, ISourceEventCallback<IJstType> callback) {
        TypeName typeName = new TypeName(name.groupName(), name.typeName());
        int action = name.getAction();
        if (TypeSpaceMgr.isChangedTypeNotExist(name)) {
            action = 1;
        }
        switch (action) {
            case 1: {
                IJstType type = TypeSpaceMgr.getInstance().getController().getJstTypeSpaceMgr().getQueryExecutor().findType(typeName);
                AddTypeEvent addEvent = null;
                addEvent = type == null ? new AddTypeEvent(name.groupName(), name.typeName(), name.source()) : new AddTypeEvent((TypeName)name, type);
                TypeSpaceMgr.processEvent((ISourceEvent<IEventListenerHandle>)addEvent, callback);
                break;
            }
            case 4: {
                ModifyTypeEvent event = new ModifyTypeEvent(name.groupName(), name.typeName(), name.source());
                TypeSpaceMgr.processEvent((ISourceEvent<IEventListenerHandle>)event, callback);
                break;
            }
            case 2: {
                RemoveTypeEvent removeEvent = new RemoveTypeEvent(typeName);
                TypeSpaceMgr.processEvent((ISourceEvent<IEventListenerHandle>)removeEvent, callback);
                break;
            }
        }
    }

    private static boolean isChangedTypeNotExist(SourceTypeName name) {
        return name.getAction() == 4 && !TypeSpaceMgr.existType(name);
    }

    public void load(TypeLoadMonitor monitor, List<GroupInfo> list) {
        this.loadTypes(monitor, list);
    }

    public Map<String, URI> getTypeToFileMap() {
        if (this.m_typeToFileMapSync == null) {
            this.m_typeToFileMapSync = Collections.synchronizedMap(this.m_typeToFileMap);
        }
        return this.m_typeToFileMapSync;
    }

    public void setTypeToFileMap(Map<String, URI> typeToFileMap) {
        this.m_typeToFileMap = typeToFileMap;
    }

    private <T extends IJstNode> List<T> getVisibleDependents(List<T> dependents, String groupName) {
        if (dependents == null || dependents.size() == 0) {
            return Collections.emptyList();
        }
        if (groupName == null) {
            return Collections.unmodifiableList(dependents);
        }
        ITypeSpace<IJstType, IJstNode> ts = this.getTypeSpace();
        IGroup group = ts.getGroup(groupName);
        if (group == null) {
            throw new RuntimeException("group is not found in type space: " + groupName);
        }
        ArrayList<IJstNode> visible = new ArrayList<IJstNode>();
        for (IJstNode d : dependents) {
            if (!ts.getGroup((Object)d.getRootType()).isDependOn(group)) continue;
            visible.add(d);
        }
        return Collections.unmodifiableList(visible);
    }
}

