/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.debug.ui.html;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ui.IEditorInput;

public class HtmlLaunchUtils {
    public static boolean isEditorInputHtml(IEditorInput input) {
        String temp = input.toString().toLowerCase();
        return temp.contains(".htm");
    }

    public static String getSelectedResource() {
        try {
            return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution("${resource_loc}");
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getEditorInputProject(IEditorInput input) {
        Path temp = new Path(input.toString());
        return temp.segment(1);
    }

    public static boolean isVjoRunnerMatch(ILaunchConfiguration config, Object resource) {
        try {
            if (config.getAttribute("org.eclipse.jdt.launching.MAIN_TYPE", "").equals("org.eclipse.vjet.vjo.runner.VjoRunner")) {
                return HtmlLaunchUtils.isResourceMatch(config, resource);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isHtmlDervletMatch(ILaunchConfiguration config, Object resource) {
        try {
            if (config.getAttribute("org.eclipse.jdt.launching.MAIN_TYPE", "").equals("org.eclipse.vjet.eclipse.html.launching.dervlet.HtmlDervletRunner")) {
                return HtmlLaunchUtils.isResourceMatch(config, resource);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isResourceMatch(ILaunchConfiguration config, Object resource) {
        try {
            String projectName = config.getAttribute("org.eclipse.jdt.launching.PROJECT_ATTR", "");
            String resourceLoc = config.getAttribute("org.eclipse.jdt.launching.RESOURCE_LOC", "");
            if (resource instanceof IResource) {
                IResource r = (IResource)resource;
                return projectName.equals(r.getProject().getName()) && resourceLoc.equals(r.getLocation().toString().replace("/", "\\"));
            }
            if (resource instanceof IEditorInput) {
                IEditorInput i = (IEditorInput)resource;
                String loc = i.toString();
                loc = i.toString().substring(loc.indexOf("/"), loc.indexOf(")")).replace("/", "\\");
                return projectName.equals(HtmlLaunchUtils.getEditorInputProject(i)) && resourceLoc.contains(loc);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }
}

