/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.debug.ui.launchConf;

import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.MultipleInputDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.EnvironmentVariable;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.EnvironmentTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.dltk.mod.debug.ui.launchConfigurations.ScriptBuildTab;
import org.eclipse.dltk.mod.debug.ui.launchConfigurations.ScriptCommonTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.eclipse.vjet.eclipse.internal.debug.ui.launchConf.IncludeTab;
import org.eclipse.vjet.eclipse.internal.debug.ui.launchConf.VjetArgumentsTab;
import org.eclipse.vjet.eclipse.internal.debug.ui.launchConf.VjetMainLaunchConfTab;

public class VjetTabGroup
extends AbstractLaunchConfigurationTabGroup {
    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        this.setTabs(new ILaunchConfigurationTab[]{new VjetMainLaunchConfTab(mode), new IncludeTab(), new VjetArgumentsTab(), new ScriptBuildTab(), new EnvironmentTab(){

            protected void handleEnvAddButtonSelected() {
                MultipleInputDialogWithBrowser dialog = new MultipleInputDialogWithBrowser(this.getShell(), LaunchConfigurationsMessages.EnvironmentTab_22);
                dialog.addTextField(LaunchConfigurationsMessages.EnvironmentTab_8, null, false);
                dialog.addVariablesField(LaunchConfigurationsMessages.EnvironmentTab_9, null, true);
                if (dialog.open() != 0) {
                    return;
                }
                String name = dialog.getStringValue(LaunchConfigurationsMessages.EnvironmentTab_8);
                String value = dialog.getStringValue(LaunchConfigurationsMessages.EnvironmentTab_9);
                if (name != null && value != null) {
                    this.addVariable(new EnvironmentVariable(name.trim(), value.trim()));
                    this.updateAppendReplace();
                }
            }
        }, new ScriptCommonTab()});
    }

    private class MultipleInputDialogWithBrowser
    extends MultipleInputDialog {
        MultipleInputDialogWithBrowser(Shell shell, String title) {
            super(shell, title);
        }

        protected void okPressed() {
            for (Control control : this.controlList) {
                if (!(control instanceof Combo)) continue;
                Combo combo = (Combo)control;
                int index = combo.getSelectionIndex();
                if (index < 0) {
                    index = 0;
                    combo.setItem(index, combo.getText());
                    combo.select(index);
                }
                this.valueMap.put(control.getData("FIELD_NAME"), combo.getItem(index));
            }
            super.okPressed();
        }

        public void createVariablesField(String labelText, String initialValue, boolean allowEmpty) {
            Label label = new Label(this.panel, 0);
            label.setText(labelText);
            label.setLayoutData((Object)new GridData(32));
            Composite comp = new Composite(this.panel, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            comp.setLayout((Layout)layout);
            comp.setLayoutData((Object)new GridData(768));
            final Combo combo = new Combo(comp, 2052);
            GridData data = new GridData(768);
            data.widthHint = 200;
            combo.setLayoutData((Object)data);
            combo.setData("FIELD_NAME", (Object)labelText);
            BrowserType[] types = BrowserType.values();
            String[] strings = new String[types.length];
            int iter = 0;
            while (iter < types.length) {
                strings[iter] = types[iter].name();
                ++iter;
            }
            combo.setItems(strings);
            label.setSize(label.getSize().x, combo.getSize().y);
            if (initialValue != null) {
                combo.setText(initialValue);
            }
            Button button = this.createButton(comp, 9, DebugUIMessages.MultipleInputDialog_8, false);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String variable;
                    StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(MultipleInputDialogWithBrowser.this.getShell());
                    int code = dialog.open();
                    if (code == 0 && (variable = dialog.getVariableExpression()) != null) {
                        combo.setItem(0, variable);
                        combo.setText(variable);
                        combo.select(0);
                    }
                }
            });
        }
    }
}

