/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.preferences;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.mod.ui.util.SWTFactory;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.vjet.dsf.jst.ts.util.ISdkEnvironment;
import org.eclipse.vjet.eclipse.core.sdk.VjetSdkRuntime;
import org.eclipse.vjet.eclipse.internal.ui.preferences.InstalledSdksBlock;

public class VjetSdkPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private InstalledSdksBlock fJREBlock;
    private Link fCompliance;

    public VjetSdkPreferencePage() {
        super("VJET SDK");
    }

    public void init(IWorkbench workbench) {
    }

    private void initDefaultVM() {
        ISdkEnvironment realDefault = VjetSdkRuntime.getDefaultSdkInstall();
        if (realDefault != null) {
            ISdkEnvironment[] vms = this.fJREBlock.getJREs();
            int i = 0;
            while (i < vms.length) {
                ISdkEnvironment fakeVM = vms[i];
                if (fakeVM.equals(realDefault)) {
                    this.verifyDefaultVM(fakeVM);
                    break;
                }
                ++i;
            }
        }
    }

    protected Control createContents(Composite ancestor) {
        this.initializeDialogUnits((Control)ancestor);
        this.noDefaultAndApplyButton();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        ancestor.setLayout((Layout)layout);
        SWTFactory.createWrapLabel((Composite)ancestor, (String)"", (int)1, (int)300);
        SWTFactory.createVerticalSpacer((Composite)ancestor, (int)1);
        this.fJREBlock = new InstalledSdksBlock();
        this.fJREBlock.createControl(ancestor);
        Control control = this.fJREBlock.getControl();
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        control.setLayoutData((Object)data);
        this.fCompliance = new Link(ancestor, 0);
        this.fCompliance.setText("VJET SDK");
        this.fCompliance.setLayoutData((Object)new GridData(768));
        this.fCompliance.setVisible(false);
        this.fCompliance.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                VjetSdkPreferencePage.this.openCompliancePreferencePage();
            }
        });
        this.initDefaultVM();
        this.fJREBlock.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISdkEnvironment install = VjetSdkPreferencePage.this.getCurrentDefaultVM();
                if (install == null) {
                    VjetSdkPreferencePage.this.setValid(false);
                    VjetSdkPreferencePage.this.setErrorMessage("Error");
                } else {
                    String compliance = VjetSdkPreferencePage.this.getCurrentCompilerCompliance();
                    if (!VjetSdkPreferencePage.this.supportsCurrentCompliance(install, compliance)) {
                        VjetSdkPreferencePage.this.setMessage("Warning", 2);
                        VjetSdkPreferencePage.this.fCompliance.setVisible(true);
                    } else {
                        VjetSdkPreferencePage.this.setMessage(null);
                        VjetSdkPreferencePage.this.fCompliance.setVisible(false);
                    }
                    VjetSdkPreferencePage.this.setValid(true);
                    VjetSdkPreferencePage.this.setErrorMessage(null);
                }
            }
        });
        this.applyDialogFont(ancestor);
        return ancestor;
    }

    public boolean isValid() {
        String compliance = this.getCurrentCompilerCompliance();
        if (!this.supportsCurrentCompliance(this.getCurrentDefaultVM(), compliance)) {
            this.setMessage("", 2);
        } else {
            this.setMessage(null);
        }
        return super.isValid();
    }

    private void openCompliancePreferencePage() {
        String compliancepage = "org.eclipse.jdt.ui.preferences.CompliancePreferencePage";
        IWorkbenchPreferenceContainer wpc = (IWorkbenchPreferenceContainer)this.getContainer();
        if (wpc != null) {
            wpc.openPage(compliancepage, null);
        } else {
            SWTFactory.showPreferencePage((String)compliancepage);
        }
    }

    private String getCurrentCompilerCompliance() {
        IEclipsePreferences setting = new InstanceScope().getNode("org.eclipse.jdt.core");
        if (this.getContainer() instanceof IWorkbenchPreferenceContainer) {
            IEclipsePreferences wcs = ((IWorkbenchPreferenceContainer)this.getContainer()).getWorkingCopyManager().getWorkingCopy(setting);
            return wcs.get("org.eclipse.jdt.core.compiler.compliance", (String)JavaCore.getDefaultOptions().get("org.eclipse.jdt.core.compiler.compliance"));
        }
        return JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
    }

    private boolean supportsCurrentCompliance(ISdkEnvironment vm, String compliance) {
        return false;
    }

    public boolean performOk() {
        boolean[] canceled = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                VjetSdkPreferencePage.this.getCurrentDefaultVM();
                VjetSdkPreferencePage.this.fJREBlock.getJREs();
            }
        });
        if (canceled[0]) {
            return false;
        }
        return super.performOk();
    }

    protected IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    }

    private void verifyDefaultVM(ISdkEnvironment vm) {
        if (vm == null) {
            this.fJREBlock.setCheckedJRE(null);
        }
    }

    private ISdkEnvironment getCurrentDefaultVM() {
        return this.fJREBlock.getCheckedJRE();
    }
}

