/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.preferences.formatting;

import java.util.Map;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.FormatterProfileManager;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.IProfileVersioner;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.ProfileManager;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.Util;

public class ProfileVersioner
implements IProfileVersioner {
    public static final String CODE_FORMATTER_PROFILE_KIND = "CodeFormatterProfile";
    private static final int VERSION_1 = 1;
    private static final int CURRENT_VERSION = 1;

    @Override
    public int getFirstVersion() {
        return 1;
    }

    @Override
    public int getCurrentVersion() {
        return 1;
    }

    @Override
    public String getProfileKind() {
        return CODE_FORMATTER_PROFILE_KIND;
    }

    @Override
    public void update(ProfileManager.CustomProfile profile) {
        Map oldSettings = profile.getSettings();
        Map newSettings = ProfileVersioner.updateAndComplete(oldSettings, profile.getVersion());
        profile.setVersion(1);
        profile.setSettings(newSettings);
    }

    private static Map updateAndComplete(Map oldSettings, int version) {
        Map newSettings = FormatterProfileManager.getDefaultSettings();
        switch (version) {
            case 1: {
                ProfileVersioner.version1to2(oldSettings);
            }
        }
        for (String key : oldSettings.keySet()) {
            String value;
            if (!newSettings.containsKey(key) || (value = (String)oldSettings.get(key)) == null) continue;
            newSettings.put(key, value);
        }
        ProfileVersioner.setLatestCompliance(newSettings);
        return newSettings;
    }

    public static void setLatestCompliance(Map map) {
        Util.set50CompilanceOptions(map);
    }

    private static void version1to2(Map oldSettings) {
    }

    public static int getVersionStatus(ProfileManager.CustomProfile profile) {
        int version = profile.getVersion();
        if (version < 1) {
            return -1;
        }
        if (version > 1) {
            return 1;
        }
        return 0;
    }

    private static void mapOldValueRangeToNew(Map settings, String oldKey, String[] oldValues, String newKey, String[] newValues) {
        if (!settings.containsKey(oldKey)) {
            return;
        }
        String value = (String)settings.get(oldKey);
        if (value == null) {
            return;
        }
        int i = 0;
        while (i < oldValues.length) {
            if (value.equals(oldValues[i])) {
                settings.put(newKey, newValues[i]);
            }
            ++i;
        }
    }

    private static void duplicate(Map settings, String existingKey, String newKey) {
        ProfileVersioner.checkAndReplace(settings, existingKey, new String[]{newKey});
    }

    private static void checkAndReplace(Map settings, String oldKey, String newKey) {
        ProfileVersioner.checkAndReplace(settings, oldKey, new String[]{newKey});
    }

    private static void checkAndReplace(Map settings, String oldKey, String newKey1, String newKey2) {
        ProfileVersioner.checkAndReplace(settings, oldKey, new String[]{newKey1, newKey2});
    }

    private static void checkAndReplace(Map settings, String oldKey, String[] newKeys) {
        if (!settings.containsKey(oldKey)) {
            return;
        }
        String value = (String)settings.get(oldKey);
        if (value == null) {
            return;
        }
        int i = 0;
        while (i < newKeys.length) {
            settings.put(newKeys[i], value);
            ++i;
        }
    }

    private static void checkAndReplaceBooleanWithINSERT(Map settings, String oldKey, String newKey) {
        if (!settings.containsKey(oldKey)) {
            return;
        }
        String value = (String)settings.get(oldKey);
        if (value == null) {
            return;
        }
        value = "true".equals(value) ? "insert" : "do not insert";
        settings.put(newKey, value);
    }
}

