/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.view.scriptunit;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstVar;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jstojava.translator.JstUtil;

class ScriptUnitTreeLabelProvider
extends LabelProvider {
    private boolean checkNode;

    ScriptUnitTreeLabelProvider() {
    }

    public Image getImage(Object element) {
        if (!this.checkNode || !(element instanceof IJstNode)) {
            return null;
        }
        IJstNode jstNode = (IJstNode)element;
        if (jstNode.getSource() == null || jstNode.getRootType() == null) {
            return null;
        }
        int startOffset = jstNode.getSource().getStartOffSet();
        int endOffset = jstNode.getSource().getEndOffSet();
        BaseJstNode node = JstUtil.getLeafNode((IJstType)jstNode.getRootType(), (int)startOffset, (int)endOffset);
        if (node == element) {
            return null;
        }
        return ImageDescriptor.getMissingImageDescriptor().createImage();
    }

    public String getText(Object element) {
        if (element instanceof IJstType) {
            return "JstType";
        }
        if (element instanceof IJstNode) {
            return this.getJstNodeLabel((IJstNode)element);
        }
        return null;
    }

    private String getJstNodeLabel(IJstNode jstNode) {
        return String.valueOf(this.getName(jstNode)) + this.getSourceRange(jstNode);
    }

    private String getName(IJstNode jstNode) {
        String simpleName = jstNode.getClass().getSimpleName();
        if (jstNode instanceof IJstType) {
            return String.valueOf(simpleName) + ":" + ((IJstType)jstNode).getName();
        }
        if (jstNode instanceof IJstMethod) {
            return String.valueOf(simpleName) + ":" + ((IJstMethod)jstNode).getName();
        }
        if (jstNode instanceof IJstProperty) {
            return String.valueOf(simpleName) + ":" + ((IJstProperty)jstNode).getName();
        }
        if (jstNode instanceof JstVar) {
            return String.valueOf(simpleName) + ":" + ((JstVar)jstNode).getName();
        }
        if (jstNode instanceof JstIdentifier) {
            return String.valueOf(simpleName) + ":" + ((JstIdentifier)jstNode).getName();
        }
        return simpleName;
    }

    private String getSourceRange(IJstNode jstNode) {
        JstSource jstSource = jstNode.getSource();
        if (jstSource != null) {
            return "[" + jstSource.getStartOffSet() + "," + jstSource.getEndOffSet() + "]";
        }
        return "";
    }

    public void setCheckNode(boolean checkNode) {
        this.checkNode = checkNode;
    }
}

