/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.view.typespace;

import java.net.URI;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.ui.DLTKPluginImages;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.internal.ui.nodeprinter.INodePrinter;
import org.eclipse.vjet.eclipse.internal.ui.nodeprinter.NodePrinterFactory;
import org.eclipse.vjet.eclipse.internal.ui.view.typespace.CollapseAllAction;
import org.eclipse.vjet.eclipse.internal.ui.view.typespace.HideEmptyBinaryGroupAction;
import org.eclipse.vjet.eclipse.internal.ui.view.typespace.TypespaceTreeContentProvider;
import org.eclipse.vjet.eclipse.internal.ui.view.typespace.TypespaceTreeLabelProvider;
import org.eclipse.vjet.eclipse.internal.ui.view.typespace.TypespaceViewFilter;
import org.eclipse.vjet.vjo.tool.typespace.SourceTypeName;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceListener;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class TypespaceView
extends ViewPart {
    private TreeViewer m_viewer;
    private HideEmptyBinaryGroupAction m_hideAction = new HideEmptyBinaryGroupAction(this);
    private CollapseAllAction m_collapseAllAction = new CollapseAllAction(this);
    private TypespaceTreeContentProvider m_contentProvider;
    private TypespaceViewFilter m_filter = new TypespaceViewFilter();
    private IDoubleClickListener m_doubleClickListener = new InnerDoubleClickListener();
    private Text m_patternText;
    private Label m_libLabel;
    private Label m_proLabel;
    private Label m_typeLabel;
    private TypeSpaceListener m_typeSpaceListener = new TypeSpaceListener(){

        public void loadTypesFinished() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TypespaceView.this.m_viewer.setInput((Object)TypeSpaceMgr.getInstance());
                    TypespaceView.this.updateStateLabel();
                }
            });
        }

        public void refreshFinished(List<SourceTypeName> list) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TypespaceView.this.m_filter.clearCount();
                    TypespaceView.this.m_viewer.refresh();
                    TypespaceView.this.updateStateLabel();
                }
            });
        }
    };

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        TypeSpaceMgr.getInstance().addTypeSpaceListener(this.m_typeSpaceListener);
    }

    private void fillActionBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.getToolBarManager().add((IAction)this.m_collapseAllAction);
        actionBars.getToolBarManager().add((IAction)this.m_hideAction);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(parent, 0);
        label.setText("Search:");
        this.m_patternText = new Text(parent, 2048);
        this.m_patternText.setLayoutData((Object)new GridData(768));
        this.m_patternText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r') {
                    TypespaceView.this.filterAndRefreshTree();
                }
            }
        });
        this.m_viewer = new TreeViewer(parent);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.m_viewer.getTree().setLayoutData((Object)gridData);
        this.m_contentProvider = new TypespaceTreeContentProvider();
        this.m_viewer.setContentProvider((IContentProvider)this.m_contentProvider);
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new TypespaceTreeLabelProvider());
        this.m_viewer.setFilters(new ViewerFilter[]{this.m_filter});
        this.m_viewer.addDoubleClickListener(this.m_doubleClickListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.m_viewer);
        Composite composite = new Composite(parent, 0);
        gridData = new GridData(776);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        this.createStateLabel(composite);
        this.m_filter.clearCount();
        this.m_viewer.setInput((Object)TypeSpaceMgr.getInstance());
        this.updateStateLabel();
        this.initContextMenu();
    }

    private void createStateLabel(Composite composite) {
        composite.setLayout((Layout)new GridLayout(6, false));
        GridData data = new GridData(256);
        data.minimumWidth = 90;
        Label proImageLable = new Label(composite, 0);
        proImageLable.setImage(TypespaceTreeLabelProvider.getImageFromIDEImage("IMG_OBJ_PROJECT"));
        this.m_proLabel = new Label(composite, 0);
        this.m_proLabel.setLayoutData((Object)data);
        this.m_proLabel.setText("...");
        this.m_proLabel.setToolTipText("Count of project group");
        Label libImageLable = new Label(composite, 0);
        libImageLable.setImage(DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.library_obj.gif"));
        this.m_libLabel = new Label(composite, 0);
        this.m_libLabel.setLayoutData((Object)data);
        this.m_libLabel.setText("...");
        libImageLable.setToolTipText("Count of binary group");
        Label typeImageLable = new Label(composite, 0);
        typeImageLable.setImage(DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.class_obj.gif"));
        this.m_typeLabel = new Label(composite, 0);
        this.m_typeLabel.setLayoutData((Object)data);
        this.m_typeLabel.setText("...");
        libImageLable.setToolTipText("Count of all Jst type");
    }

    private void updateStateLabel() {
        this.m_proLabel.setText(String.valueOf(this.m_contentProvider.getProCount()));
        this.m_libLabel.setText(String.valueOf(this.m_contentProvider.getOpenLibCount()) + "/" + this.m_contentProvider.getLibCount());
        int totalCount = this.m_contentProvider.getTotalTypeCount();
        int selectedTypeCount = this.m_filter.isEmptyFilter() ? totalCount : this.m_filter.getSelectedTypeCount();
        this.m_typeLabel.setText(String.valueOf(selectedTypeCount) + "/" + totalCount);
        this.m_proLabel.getParent().layout();
    }

    private void filterAndRefreshTree() {
        this.m_filter.clearCount();
        String pattern = this.m_patternText.getText();
        this.m_filter.setFilterStr(pattern);
        if (this.m_viewer.getInput() == null) {
            this.m_viewer.setInput((Object)TypeSpaceMgr.getInstance());
        }
        this.m_viewer.refresh();
        if (!this.m_filter.isEmptyFilter()) {
            this.m_viewer.expandToLevel(2);
        }
        this.updateStateLabel();
    }

    private void initContextMenu() {
        MenuManager popupMenuManager = new MenuManager("#PopupMenu");
        popupMenuManager.add((IAction)new Action("Copy Structure"){

            public void run() {
                Object selectedNode = ((IStructuredSelection)TypespaceView.this.m_viewer.getSelection()).getFirstElement();
                String structure = TypespaceView.this.copyStructure(selectedNode, 0);
                Clipboard clipboard = new Clipboard(Display.getCurrent());
                clipboard.setContents(new Object[]{structure}, new Transfer[]{TextTransfer.getInstance()});
                clipboard.dispose();
            }
        });
        popupMenuManager.add((IAction)new Action("Copy Properties"){

            public void run() {
                Object selectedNode = ((IStructuredSelection)TypespaceView.this.m_viewer.getSelection()).getFirstElement();
                String properties = TypespaceView.this.copyProperties(selectedNode);
                Clipboard clipboard = new Clipboard(Display.getCurrent());
                clipboard.setContents(new Object[]{properties}, new Transfer[]{TextTransfer.getInstance()});
                clipboard.dispose();
            }
        });
        Menu popupMenu = popupMenuManager.createContextMenu((Control)this.m_viewer.getTree());
        this.m_viewer.getTree().setMenu(popupMenu);
        this.getSite().registerContextMenu(popupMenuManager, (ISelectionProvider)this.m_viewer);
        this.fillActionBar();
    }

    private String copyStructure(Object node, int tier) {
        ILabelProvider labelProvider = (ILabelProvider)this.m_viewer.getLabelProvider();
        StringBuilder structureBuilder = new StringBuilder(labelProvider.getText(node));
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.m_viewer.getContentProvider();
        Object[] children = contentProvider.getChildren(node);
        ++tier;
        int i = 0;
        while (i < children.length) {
            String childrenStructure = this.copyStructure(children[i], tier);
            structureBuilder.append("\n");
            int j = 0;
            while (j < tier) {
                structureBuilder.append("\t");
                ++j;
            }
            structureBuilder.append(childrenStructure);
            ++i;
        }
        return structureBuilder.toString();
    }

    private String copyProperties(Object node) {
        INodePrinter nodePrinter = NodePrinterFactory.getNodePrinter(node);
        if (nodePrinter == null) {
            return "";
        }
        String[] names = nodePrinter.getPropertyNames(node);
        if (names.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Object[] values = nodePrinter.getPropertyValuies(node);
        int i = 0;
        while (i < names.length) {
            stringBuilder.append(String.valueOf(names[i]) + ":" + values[i]);
            if (i != names.length - 1) {
                stringBuilder.append("\n");
            }
            ++i;
        }
        return stringBuilder.toString();
    }

    public void setFocus() {
    }

    public void dispose() {
        TypeSpaceMgr.getInstance().removeTypeSpaceListener(this.m_typeSpaceListener);
    }

    public void updateHideState() {
        this.m_filter.clearCount();
        this.m_contentProvider.setHideEmptyBinaryGoupr(!this.m_contentProvider.ifHideEmptyBinaryGroup());
        this.m_viewer.refresh();
        this.updateStateLabel();
    }

    public boolean ifHideEmptyBinaryGroup() {
        return this.m_contentProvider.ifHideEmptyBinaryGroup();
    }

    public void collapseAll() {
        this.m_viewer.collapseAll();
    }

    private class InnerDoubleClickListener
    implements IDoubleClickListener {
        private InnerDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
            if (!(structuredSelection.getFirstElement() instanceof IJstNode)) {
                return;
            }
            Object firstElement = structuredSelection.getFirstElement();
            if (!(firstElement instanceof IJstType)) {
                return;
            }
            IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            IJstType jstType = (IJstType)firstElement;
            URI uri = (URI)TypeSpaceMgr.getInstance().getTypeToFileMap().get(String.valueOf(jstType.getPackage().getGroupName()) + "#" + jstType.getName());
            try {
                if (jstType != null && uri == null) {
                    IType vjoSourceType = CodeassistUtils.findNativeSourceType((IJstType)jstType);
                    DLTKUIPlugin.openInEditor((IModelElement)vjoSourceType, (boolean)true, (boolean)true);
                    return;
                }
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(workspacePath.append(uri.getPath()));
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

