/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsdebugger.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.eclipse.vjet.dsf.jsdebugger.gui.SwingGui;

class Menubar
extends JMenuBar
implements ActionListener {
    private static final long serialVersionUID = 3217170497245911461L;
    private Vector<JMenuItem> m_interruptOnlyItems = new Vector();
    private Vector<JMenuItem> m_runOnlyItems = new Vector();
    private SwingGui m_debugGui;
    private JMenu m_windowMenu;
    private JCheckBoxMenuItem m_breakOnExceptions;
    private JCheckBoxMenuItem m_breakOnEnter;
    private JCheckBoxMenuItem m_breakOnReturn;

    Menubar(SwingGui debugGui) {
        KeyStroke k;
        JMenuItem item;
        this.m_debugGui = debugGui;
        String[] fileItems = new String[]{"Open...", "Run...", "", "Exit"};
        String[] fileCmds = new String[]{"Open", "Load", "", "Exit"};
        char[] cArray = new char[4];
        cArray[0] = 48;
        cArray[1] = 78;
        cArray[3] = 88;
        char[] fileShortCuts = cArray;
        int[] nArray = new int[4];
        nArray[0] = 79;
        nArray[1] = 78;
        nArray[3] = 81;
        int[] fileAccelerators = nArray;
        String[] editItems = new String[]{"Cut", "Copy", "Paste", "Go to function..."};
        char[] editShortCuts = new char[]{'T', 'C', 'P', 'F'};
        String[] debugItems = new String[]{"Break", "Go", "Step Into", "Step Over", "Step Out"};
        char[] debugShortCuts = new char[]{'B', 'G', 'I', 'O', 'T'};
        String[] plafItems = new String[]{"Metal", "Windows", "Motif"};
        char[] plafShortCuts = new char[]{'M', 'W', 'F'};
        int[] nArray2 = new int[7];
        nArray2[0] = 19;
        nArray2[1] = 116;
        nArray2[2] = 122;
        nArray2[3] = 118;
        nArray2[4] = 119;
        int[] debugAccelerators = nArray2;
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('E');
        JMenu plafMenu = new JMenu("Platform");
        plafMenu.setMnemonic('P');
        JMenu debugMenu = new JMenu("Debug");
        debugMenu.setMnemonic('D');
        this.m_windowMenu = new JMenu("Window");
        this.m_windowMenu.setMnemonic('W');
        int i = 0;
        while (i < fileItems.length) {
            if (fileItems[i].length() == 0) {
                fileMenu.addSeparator();
            } else {
                item = new JMenuItem(fileItems[i], fileShortCuts[i]);
                item.setActionCommand(fileCmds[i]);
                item.addActionListener(this);
                fileMenu.add(item);
                if (fileAccelerators[i] != 0) {
                    k = KeyStroke.getKeyStroke(fileAccelerators[i], 2);
                    item.setAccelerator(k);
                }
            }
            ++i;
        }
        i = 0;
        while (i < editItems.length) {
            item = new JMenuItem(editItems[i], editShortCuts[i]);
            item.addActionListener(this);
            editMenu.add(item);
            ++i;
        }
        i = 0;
        while (i < plafItems.length) {
            item = new JMenuItem(plafItems[i], plafShortCuts[i]);
            item.addActionListener(this);
            plafMenu.add(item);
            ++i;
        }
        i = 0;
        while (i < debugItems.length) {
            item = new JMenuItem(debugItems[i], debugShortCuts[i]);
            item.addActionListener(this);
            if (debugAccelerators[i] != 0) {
                k = KeyStroke.getKeyStroke(debugAccelerators[i], 0);
                item.setAccelerator(k);
            }
            if (i != 0) {
                this.m_interruptOnlyItems.add(item);
            } else {
                this.m_runOnlyItems.add(item);
            }
            debugMenu.add(item);
            ++i;
        }
        this.m_breakOnExceptions = new JCheckBoxMenuItem("Break on Exceptions");
        this.m_breakOnExceptions.setMnemonic('X');
        this.m_breakOnExceptions.addActionListener(this);
        this.m_breakOnExceptions.setSelected(false);
        debugMenu.add(this.m_breakOnExceptions);
        this.m_breakOnEnter = new JCheckBoxMenuItem("Break on Function Enter");
        this.m_breakOnEnter.setMnemonic('E');
        this.m_breakOnEnter.addActionListener(this);
        this.m_breakOnEnter.setSelected(false);
        debugMenu.add(this.m_breakOnEnter);
        this.m_breakOnReturn = new JCheckBoxMenuItem("Break on Function Return");
        this.m_breakOnReturn.setMnemonic('R');
        this.m_breakOnReturn.addActionListener(this);
        this.m_breakOnReturn.setSelected(false);
        debugMenu.add(this.m_breakOnReturn);
        this.add(fileMenu);
        this.add(editMenu);
        this.add(debugMenu);
        JMenuItem item2 = new JMenuItem("Cascade", 65);
        this.m_windowMenu.add(item2);
        item2.addActionListener(this);
        item2 = new JMenuItem("Tile", 84);
        this.m_windowMenu.add(item2);
        item2.addActionListener(this);
        this.m_windowMenu.addSeparator();
        item2 = new JMenuItem("Console", 67);
        this.m_windowMenu.add(item2);
        item2.addActionListener(this);
        this.add(this.m_windowMenu);
        this.updateEnabled(false);
    }

    public JCheckBoxMenuItem getBreakOnExceptions() {
        return this.m_breakOnExceptions;
    }

    public JCheckBoxMenuItem getBreakOnEnter() {
        return this.m_breakOnEnter;
    }

    public JCheckBoxMenuItem getBreakOnReturn() {
        return this.m_breakOnReturn;
    }

    public JMenu getDebugMenu() {
        return this.getMenu(2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        String plaf_name = null;
        if (cmd.equals("Metal")) {
            plaf_name = "javax.swing.plaf.metal.MetalLookAndFeel";
        } else if (cmd.equals("Windows")) {
            plaf_name = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        } else if (cmd.equals("Motif")) {
            plaf_name = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
        } else {
            Object source = e.getSource();
            try {
                if (source == this.m_breakOnExceptions) {
                    this.m_debugGui.m_debuggerControl.setBreakOnExceptions(this.m_breakOnExceptions.isSelected());
                } else if (source == this.m_breakOnEnter) {
                    this.m_debugGui.m_debuggerControl.setBreakOnEnter(this.m_breakOnEnter.isSelected());
                } else if (source == this.m_breakOnReturn) {
                    this.m_debugGui.m_debuggerControl.setBreakOnReturn(this.m_breakOnReturn.isSelected());
                } else {
                    this.m_debugGui.actionPerformed(e);
                }
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
            return;
        }
        try {
            UIManager.setLookAndFeel(plaf_name);
            SwingUtilities.updateComponentTreeUI(this.m_debugGui);
            if (SwingGui.s_fileChooserDlg != null) {
                SwingUtilities.updateComponentTreeUI(SwingGui.s_fileChooserDlg);
            }
        }
        catch (Exception exception) {}
    }

    public void addFile(String url) {
        JMenuItem item;
        int count = this.m_windowMenu.getItemCount();
        if (count == 4) {
            this.m_windowMenu.addSeparator();
            ++count;
        }
        JMenuItem lastItem = this.m_windowMenu.getItem(count - 1);
        boolean hasMoreWin = false;
        int maxWin = 5;
        if (lastItem != null && lastItem.getText().equals("More Windows...")) {
            hasMoreWin = true;
            ++maxWin;
        }
        if (!hasMoreWin && count - 4 == 5) {
            JMenuItem item2 = new JMenuItem("More Windows...", 77);
            this.m_windowMenu.add(item2);
            item2.setActionCommand("More Windows...");
            item2.addActionListener(this);
            return;
        }
        if (count - 4 <= maxWin) {
            if (hasMoreWin) {
                --count;
                this.m_windowMenu.remove(lastItem);
            }
            String shortName = SwingGui.getShortName(url);
            item = new JMenuItem(String.valueOf((char)(48 + (count - 4))) + " " + shortName, 48 + (count - 4));
            this.m_windowMenu.add(item);
            if (hasMoreWin) {
                this.m_windowMenu.add(lastItem);
            }
        } else {
            return;
        }
        item.setActionCommand(url);
        item.addActionListener(this);
    }

    public void updateEnabled(boolean interrupted) {
        JMenuItem item;
        int i = 0;
        while (i != this.m_interruptOnlyItems.size()) {
            item = this.m_interruptOnlyItems.elementAt(i);
            item.setEnabled(interrupted);
            ++i;
        }
        i = 0;
        while (i != this.m_runOnlyItems.size()) {
            item = this.m_runOnlyItems.elementAt(i);
            item.setEnabled(!interrupted);
            ++i;
        }
    }
}

