/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.jsruntime.optimizer;

import org.eclipse.vjet.dsf.common.converter.IConverter;
import org.eclipse.vjet.dsf.common.exceptions.DsfException;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.html.js.IJsFunc;
import org.eclipse.vjet.dsf.html.js.IJsObjectRef;
import org.eclipse.vjet.vsf.jsruntime.context.JsRuntimeCtx;
import org.eclipse.vjet.vsf.jsruntime.jsconverters.DefaultJava2JsConverter;
import org.eclipse.vjet.vsf.jsruntime.jsconverters.registry.Java2JsTypeConverterRegistration;
import org.eclipse.vjet.vsf.jsruntime.optimizer.IJsOptimizer;
import org.eclipse.vjet.vsf.jsruntime.optimizer.JsFuncOptimizer;
import org.eclipse.vjet.vsf.jsruntime.optimizer.JsObjOptimizer;

public class OptimizerUtil {
    public static IJsOptimizer createOptimizer(Object obj) throws DsfException {
        if (obj instanceof IJsObjectRef) {
            return new JsObjOptimizer((IJsObjectRef)obj);
        }
        if (obj instanceof IJsFunc) {
            return new JsFuncOptimizer((IJsFunc)obj);
        }
        return null;
    }

    public static IConverter getDefaultConverter(Object value) {
        Class<?> fromType = null;
        Class<String> toType = null;
        Java2JsTypeConverterRegistration registry = JsRuntimeCtx.ctx().getConverterRegistry();
        try {
            if (value != null) {
                fromType = value.getClass();
            }
            toType = String.class;
            IConverter converter = null;
            while (fromType != null) {
                converter = registry.get(fromType, toType);
                if (converter != null) {
                    return converter;
                }
                Class<?>[] clzs = fromType.getInterfaces();
                if (converter == null && clzs != null) {
                    Class<?>[] classArray = clzs;
                    int n = clzs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class<?> clz = classArray[n2];
                        IConverter tmp = registry.get(clz, toType);
                        if (tmp != null) {
                            return tmp;
                        }
                        ++n2;
                    }
                }
                fromType = fromType.getSuperclass();
            }
            if (converter == null) {
                return new DefaultJava2JsConverter();
            }
            return converter;
        }
        catch (RuntimeException e) {
            throw new DsfRuntimeException("Got exception when looking up the registry: fromType:" + fromType + " toType:" + toType + " value: " + value, (Throwable)e);
        }
    }
}

