/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.resource.x;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.resource.permutation.Permutation;
import org.eclipse.vjet.dsf.resource.trace.ResourceUsageCtx;

public abstract class ResourceCtxIsolatedProcessor<RETURN_OBJ, THROWABLE extends Throwable> {
    protected abstract RETURN_OBJ process() throws THROWABLE;

    public RETURN_OBJ run(ProcessMode ... actions) throws THROWABLE {
        return this.run((Permutation)null, (Boolean)null, actions);
    }

    public RETURN_OBJ run(Permutation permutation, Boolean secure, ProcessMode ... actions) throws THROWABLE {
        HashSet<ProcessMode> actionsSet = new HashSet<ProcessMode>(Arrays.asList(actions));
        boolean oldNeedObf = ResourceUsageCtx.ctx().isNeedObfuscation();
        boolean oldNeedMin = ResourceUsageCtx.ctx().isNeedMinification();
        boolean oldNeedCssOpt = ResourceUsageCtx.ctx().isNeedCssOptimization();
        boolean oldVerboseMode = ResourceUsageCtx.ctx().isNeedVerboseInfo();
        boolean oldFragmentExtractionMode = ResourceUsageCtx.ctx().isFragmentExtractionMode();
        Permutation oldPermutation = null;
        Boolean oldSecure = null;
        try {
            if (secure != null) {
                oldSecure = DsfCtx.ctx().isSecureRequest();
                DsfCtx.ctx().setRequestSecure(secure.booleanValue());
            }
            if (permutation != null) {
                oldPermutation = Permutation.getFromCtx();
                permutation.setToCtx();
            }
            ResourceUsageCtx.ctx().setNeedObfuscation(actionsSet.contains((Object)ProcessMode.JsObf) || actionsSet.contains((Object)ProcessMode.Inherit) && ResourceUsageCtx.ctx().isNeedObfuscation());
            ResourceUsageCtx.ctx().setNeedMinification(actionsSet.contains((Object)ProcessMode.JsMin) || actionsSet.contains((Object)ProcessMode.Inherit) && ResourceUsageCtx.ctx().isNeedMinification());
            ResourceUsageCtx.ctx().setNeedCssOptimization(actionsSet.contains((Object)ProcessMode.CssOpt) || actionsSet.contains((Object)ProcessMode.Inherit) && ResourceUsageCtx.ctx().isNeedCssOptimization());
            ResourceUsageCtx.ctx().setNeedVerboseInfo((actionsSet.contains((Object)ProcessMode.Verbose) || actionsSet.contains((Object)ProcessMode.Inherit) && ResourceUsageCtx.ctx().isNeedVerboseInfo()) && !actionsSet.contains((Object)ProcessMode.FragmentExtraction));
            ResourceUsageCtx.ctx().setFragmentExtractionMode(actionsSet.contains((Object)ProcessMode.FragmentExtraction));
            RETURN_OBJ RETURN_OBJ = this.process();
            return RETURN_OBJ;
        }
        finally {
            ResourceUsageCtx.ctx().setNeedObfuscation(oldNeedObf);
            ResourceUsageCtx.ctx().setNeedMinification(oldNeedMin);
            ResourceUsageCtx.ctx().setNeedCssOptimization(oldNeedCssOpt);
            ResourceUsageCtx.ctx().setNeedVerboseInfo(oldVerboseMode);
            ResourceUsageCtx.ctx().setFragmentExtractionMode(oldFragmentExtractionMode);
            if (oldPermutation != null) {
                oldPermutation.setToCtx();
            }
            if (oldSecure != null) {
                DsfCtx.ctx().setRequestSecure(oldSecure.booleanValue());
            }
        }
    }

    public static enum ProcessMode {
        None,
        JsObf,
        JsMin,
        CssOpt,
        Verbose,
        FragmentExtraction,
        Inherit;

    }
}

