/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html;

import java.io.Writer;
import org.eclipse.vjet.dsf.common.xml.IIndenter;
import org.eclipse.vjet.dsf.dom.util.DomWriterCtx;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnumAssociator;
import org.eclipse.vjet.dsf.html.schemas.Html401Transitional;
import org.eclipse.vjet.dsf.html.schemas.ISchema;

public class HtmlWriterCtx
extends DomWriterCtx {
    private ISchema m_schema;
    private final HtmlTypeEnum[] m_notEscapeTags;
    static final HtmlTypeEnum[] TAGS_TO_NOT_ESCAPE_TXT = new HtmlTypeEnum[]{HtmlTypeEnum.SCRIPT, HtmlTypeEnum.STYLE};

    public HtmlWriterCtx() {
        this(HtmlWriterCtx.createWriter(), IIndenter.COMPACT, HtmlWriterCtx.getDefaultSchema(), TAGS_TO_NOT_ESCAPE_TXT);
    }

    public HtmlWriterCtx(Writer writer) {
        this(writer, IIndenter.COMPACT, HtmlWriterCtx.getDefaultSchema(), TAGS_TO_NOT_ESCAPE_TXT);
    }

    public HtmlWriterCtx(ISchema schema) {
        this(HtmlWriterCtx.createWriter(), IIndenter.COMPACT, schema, TAGS_TO_NOT_ESCAPE_TXT);
    }

    public HtmlWriterCtx(IIndenter indenter) {
        this(HtmlWriterCtx.createWriter(), indenter, HtmlWriterCtx.getDefaultSchema(), TAGS_TO_NOT_ESCAPE_TXT);
    }

    public HtmlWriterCtx(HtmlTypeEnum[] notEscapeTags) {
        if (notEscapeTags != null) {
            if (notEscapeTags == TAGS_TO_NOT_ESCAPE_TXT) {
                this.m_notEscapeTags = TAGS_TO_NOT_ESCAPE_TXT;
            } else {
                this.m_notEscapeTags = new HtmlTypeEnum[notEscapeTags.length];
                int i = 0;
                while (i < notEscapeTags.length) {
                    this.m_notEscapeTags[i] = notEscapeTags[i];
                    ++i;
                }
            }
        } else {
            this.m_notEscapeTags = null;
        }
    }

    public HtmlWriterCtx(Writer writer, IIndenter indenter, ISchema schema) {
        this(writer, indenter, schema, TAGS_TO_NOT_ESCAPE_TXT);
    }

    public HtmlWriterCtx(Writer writer, IIndenter indenter) {
        this(writer, indenter, HtmlWriterCtx.getDefaultSchema(), TAGS_TO_NOT_ESCAPE_TXT);
    }

    HtmlWriterCtx(Writer writer, IIndenter indenter, ISchema schema, HtmlTypeEnum[] notEscapeTags) {
        super(writer, indenter);
        this.m_schema = schema;
        if (notEscapeTags != null) {
            if (notEscapeTags == TAGS_TO_NOT_ESCAPE_TXT) {
                this.m_notEscapeTags = TAGS_TO_NOT_ESCAPE_TXT;
            } else {
                this.m_notEscapeTags = new HtmlTypeEnum[notEscapeTags.length];
                int i = 0;
                while (i < notEscapeTags.length) {
                    this.m_notEscapeTags[i] = notEscapeTags[i];
                    ++i;
                }
            }
        } else {
            this.m_notEscapeTags = null;
        }
    }

    public static ISchema getDefaultSchema() {
        return Html401Transitional.getInstance();
    }

    public char[][] getNotEscapeTags() {
        if (this.m_notEscapeTags == null) {
            return null;
        }
        char[][] notEscapeTagNames = new char[this.m_notEscapeTags.length][];
        int i = 0;
        while (i < this.m_notEscapeTags.length) {
            notEscapeTagNames[i] = HtmlTypeEnumAssociator.getNameCharArray(this.m_notEscapeTags[i]);
            ++i;
        }
        return notEscapeTagNames;
    }

    public HtmlWriterCtx setAddLineNumber(boolean value) {
        super.setAddLineNumber(value);
        return this;
    }

    public HtmlWriterCtx setWriter(Writer writer) {
        super.setWriter(writer);
        return this;
    }

    public HtmlWriterCtx setIndenter(IIndenter indenter) {
        super.setIndenter(indenter);
        return this;
    }

    public HtmlWriterCtx setRenderXmlDoc(boolean value) {
        super.setRenderXmlDoc(value);
        return this;
    }

    public HtmlWriterCtx setTrimDText(boolean value) {
        super.setTrimDText(value);
        return this;
    }

    public HtmlWriterCtx setRenderNS(boolean value) {
        super.setRenderNS(value);
        return this;
    }

    public HtmlWriterCtx setOptimization(boolean value) {
        super.setOptimization(value);
        return this;
    }

    public ISchema getSchema() {
        return this.m_schema;
    }
}

