/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.events;

import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.html.ctx.HtmlCtx;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.html.dom.util.InvisibleContainer;
import org.eclipse.vjet.dsf.html.events.EventHandlerContainer;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.html.events.IDomEventType;
import org.eclipse.vjet.dsf.html.events.IDomType;
import org.eclipse.vjet.dsf.html.events.ISimpleJsEventHandler;
import org.eclipse.vjet.dsf.html.js.IJsFunc;
import org.eclipse.vjet.dsf.html.js.JsFunctionEventHandlerAdaptor;

public class EventHandlerAttacher {
    public static void add(DElement element, IDomEventType eventType, ISimpleJsEventHandler handler) {
        EventHandlerAttacher.assertValidParams(element, handler);
        if (element instanceof BaseHtmlElement) {
            BaseHtmlElement elem = (BaseHtmlElement)element;
            if (elem.getHtmlId().equals("")) {
                elem.setHtmlId(DsfCtx.ctx().ids().nextHtmlId());
            }
        } else if (element.getAttribute("id").equals("")) {
            element.setAttribute("id", DsfCtx.ctx().ids().nextHtmlId());
        }
        EventHandlerAttacher.getEventHandlerContainer().add(element, eventType, handler);
    }

    public static void add(DElement element, IDomEventType eventType, String jsText) {
        EventHandlerAttacher.add(element, eventType, EventHandlerAttacher.viaText(jsText));
    }

    public static void add(DElement element, IDomEventType eventType, IJsFunc jsFunc) {
        EventHandlerAttacher.add(element, eventType, (ISimpleJsEventHandler)new JsFunctionEventHandlerAdaptor(jsFunc));
    }

    public static void add(String elementId, IDomEventType eventType, ISimpleJsEventHandler handler) {
        EventHandlerAttacher.assertValidParams(elementId, handler);
        EventHandlerAttacher.getEventHandlerContainer().add(elementId, eventType, handler);
    }

    public static void add(String elementId, IDomEventType eventType, String jsText) {
        EventHandlerAttacher.add(elementId, eventType, EventHandlerAttacher.viaText(jsText));
    }

    public static void add(String element, IDomEventType eventType, IJsFunc jsFunc) {
        EventHandlerAttacher.add(element, eventType, (ISimpleJsEventHandler)new JsFunctionEventHandlerAdaptor(jsFunc));
    }

    public static void add(IDomType element, IDomEventType eventType, ISimpleJsEventHandler handler) {
        EventHandlerAttacher.assertValidParams(element, handler);
        EventHandlerAttacher.getEventHandlerContainer().add(element, eventType, handler);
    }

    public static void add(IDomType element, IDomEventType eventType, String jsText) {
        EventHandlerAttacher.add(element, eventType, EventHandlerAttacher.viaText(jsText));
    }

    public static void add(IDomType element, IDomEventType eventType, IJsFunc jsFunc) {
        EventHandlerAttacher.add(element, eventType, (ISimpleJsEventHandler)new JsFunctionEventHandlerAdaptor(jsFunc));
    }

    public static boolean remove(String element, ISimpleJsEventHandler handler) {
        EventHandlerAttacher.assertValidParams(element, handler);
        return EventHandlerAttacher.getEventHandlerContainer().removeHandler(element, handler);
    }

    public static boolean remove(DElement element, ISimpleJsEventHandler handler) {
        EventHandlerAttacher.assertValidParams(element, handler);
        return EventHandlerAttacher.getEventHandlerContainer().removeHandler(element, handler);
    }

    public static boolean remove(IDomType element, ISimpleJsEventHandler handler) {
        EventHandlerAttacher.assertValidParams(element, handler);
        return EventHandlerAttacher.getEventHandlerContainer().removeHandler(element, handler);
    }

    public static boolean hasEventHandlers(DElement elem) {
        return EventHandlerAttacher.getEventHandlerContainer().getNumOfHandlers(elem) > 0;
    }

    private static ISimpleJsEventHandler viaText(final String jsText) {
        try {
            (new Object[1])[0] = jsText;
            return new ISimpleJsEventHandler(){

                @Override
                public String asJsHandler() {
                    return jsText;
                }

                @Override
                public String asJsDefinition() {
                    return jsText;
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static EventHandlerContainer getEventHandlerContainer() {
        return HtmlCtx.ctx().getEventHandlerContainer();
    }

    private static void assertValidParams(Object element, ISimpleJsEventHandler handler) {
        EventHandlerAttacher.assertValidElement(element);
        EventHandlerAttacher.assertValidHandler(handler);
    }

    private static void assertValidHandler(ISimpleJsEventHandler handler) {
        if (handler == null) {
            EventHandlerAttacher.chuck("handler is null");
        }
    }

    private static void assertValidElement(Object element) {
        if (element == null) {
            EventHandlerAttacher.chuck("element is null");
        }
        if (element instanceof InvisibleContainer) {
            EventHandlerAttacher.chuck("Can not attach events to invisible container");
        }
    }

    private static void chuck(String string) {
        throw new DsfRuntimeException(string);
    }

    public static void addToBodyLoad(ISimpleJsEventHandler handler) {
        EventHandlerAttacher.addToBody((IDomEventType)EventType.LOAD, handler);
    }

    public static void addToBodyLoad(String jsText) {
        EventHandlerAttacher.addToBody((IDomEventType)EventType.LOAD, jsText);
    }

    public static void addToBodyUnload(ISimpleJsEventHandler handler) {
        EventHandlerAttacher.addToBody((IDomEventType)EventType.UNLOAD, handler);
    }

    public static void addToBodyUnload(String jsText) {
        EventHandlerAttacher.addToBody((IDomEventType)EventType.UNLOAD, jsText);
    }

    public static void addToBodyLoad(IJsFunc jsFunc) {
        EventHandlerAttacher.addToBody((IDomEventType)EventType.LOAD, jsFunc);
    }

    public static void addToBodyUnload(IJsFunc jsFunc) {
        EventHandlerAttacher.addToBody((IDomEventType)EventType.UNLOAD, jsFunc);
    }

    public static void addToBody(IDomEventType eventType, ISimpleJsEventHandler handler) {
        EventHandlerAttacher.getEventHandlerContainer().add(HtmlTypeEnum.BODY, eventType, handler);
    }

    public static void addToBody(IDomEventType eventType, String jsText) {
        EventHandlerAttacher.add((IDomType)HtmlTypeEnum.BODY, eventType, EventHandlerAttacher.viaText(jsText));
    }

    public static void addToBody(IDomEventType eventType, IJsFunc jsFunc) {
        EventHandlerAttacher.add((IDomType)HtmlTypeEnum.BODY, eventType, jsFunc);
    }
}

