/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.vtp.framework.media.binding.BindingGroup;

public class BindingModule {
    public static final String DEFAULT_NAME = "";
    private String name;
    private Map groups = new LinkedHashMap();

    public BindingModule(String name) {
        this.name = name == null || name.length() == 0 ? DEFAULT_NAME : name;
    }

    public BindingModule(String name, BindingGroup[] groups) {
        this(name);
        if (groups != null) {
            int i = 0;
            while (i < groups.length) {
                this.addGroup(groups[i]);
                ++i;
            }
        }
    }

    public BindingModule(String name, Collection groups) {
        this(name, groups == null ? null : groups.toArray(new BindingGroup[groups.size()]));
    }

    public String getName() {
        return this.name;
    }

    public BindingGroup getGroup(String name) {
        return (BindingGroup)this.groups.get(name);
    }

    public boolean addGroup(BindingGroup group) {
        if (group == null || this.groups.containsKey(group.getName())) {
            return false;
        }
        this.groups.put(group.getName(), group);
        return true;
    }

    public boolean removeGroup(BindingGroup group) {
        if (group == null || !this.groups.containsValue(group)) {
            return false;
        }
        this.groups.remove(group.getName());
        return true;
    }

    public Set getGroupNames() {
        return new LinkedHashSet(this.groups.keySet());
    }

    public Collection getGroups() {
        return new ArrayList(this.groups.values());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BindingModule other = (BindingModule)obj;
        return this.name.equals(other.name) && this.groups.equals(other.groups);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.name.hashCode() ^ this.groups.hashCode();
    }

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1) + "(name='" + this.name + "',groups=" + this.groups.values() + ')';
    }
}

