/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.vtp.framework.media.binding.BindingModule;

public class MediaBinding {
    private Map modules = new HashMap();

    public MediaBinding() {
    }

    public MediaBinding(BindingModule[] modules) {
        if (modules != null) {
            int i = 0;
            while (i < modules.length) {
                this.addModule(modules[i]);
                ++i;
            }
        }
    }

    public BindingModule getModule(String name) {
        return (BindingModule)this.modules.get(name);
    }

    public boolean addModule(BindingModule module) {
        if (module == null || this.modules.containsKey(module.getName())) {
            return false;
        }
        this.modules.put(module.getName(), module);
        return true;
    }

    public boolean removeModule(BindingModule module) {
        if (module == null || !this.modules.containsValue(module)) {
            return false;
        }
        this.modules.remove(module.getName());
        return true;
    }

    public Set getModuleNames() {
        return new LinkedHashSet(this.modules.keySet());
    }

    public Collection getModules() {
        return new ArrayList(this.modules.values());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MediaBinding other = (MediaBinding)obj;
        return this.modules.equals(other.modules);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.modules.hashCode();
    }

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1) + "(modules=" + this.modules + ')';
    }
}

