/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.files;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.vtp.framework.media.files.MediaContainer;
import org.eclipse.vtp.framework.media.files.MediaObject;

public class MediaContainerSupport
implements MediaContainer {
    private final Map contents = new TreeMap();

    public boolean add(MediaObject object) {
        if (object == null || this.contents.containsKey(object.getName())) {
            return false;
        }
        this.contents.put(object.getName(), object);
        return true;
    }

    public MediaObject get(String name) {
        return (MediaObject)this.contents.get(name);
    }

    public MediaObject find(String path) {
        MediaContainer con = this;
        MediaObject obj = null;
        StringTokenizer st = new StringTokenizer(path, "/\\");
        while (st.hasMoreTokens()) {
            if (con == null) {
                return null;
            }
            obj = con.get(st.nextToken());
            if (obj == null) {
                return null;
            }
            con = obj instanceof MediaContainer ? (MediaContainer)((Object)obj) : null;
        }
        return obj;
    }

    public Set getNames() {
        return new LinkedHashSet(this.contents.keySet());
    }

    public Collection getAll() {
        return new ArrayList(this.contents.values());
    }

    public Set getDirectoryNames() {
        Set names = this.getNames();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            if (!this.get(i.next().toString()).isFile()) continue;
            i.remove();
        }
        return names;
    }

    public Collection getDirectories() {
        Collection objects = this.getAll();
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            if (!((MediaObject)i.next()).isFile()) continue;
            i.remove();
        }
        return objects;
    }

    public Set getFileNames() {
        Set names = this.getNames();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            if (!this.get(i.next().toString()).isDirectory()) continue;
            i.remove();
        }
        return names;
    }

    public Collection getFiles() {
        Collection objects = this.getAll();
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            if (!((MediaObject)i.next()).isDirectory()) continue;
            i.remove();
        }
        return objects;
    }

    public boolean remove(MediaObject object) {
        if (object == null || !this.contents.containsKey(object.getName())) {
            return false;
        }
        this.contents.remove(object.getName());
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.contents.equals(((MediaContainerSupport)obj).contents);
    }

    public int hashCode() {
        return this.contents.hashCode();
    }
}

