/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.language;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.vtp.framework.media.language.LanguageGroup;

public class LanguageCategory {
    private Map groups = new LinkedHashMap();

    public LanguageCategory() {
    }

    public LanguageCategory(LanguageGroup[] groups) {
        if (groups != null) {
            int i = 0;
            while (i < groups.length) {
                this.addGroup(groups[i]);
                ++i;
            }
        }
    }

    public LanguageCategory(Collection groups) {
        this(groups == null ? null : groups.toArray(new LanguageGroup[groups.size()]));
    }

    public LanguageGroup getGroup(String name) {
        return (LanguageGroup)this.groups.get(name);
    }

    public boolean addGroup(LanguageGroup group) {
        if (group == null || this.groups.containsKey(group.getName())) {
            return false;
        }
        this.groups.put(group.getName(), group);
        return true;
    }

    public boolean removeGroup(LanguageGroup group) {
        if (group == null || !this.groups.containsValue(group)) {
            return false;
        }
        this.groups.remove(group.getName());
        return true;
    }

    public Set getGroupNames() {
        return new LinkedHashSet(this.groups.keySet());
    }

    public Collection getGroups() {
        return new ArrayList(this.groups.values());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.groups.equals(((LanguageCategory)obj).groups);
    }

    public int hashCode() {
        return this.groups.hashCode();
    }

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1) + "(groups=" + this.groups.keySet() + ')';
    }
}

