/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.library;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.vtp.framework.media.library.LibraryGrammarEntry;

public class LibraryGrammars {
    private Map entries = new LinkedHashMap();

    public LibraryGrammars() {
    }

    public LibraryGrammars(LibraryGrammarEntry[] entries) {
        if (entries != null) {
            int i = 0;
            while (i < entries.length) {
                this.addEntry(entries[i]);
                ++i;
            }
        }
    }

    public LibraryGrammars(Collection entries) {
        this(entries == null ? null : entries.toArray(new LibraryGrammarEntry[entries.size()]));
    }

    public LibraryGrammarEntry getEntry(String name) {
        return (LibraryGrammarEntry)this.entries.get(name);
    }

    public boolean addEntry(LibraryGrammarEntry entry) {
        if (entry == null || this.entries.containsKey(entry.getName())) {
            return false;
        }
        this.entries.put(entry.getName(), entry);
        return true;
    }

    public boolean removeEntry(LibraryGrammarEntry entry) {
        if (entry == null || !this.entries.containsValue(entry)) {
            return false;
        }
        this.entries.remove(entry.getName());
        return true;
    }

    public Set getEntryNames() {
        return new LinkedHashSet(this.entries.keySet());
    }

    public Collection getEntries() {
        return new ArrayList(this.entries.values());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.entries.equals(((LibraryGrammars)obj).entries);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.entries.hashCode();
    }

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1) + "(entries=" + this.entries.keySet() + ')';
    }
}

