/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.persona;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vtp.framework.media.prompts.CharactersPrompt;
import org.eclipse.vtp.framework.media.prompts.FilePrompt;
import org.eclipse.vtp.framework.media.prompts.Prompt;
import org.eclipse.vtp.framework.media.prompts.PromptVisitorAdapter;
import org.eclipse.vtp.framework.media.prompts.ReferencePrompt;
import org.eclipse.vtp.framework.media.prompts.TextPrompt;

public class PersonaPromptEntry {
    public static final String DEFAULT_NAME = "Untitled Entry";
    public static final Prompt.Visitor VALID_PROMPT_TYPES = new PromptVisitorAdapter(){

        public Object charactersPrompt(CharactersPrompt charactersPrompt) {
            return charactersPrompt;
        }

        public Object filePrompt(FilePrompt filePrompt) {
            return filePrompt;
        }

        public Object referencePrompt(ReferencePrompt referencePrompt) {
            return referencePrompt;
        }

        public Object textPrompt(TextPrompt textPrompt) {
            return textPrompt;
        }
    };
    private String name;
    private final List content = new ArrayList();

    public PersonaPromptEntry(String name) {
        this.name = name == null || name.length() == 0 ? DEFAULT_NAME : name;
    }

    public PersonaPromptEntry(String name, List content) {
        this(name, content == null ? null : content.toArray(new Prompt[content.size()]));
    }

    public PersonaPromptEntry(String name, Prompt[] content) {
        this(name);
        if (content != null) {
            int i = 0;
            while (i < content.length) {
                this.add(content[i]);
                ++i;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean add(Prompt prompt) {
        if (prompt == null) {
            return false;
        }
        if ((prompt = (Prompt)prompt.accept(VALID_PROMPT_TYPES)) == null) {
            return false;
        }
        return this.content.add(prompt);
    }

    public boolean insert(int index, Prompt prompt) {
        if (prompt == null) {
            return false;
        }
        if ((prompt = (Prompt)prompt.accept(VALID_PROMPT_TYPES)) == null) {
            return false;
        }
        this.content.add(index, prompt);
        return true;
    }

    public Prompt get(int index) {
        return (Prompt)this.content.get(index);
    }

    public List getAll() {
        return new ArrayList(this.content);
    }

    public void setAll(List all) {
        this.content.clear();
        this.content.addAll(all);
    }

    public int size() {
        return this.content.size();
    }

    public void moveUp(int index) {
        this.content.add(index - 1, this.content.remove(index));
    }

    public void moveDown(int index) {
        this.content.add(index + 1, this.content.remove(index));
    }

    public Prompt remove(int index) {
        return (Prompt)this.content.remove(index);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PersonaPromptEntry le = (PersonaPromptEntry)obj;
        return this.name.equals(le.name) && this.content.equals(le.content);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.name.hashCode() ^ this.content.hashCode();
    }

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1) + "(name='" + this.name + "',content=" + this.content + ")";
    }
}

