/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.util;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.eclipse.vtp.framework.media.binding.MediaBinding;
import org.eclipse.vtp.framework.media.grammars.ReferenceGrammar;
import org.eclipse.vtp.framework.media.prompts.ReferencePrompt;
import org.eclipse.vtp.framework.media.util.BindingIndex;
import org.eclipse.vtp.framework.media.util.BrandLibraryIndex;
import org.eclipse.vtp.framework.media.util.DefaultBindingIndex;
import org.eclipse.vtp.framework.media.util.GrammarSolutionOutput;
import org.eclipse.vtp.framework.media.util.PromptSolutionOutput;

public class CustomBindingIndex
extends BindingIndex {
    private DefaultBindingIndex parentIndex = null;

    public CustomBindingIndex() {
    }

    public CustomBindingIndex(MediaBinding binding, BrandLibraryIndex brand, DefaultBindingIndex parentIndex) {
        super(binding, brand);
        this.setParentIndex(parentIndex);
    }

    public void setParentIndex(DefaultBindingIndex parentIndex) {
        this.parentIndex = parentIndex;
    }

    public DefaultBindingIndex getParentIndex() {
        return this.parentIndex;
    }

    public Set indexDialogs(String module, String instance) {
        HashSet tmp = new HashSet();
        if (this.parentIndex != null) {
            tmp.addAll(this.parentIndex.indexDialogs(module, instance));
        }
        if (this.getBinding() != null && this.getBinding().getModule(module) != null && this.getBinding().getModule(module).getGroup(instance) != null) {
            tmp.addAll(this.getBinding().getModule(module).getGroup(instance).getDialogs());
        }
        return tmp;
    }

    protected boolean solveUnresolvedPrompt(ReferencePrompt prompt, String module, String instance, String dialog, PromptSolutionOutput output, Locale locale) {
        if (this.getBrand().solvePrompt(prompt, output, locale)) {
            return true;
        }
        return this.getParentIndex().solvePrompt(prompt, module, instance, dialog, output, locale);
    }

    protected boolean solveUnresolvedGrammar(ReferenceGrammar grammar, String module, String instance, String dialog, GrammarSolutionOutput output, Locale locale) {
        if (this.getBrand().solveGrammar(grammar, output, locale)) {
            return true;
        }
        return this.getParentIndex().solveGrammar(grammar, module, instance, dialog, output, locale);
    }
}

