/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.vtp.framework.media.files.MediaFiles;
import org.eclipse.vtp.framework.media.grammars.ReferenceGrammar;
import org.eclipse.vtp.framework.media.library.LibraryGrammarEntry;
import org.eclipse.vtp.framework.media.library.LibraryPromptEntry;
import org.eclipse.vtp.framework.media.library.MediaLibrary;
import org.eclipse.vtp.framework.media.prompts.ReferencePrompt;
import org.eclipse.vtp.framework.media.util.BrandLibraryIndex;
import org.eclipse.vtp.framework.media.util.GrammarSolutionOutput;
import org.eclipse.vtp.framework.media.util.PersonaIndex;
import org.eclipse.vtp.framework.media.util.PromptSolutionOutput;

public class DefaultBrandLibraryIndex
extends BrandLibraryIndex {
    private Map personasByLocale = new HashMap();
    private Locale defaultLocale = null;

    public DefaultBrandLibraryIndex() {
    }

    public DefaultBrandLibraryIndex(MediaLibrary library, MediaFiles files, String filePrefix, PersonaIndex[] personas) {
        super(library, files, filePrefix);
        this.setPersonas(personas);
    }

    public void setPersonas(PersonaIndex[] personas) {
        this.personasByLocale.clear();
        this.defaultLocale = null;
        if (personas.length > 0) {
            Locale systemLocale = Locale.getDefault();
            int i = 0;
            while (i < personas.length) {
                this.personasByLocale.put(personas[i].getLocale(), personas[i]);
                if (systemLocale.toString().startsWith(personas[i].getLocale().toString()) && (this.defaultLocale == null || this.defaultLocale.toString().length() <= personas[i].getLocale().toString().length())) {
                    this.defaultLocale = personas[i].getLocale();
                }
                ++i;
            }
            if (this.defaultLocale == null) {
                this.defaultLocale = personas[0].getLocale();
            }
        }
    }

    public PersonaIndex[] getPersonas() {
        return this.personasByLocale.values().toArray(new PersonaIndex[this.personasByLocale.size()]);
    }

    public Locale[] getLocales() {
        return this.personasByLocale.keySet().toArray(new Locale[this.personasByLocale.size()]);
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public PersonaIndex getPersonaIndex(Locale locale) {
        return (PersonaIndex)this.personasByLocale.get(locale);
    }

    public Map indexAvailablePrompts(String excludeName, String excludeContainer) {
        HashMap results = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        Iterator i = this.getLibrary().getPrompts().getEntries().iterator();
        while (i.hasNext()) {
            LibraryPromptEntry entry = (LibraryPromptEntry)i.next();
            if (entry.getName().equals(excludeName)) continue;
            list.add(entry.getName());
        }
        results.put("", list);
        return results;
    }

    public Map indexAvailableGrammars(String excludeName, String excludeContainer) {
        HashMap results = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        Iterator i = this.getLibrary().getGrammars().getEntries().iterator();
        while (i.hasNext()) {
            LibraryGrammarEntry entry = (LibraryGrammarEntry)i.next();
            if (entry.getName().equals(excludeName)) continue;
            list.add(entry.getName());
        }
        results.put("", list);
        return results;
    }

    protected boolean solveUnresolvedPrompt(ReferencePrompt prompt, PromptSolutionOutput output, Locale locale) {
        return false;
    }

    protected boolean solveUnresolvedGrammar(ReferenceGrammar grammar, GrammarSolutionOutput output, Locale locale) {
        return false;
    }
}

