/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.xml;

import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.vtp.framework.media.xml.MediaXMLContstants;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class AbstractDecoder
implements ContentHandler,
MediaXMLContstants {
    private final LinkedList stack = new LinkedList();
    private final StringBuffer characters = new StringBuffer();
    private boolean collectingCharacters = false;

    protected AbstractDecoder() {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.collectingCharacters) {
            this.characters.append(ch, start, length);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    protected final void push(Object obj) {
        this.stack.addLast(obj);
    }

    protected final Object peek() {
        return this.stack.getLast();
    }

    protected final Object pop() {
        return this.stack.removeLast();
    }

    protected final void startCollectingCharacters() {
        this.collectingCharacters = true;
    }

    protected final String stopCollectingCharacters() {
        this.collectingCharacters = false;
        String result = this.characters.toString();
        this.characters.setLength(0);
        return result;
    }

    protected final Date decodeDate(String dateStr) {
        if (dateStr == null || dateStr.length() == 0) {
            return null;
        }
        int dash1 = dateStr.indexOf(45);
        int dash2 = dateStr.indexOf(45, dash1 + 1);
        int dash3 = dateStr.indexOf(45, dash2 + 1);
        if (dash3 < 0) {
            dash3 = dateStr.indexOf(43, dash2 + 1);
        }
        Calendar calendar = null;
        calendar = dash3 < 0 ? Calendar.getInstance() : Calendar.getInstance(TimeZone.getTimeZone("GMT" + dateStr.substring(dash3)));
        calendar.set(1, Integer.parseInt(dateStr.substring(0, dash1)));
        calendar.set(2, Integer.parseInt(dateStr.substring(dash1 + 1, dash2)) - 1);
        calendar.set(5, Integer.parseInt(dash3 < 0 ? dateStr.substring(dash2 + 1) : dateStr.substring(dash2 + 1, dash3)));
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(9, 0);
        return calendar.getTime();
    }

    protected final Date decodeDateTime(String dateTimeStr) {
        if (dateTimeStr == null || dateTimeStr.length() == 0) {
            return null;
        }
        int dash1 = dateTimeStr.indexOf(45);
        int dash2 = dateTimeStr.indexOf(45, dash1 + 1);
        int dash3 = dateTimeStr.indexOf(84, dash2 + 1);
        int dash4 = dateTimeStr.indexOf(58, dash3 + 1);
        int dash5 = dateTimeStr.indexOf(58, dash4 + 1);
        int dash6 = dateTimeStr.indexOf(45, dash5 + 1);
        if (dash6 < 0) {
            dash6 = dateTimeStr.indexOf(43, dash5 + 1);
        }
        Calendar calendar = null;
        calendar = dash6 < 0 ? Calendar.getInstance() : Calendar.getInstance(TimeZone.getTimeZone("GMT" + dateTimeStr.substring(dash6)));
        calendar.set(1, Integer.parseInt(dateTimeStr.substring(0, dash1)));
        calendar.set(2, Integer.parseInt(dateTimeStr.substring(dash1 + 1, dash2)) - 1);
        calendar.set(5, Integer.parseInt(dateTimeStr.substring(dash2 + 1, dash3)));
        int hour = Integer.parseInt(dateTimeStr.substring(dash3 + 1, dash4));
        calendar.set(10, hour > 11 ? hour - 12 : hour);
        calendar.set(12, Integer.parseInt(dateTimeStr.substring(dash4 + 1, dash5)));
        calendar.set(13, Integer.parseInt(dash6 < 0 ? dateTimeStr.substring(dash5 + 1) : dateTimeStr.substring(dash5 + 1, dash6)));
        calendar.set(14, 0);
        calendar.set(9, hour > 11 ? 1 : 0);
        return calendar.getTime();
    }

    protected final Locale decodeLocale(String localeStr) {
        if (localeStr == null || localeStr.length() == 0) {
            return null;
        }
        int dash1 = localeStr.indexOf(45);
        if (dash1 < 0) {
            return new Locale(localeStr);
        }
        int dash2 = localeStr.indexOf(45, dash1 + 1);
        if (dash2 < 0) {
            return new Locale(localeStr.substring(0, dash1), localeStr.substring(dash1 + 1));
        }
        return new Locale(localeStr.substring(0, dash1), localeStr.substring(dash1 + 1, dash2), localeStr.substring(dash2 + 1));
    }

    protected final Date decodeTime(String timeStr) {
        if (timeStr == null || timeStr.length() == 0) {
            return null;
        }
        int dash1 = timeStr.indexOf(58);
        int dash2 = timeStr.indexOf(58, dash1 + 1);
        int dash3 = timeStr.indexOf(45, dash2 + 1);
        if (dash3 < 0) {
            dash3 = timeStr.indexOf(43, dash2 + 1);
        }
        Calendar calendar = null;
        calendar = dash3 < 0 ? Calendar.getInstance() : Calendar.getInstance(TimeZone.getTimeZone("GMT" + timeStr.substring(dash3)));
        int hour = Integer.parseInt(timeStr.substring(0, dash1));
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(10, hour > 11 ? hour - 12 : hour);
        calendar.set(12, Integer.parseInt(timeStr.substring(dash1 + 1, dash2)));
        calendar.set(13, Integer.parseInt(dash3 < 0 ? timeStr.substring(dash2 + 1) : timeStr.substring(dash2 + 1, dash3)));
        calendar.set(14, 0);
        calendar.set(9, hour > 11 ? 1 : 0);
        return calendar.getTime();
    }
}

