/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.xml;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.eclipse.vtp.framework.media.xml.MediaXMLContstants;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractEncoder
implements XMLReader,
MediaXMLContstants {
    private static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private final Set features = new HashSet();
    private final Map properties = new HashMap();
    private EntityResolver entityResolver = null;
    private DTDHandler dtdHandler = null;
    private ContentHandler contentHandler = null;
    private ErrorHandler errorHandler = null;

    protected AbstractEncoder() {
    }

    public final boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.features.contains(name);
    }

    public final void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (value) {
            this.features.add(name);
        } else {
            this.features.remove(name);
        }
    }

    public final Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.properties.get(name);
    }

    public final void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.properties.put(name, value);
    }

    public final void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public final EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public final void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    public final DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public final void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public final ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public final void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public final ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public final void parse(InputSource input) throws SAXException {
        this.encode();
    }

    public final void parse(String systemId) throws SAXException {
        this.encode();
    }

    public abstract void encode() throws SAXException;

    protected void encodeStartNamespace(String prefix, String uri, AttributesImpl atts) throws SAXException {
        if (!this.features.contains(NAMESPACE_PREFIXES_FEATURE)) {
            this.getContentHandler().startPrefixMapping(prefix, uri);
        } else {
            atts.addAttribute("", "xmlns:" + prefix, "xmlns:" + prefix, "CDATA", uri);
        }
    }

    protected void encodeEndNamespace(String prefix) throws SAXException {
        if (!this.features.contains(NAMESPACE_PREFIXES_FEATURE)) {
            this.getContentHandler().endPrefixMapping(prefix);
        }
    }

    protected String encodeDate(Date date) {
        if (date == null) {
            return "";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        TimeZone.getTimeZone("UTC");
        int tzOffset = calendar.getTimeZone().getOffset(date.getTime()) / 3600000;
        return String.valueOf(this.pad(calendar.get(1), 4)) + "-" + this.pad(calendar.get(2) + 1, 2) + "-" + this.pad(calendar.get(5), 2) + (tzOffset < 0 ? "-" + this.pad(Math.abs(tzOffset), 2) : "+" + this.pad(Math.abs(tzOffset), 2)) + ":00";
    }

    protected String encodeDateTime(Date dateTime) {
        if (dateTime == null) {
            return "";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateTime);
        int tzOffset = calendar.getTimeZone().getOffset(dateTime.getTime()) / 3600000;
        return String.valueOf(this.pad(calendar.get(1), 4)) + "-" + this.pad(calendar.get(2) + 1, 2) + "-" + this.pad(calendar.get(5), 2) + "T" + this.pad(calendar.get(9) == 1 ? calendar.get(10) + 12 : calendar.get(10), 2) + ":" + this.pad(calendar.get(12), 2) + ":" + this.pad(calendar.get(13), 2) + (tzOffset < 0 ? "-" + this.pad(Math.abs(tzOffset), 2) : "+" + this.pad(tzOffset, 2)) + ":00";
    }

    protected String encodeLocale(Locale locale) {
        return locale == null ? "" : locale.toString().replace('_', '-');
    }

    protected String encodeTime(Date time) {
        if (time == null) {
            return "";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        int tzOffset = calendar.getTimeZone().getOffset(time.getTime()) / 3600000;
        return String.valueOf(this.pad(calendar.get(9) == 1 ? calendar.get(10) + 12 : calendar.get(10), 2)) + ":" + this.pad(calendar.get(12), 2) + ":" + this.pad(calendar.get(13), 2) + (tzOffset < 0 ? "-" + this.pad(Math.abs(tzOffset), 2) : "+" + this.pad(Math.abs(tzOffset), 2)) + ":00";
    }

    private String pad(int number, int minimum) {
        String result = String.valueOf(number);
        while (result.length() < minimum) {
            result = "0" + result;
        }
        return result;
    }
}

