/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.xml;

import org.eclipse.vtp.framework.media.grammars.CharactersGrammar;
import org.eclipse.vtp.framework.media.grammars.FileGrammar;
import org.eclipse.vtp.framework.media.grammars.Grammar;
import org.eclipse.vtp.framework.media.grammars.ReferenceGrammar;
import org.eclipse.vtp.framework.media.grammars.TextGrammar;
import org.eclipse.vtp.framework.media.xml.AbstractEncoder;
import org.eclipse.vtp.framework.media.xml.SAXExceptionWrapper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class GrammarEncoder
extends AbstractEncoder
implements Grammar.Visitor {
    private static final Attributes EMPTY_ATTS = new AttributesImpl();
    private final String referenceContainer;
    private Grammar source = null;
    private final AttributesImpl atts = new AttributesImpl();

    public GrammarEncoder(String referenceContainer) {
        this.referenceContainer = referenceContainer == null ? "" : referenceContainer;
    }

    public GrammarEncoder(String referenceContainer, Grammar source) {
        this(referenceContainer);
        this.source = source;
    }

    public Grammar getSource() {
        return this.source;
    }

    public void setSource(Grammar source) {
        this.source = source;
    }

    public void encode() throws SAXException {
        if (this.source == null) {
            return;
        }
        if (this.getContentHandler() == null) {
            return;
        }
        try {
            this.source.accept(this);
        }
        catch (SAXExceptionWrapper e) {
            throw (SAXException)e.getCause();
        }
    }

    public Object charactersGrammar(CharactersGrammar charactersGrammar) {
        try {
            this.getContentHandler().startElement("", "characters", "characters", EMPTY_ATTS);
            this.getContentHandler().characters(charactersGrammar.getCharacters().toCharArray(), 0, charactersGrammar.getCharacters().length());
            this.getContentHandler().endElement("", "characters", "characters");
        }
        catch (SAXException e) {
            throw new SAXExceptionWrapper(e);
        }
        return null;
    }

    public Object fileGrammar(FileGrammar fileGrammar) {
        try {
            this.getContentHandler().startElement("", "file", "file", EMPTY_ATTS);
            this.getContentHandler().characters(fileGrammar.getPath().toCharArray(), 0, fileGrammar.getPath().length());
            this.getContentHandler().endElement("", "file", "file");
        }
        catch (SAXException e) {
            throw new SAXExceptionWrapper(e);
        }
        return null;
    }

    public Object referenceGrammar(ReferenceGrammar referenceGrammar) {
        try {
            if (referenceGrammar.getContainer().length() > 0) {
                this.atts.addAttribute("", this.referenceContainer, this.referenceContainer, "CDATA", referenceGrammar.getContainer());
            }
            this.getContentHandler().startElement("", "reference", "reference", this.atts);
            this.atts.clear();
            this.getContentHandler().characters(referenceGrammar.getName().toCharArray(), 0, referenceGrammar.getName().length());
            this.getContentHandler().endElement("", "reference", "reference");
        }
        catch (SAXException e) {
            throw new SAXExceptionWrapper(e);
        }
        return null;
    }

    public Object textGrammar(TextGrammar textGrammar) {
        try {
            this.getContentHandler().startElement("", "text", "text", EMPTY_ATTS);
            this.getContentHandler().characters(textGrammar.getContent().toCharArray(), 0, textGrammar.getContent().length());
            this.getContentHandler().endElement("", "text", "text");
        }
        catch (SAXException e) {
            throw new SAXExceptionWrapper(e);
        }
        return null;
    }
}

