/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.xml;

import java.util.Iterator;
import org.eclipse.vtp.framework.media.language.LanguageCategory;
import org.eclipse.vtp.framework.media.language.LanguageEntry;
import org.eclipse.vtp.framework.media.language.LanguageGroup;
import org.eclipse.vtp.framework.media.language.MediaLanguage;
import org.eclipse.vtp.framework.media.xml.AbstractEncoder;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class LanguageEncoder
extends AbstractEncoder {
    private MediaLanguage source = null;

    public LanguageEncoder() {
    }

    public LanguageEncoder(MediaLanguage source) {
        this.setSource(source);
    }

    public void setSource(MediaLanguage source) {
        this.source = source;
    }

    public void encode() throws SAXException {
        if (this.source == null) {
            return;
        }
        ContentHandler handler = this.getContentHandler();
        if (handler == null) {
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        handler.startDocument();
        this.encodeStartNamespace("language", "http://eclipse.org/vtp/xsd/openVXML/media/language#1.0", atts);
        atts.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", "CDATA", this.encodeLocale(this.source.getLocale()));
        handler.startElement("http://eclipse.org/vtp/xsd/openVXML/media/language#1.0", "descriptor", "language:descriptor", atts);
        atts.clear();
        handler.startElement("", "translator", "translator", atts);
        handler.characters(this.source.getTranslator().toCharArray(), 0, this.source.getTranslator().length());
        handler.endElement("", "translator", "translator");
        handler.startElement("", "prompts", "prompts", atts);
        this.encodeCategory(handler, atts, this.source.getPromptsCategory());
        handler.endElement("", "prompts", "prompts");
        handler.startElement("", "grammars", "grammars", atts);
        this.encodeCategory(handler, atts, this.source.getGrammarsCategory());
        handler.endElement("", "grammars", "grammars");
        handler.endElement("http://eclipse.org/vtp/xsd/openVXML/media/language#1.0", "descriptor", "language:descriptor");
        this.encodeEndNamespace("language");
        handler.endDocument();
    }

    private void encodeCategory(ContentHandler handler, AttributesImpl atts, LanguageCategory category) throws SAXException {
        Iterator i = category.getGroups().iterator();
        while (i.hasNext()) {
            LanguageGroup group = (LanguageGroup)i.next();
            atts.addAttribute("", "name", "name", "CDATA", group.getName());
            handler.startElement("", "group", "group", atts);
            atts.clear();
            Iterator j = group.getEntries().iterator();
            while (j.hasNext()) {
                LanguageEntry entry = (LanguageEntry)j.next();
                atts.addAttribute("", "name", "name", "CDATA", entry.getName());
                handler.startElement("", "entry", "entry", atts);
                atts.clear();
                handler.characters(entry.getContent().toCharArray(), 0, entry.getContent().length());
                handler.endElement("", "entry", "entry");
            }
            handler.endElement("", "group", "group");
        }
    }
}

