/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.xml;

import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.eclipse.vtp.framework.media.binding.MediaBinding;
import org.eclipse.vtp.framework.media.files.MediaFiles;
import org.eclipse.vtp.framework.media.language.MediaLanguage;
import org.eclipse.vtp.framework.media.library.MediaLibrary;
import org.eclipse.vtp.framework.media.persona.MediaPersona;
import org.eclipse.vtp.framework.media.xml.BindingDecoder;
import org.eclipse.vtp.framework.media.xml.BindingEncoder;
import org.eclipse.vtp.framework.media.xml.FilesDecoder;
import org.eclipse.vtp.framework.media.xml.FilesEncoder;
import org.eclipse.vtp.framework.media.xml.LanguageDecoder;
import org.eclipse.vtp.framework.media.xml.LanguageEncoder;
import org.eclipse.vtp.framework.media.xml.LibraryDecoder;
import org.eclipse.vtp.framework.media.xml.LibraryEncoder;
import org.eclipse.vtp.framework.media.xml.PersonaDecoder;
import org.eclipse.vtp.framework.media.xml.PersonaEncoder;
import org.xml.sax.InputSource;

public final class MediaXML {
    public static MediaBinding loadBinding(Source source) throws IOException {
        BindingDecoder decoder = new BindingDecoder();
        MediaXML.transform(source, new SAXResult(decoder));
        return decoder.getResult();
    }

    public static void saveBinding(MediaBinding source, Result result) throws IOException {
        MediaXML.transform(new SAXSource(new BindingEncoder(source), new InputSource()), result);
    }

    public static MediaFiles loadFiles(Source source) throws IOException {
        FilesDecoder decoder = new FilesDecoder();
        MediaXML.transform(source, new SAXResult(decoder));
        return decoder.getResult();
    }

    public static void saveFiles(MediaFiles source, Result result) throws IOException {
        MediaXML.transform(new SAXSource(new FilesEncoder(source), new InputSource()), result);
    }

    public static MediaLanguage loadLanguage(Source source) throws IOException {
        LanguageDecoder decoder = new LanguageDecoder();
        MediaXML.transform(source, new SAXResult(decoder));
        return decoder.getResult();
    }

    public static void saveLanguage(MediaLanguage source, Result result) throws IOException {
        MediaXML.transform(new SAXSource(new LanguageEncoder(source), new InputSource()), result);
    }

    public static MediaLibrary loadLibrary(Source source) throws IOException {
        LibraryDecoder decoder = new LibraryDecoder();
        MediaXML.transform(source, new SAXResult(decoder));
        return decoder.getResult();
    }

    public static void saveLibrary(MediaLibrary source, Result result) throws IOException {
        MediaXML.transform(new SAXSource(new LibraryEncoder(source), new InputSource()), result);
    }

    public static MediaPersona loadPersona(Source source) throws IOException {
        PersonaDecoder decoder = new PersonaDecoder();
        MediaXML.transform(source, new SAXResult(decoder));
        return decoder.getResult();
    }

    public static void savePersona(MediaPersona source, Result result) throws IOException {
        MediaXML.transform(new SAXSource(new PersonaEncoder(source), new InputSource()), result);
    }

    private static void transform(Source source, Result result) throws IOException {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.newTransformer().transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            IOException ioe = new IOException("Failed to create XML transformer");
            ioe.initCause(e);
            throw ioe;
        }
        catch (TransformerException e) {
            IOException ioe = new IOException("Failed to process XML document");
            ioe.initCause(e);
            throw ioe;
        }
    }
}

