/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.xml;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.vtp.framework.media.persona.MediaPersona;
import org.eclipse.vtp.framework.media.persona.PersonaGrammarEntry;
import org.eclipse.vtp.framework.media.persona.PersonaGrammarGroup;
import org.eclipse.vtp.framework.media.persona.PersonaGrammars;
import org.eclipse.vtp.framework.media.persona.PersonaPromptEntry;
import org.eclipse.vtp.framework.media.persona.PersonaPromptGroup;
import org.eclipse.vtp.framework.media.persona.PersonaPrompts;
import org.eclipse.vtp.framework.media.xml.AbstractDecoder;
import org.eclipse.vtp.framework.media.xml.GrammarDecoder;
import org.eclipse.vtp.framework.media.xml.PromptDecoder;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PersonaDecoder
extends AbstractDecoder {
    private static final Set ENTRY_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("characters", "file", "reference", "text")));
    private final PromptDecoder promptDecoder = new PromptDecoder("group");
    private final GrammarDecoder grammarDecoder = new GrammarDecoder("group");
    private ContentHandler currentDecoder = null;
    private MediaPersona result = null;

    public void startDocument() throws SAXException {
        this.result = null;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("http://eclipse.org/vtp/xsd/openVXML/media/persona#1.0".equals(uri) && "descriptor".equals(localName) || "persona:descriptor".equals(qName)) {
            this.push(new MediaPersona(atts.getValue("language")));
        } else if ("".equals(uri)) {
            if ("prompts".equals(localName) || "prompts".equals(qName)) {
                this.push(new PersonaPrompts());
            } else if ("grammars".equals(localName) || "grammars".equals(qName)) {
                this.push(new PersonaGrammars());
            } else if ("group".equals(localName) || "group".equals(qName)) {
                this.push(this.peek() instanceof PersonaPrompts ? new PersonaPromptGroup(atts.getValue("name")) : new PersonaGrammarGroup(atts.getValue("name")));
            } else if ("entry".equals(localName) || "entry".equals(qName)) {
                this.push(this.peek() instanceof PersonaPromptGroup ? new PersonaPromptEntry(atts.getValue("name")) : new PersonaGrammarEntry(atts.getValue("name")));
            } else if (ENTRY_NAMES.contains(localName) || ENTRY_NAMES.contains(qName)) {
                this.currentDecoder = this.peek() instanceof PersonaPromptEntry ? this.promptDecoder : this.grammarDecoder;
                this.currentDecoder.startElement(uri, localName, qName, atts);
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentDecoder == null) {
            super.characters(ch, start, length);
        } else {
            this.currentDecoder.characters(ch, start, length);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("http://eclipse.org/vtp/xsd/openVXML/media/persona#1.0".equals(uri) && "descriptor".equals(localName) || "persona:descriptor".equals(qName)) {
            this.result = (MediaPersona)this.pop();
        } else if ("".equals(uri)) {
            if ("prompts".equals(localName) || "prompts".equals(qName)) {
                PersonaPrompts prompts = (PersonaPrompts)this.pop();
                ((MediaPersona)this.peek()).setPrompts(prompts);
            } else if ("grammars".equals(localName) || "grammars".equals(qName)) {
                PersonaGrammars grammars = (PersonaGrammars)this.pop();
                ((MediaPersona)this.peek()).setGrammars(grammars);
            } else if ("group".equals(localName) || "group".equals(qName)) {
                if (this.peek() instanceof PersonaPromptGroup) {
                    PersonaPromptGroup group = (PersonaPromptGroup)this.pop();
                    ((PersonaPrompts)this.peek()).addGroup(group);
                } else {
                    PersonaGrammarGroup group = (PersonaGrammarGroup)this.pop();
                    ((PersonaGrammars)this.peek()).addGroup(group);
                }
            } else if ("entry".equals(localName) || "entry".equals(qName)) {
                if (this.peek() instanceof PersonaPromptEntry) {
                    PersonaPromptEntry entry = (PersonaPromptEntry)this.pop();
                    ((PersonaPromptGroup)this.peek()).addEntry(entry);
                } else {
                    PersonaGrammarEntry entry = (PersonaGrammarEntry)this.pop();
                    ((PersonaGrammarGroup)this.peek()).addEntry(entry);
                }
            } else if (ENTRY_NAMES.contains(localName) || ENTRY_NAMES.contains(qName)) {
                this.currentDecoder.endElement(uri, localName, qName);
                if (this.peek() instanceof PersonaPromptEntry) {
                    ((PersonaPromptEntry)this.peek()).add(this.promptDecoder.getResult());
                } else {
                    ((PersonaGrammarEntry)this.peek()).add(this.grammarDecoder.getResult());
                }
                this.currentDecoder = null;
            }
        }
    }

    public MediaPersona getResult() {
        return this.result;
    }
}

