/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.xml;

import java.math.BigDecimal;
import java.util.Currency;
import org.eclipse.vtp.framework.media.prompts.CharactersPrompt;
import org.eclipse.vtp.framework.media.prompts.DatePrompt;
import org.eclipse.vtp.framework.media.prompts.DateTimePrompt;
import org.eclipse.vtp.framework.media.prompts.DigitsPrompt;
import org.eclipse.vtp.framework.media.prompts.FilePrompt;
import org.eclipse.vtp.framework.media.prompts.MoneyPrompt;
import org.eclipse.vtp.framework.media.prompts.NumberPrompt;
import org.eclipse.vtp.framework.media.prompts.OrdinalPrompt;
import org.eclipse.vtp.framework.media.prompts.Prompt;
import org.eclipse.vtp.framework.media.prompts.ReferencePrompt;
import org.eclipse.vtp.framework.media.prompts.TextPrompt;
import org.eclipse.vtp.framework.media.prompts.TimePrompt;
import org.eclipse.vtp.framework.media.prompts.VariablePrompt;
import org.eclipse.vtp.framework.media.xml.AbstractDecoder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PromptDecoder
extends AbstractDecoder {
    private final String refernceContainer;
    private Prompt result = null;

    public PromptDecoder(String refernceContainer) {
        this.refernceContainer = refernceContainer == null ? "" : refernceContainer;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.result = null;
        if ("characters".equals(localName) || "characters".equals(qName)) {
            this.push(new CharactersPrompt());
        } else if ("date".equals(localName) || "date".equals(qName)) {
            this.push(new DatePrompt());
        } else if ("date-time".equals(localName) || "date-time".equals(qName)) {
            this.push(new DateTimePrompt(null, "true".equalsIgnoreCase(atts.getValue("timezone"))));
        } else if ("digits".equals(localName) || "digits".equals(qName)) {
            this.push(new DigitsPrompt());
        } else if ("file".equals(localName) || "file".equals(qName)) {
            this.push(new FilePrompt());
        } else if ("money".equals(localName) || "money".equals(qName)) {
            this.push(new MoneyPrompt(null, Currency.getInstance(atts.getValue("currency"))));
        } else if ("number".equals(localName) || "number".equals(qName)) {
            this.push(new NumberPrompt());
        } else if ("ordinal".equals(localName) || "ordinal".equals(qName)) {
            this.push(new OrdinalPrompt());
        } else if ("reference".equals(localName) || "reference".equals(qName)) {
            this.push(new ReferencePrompt("", atts.getValue(this.refernceContainer)));
        } else if ("text".equals(localName) || "text".equals(qName)) {
            this.push(new TextPrompt());
        } else if ("time".equals(localName) || "time".equals(qName)) {
            this.push(new TimePrompt(null, "true".equalsIgnoreCase(atts.getValue("timezone"))));
        } else if ("variable".equals(localName) || "variable".equals(qName)) {
            this.push(new VariablePrompt());
            if (atts.getIndex("type") >= 0) {
                ((VariablePrompt)this.peek()).setType(VariablePrompt.getTypeByName(atts.getValue("type")));
            }
        } else {
            return;
        }
        this.startCollectingCharacters();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("characters".equals(localName) || "characters".equals(qName)) {
            ((CharactersPrompt)this.peek()).setCharacters(this.stopCollectingCharacters());
        } else if ("date".equals(localName) || "date".equals(qName)) {
            ((DatePrompt)this.peek()).setValue(this.decodeDate(this.stopCollectingCharacters()));
        } else if ("date-time".equals(localName) || "date-time".equals(qName)) {
            ((DateTimePrompt)this.peek()).setValue(this.decodeDateTime(this.stopCollectingCharacters()));
        } else if ("digits".equals(localName) || "digits".equals(qName)) {
            ((DigitsPrompt)this.peek()).setContent(this.stopCollectingCharacters());
        } else if ("file".equals(localName) || "file".equals(qName)) {
            ((FilePrompt)this.peek()).setPath(this.stopCollectingCharacters());
        } else if ("money".equals(localName) || "money".equals(qName)) {
            ((MoneyPrompt)this.peek()).setValue(new BigDecimal(this.stopCollectingCharacters()));
        } else if ("number".equals(localName) || "number".equals(qName)) {
            ((NumberPrompt)this.peek()).setValue(Integer.parseInt(this.stopCollectingCharacters()));
        } else if ("ordinal".equals(localName) || "ordinal".equals(qName)) {
            ((OrdinalPrompt)this.peek()).setValue(Integer.parseInt(this.stopCollectingCharacters()));
        } else if ("reference".equals(localName) || "reference".equals(qName)) {
            ((ReferencePrompt)this.peek()).setName(this.stopCollectingCharacters());
        } else if ("text".equals(localName) || "text".equals(qName)) {
            ((TextPrompt)this.peek()).setContent(this.stopCollectingCharacters());
        } else if ("time".equals(localName) || "time".equals(qName)) {
            ((TimePrompt)this.peek()).setValue(this.decodeTime(this.stopCollectingCharacters()));
        } else if ("variable".equals(localName) || "variable".equals(qName)) {
            ((VariablePrompt)this.peek()).setVariable(this.stopCollectingCharacters());
        } else {
            return;
        }
        this.result = (Prompt)this.pop();
    }

    public Prompt getResult() {
        return this.result;
    }
}

