/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.widgets.vxml;

import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.framework.widgets.vxml.CompoundOutput;

public class AudioOutput
extends CompoundOutput {
    protected String audioFileURI = null;

    public AudioOutput(String audioFileURI) {
        if (audioFileURI == null) {
            throw new IllegalArgumentException("Audio file URI cannot be null.");
        }
        if (audioFileURI.equals("")) {
            throw new IllegalArgumentException("Audio file URI cannot be empty.");
        }
        this.audioFileURI = audioFileURI;
    }

    public String getAudioFileURI() {
        return this.audioFileURI;
    }

    public void writeWidget(PrintStream out, int indent) throws IOException {
        this.writeStartTagEntry(out, indent);
        this.writeAttributes(out);
        this.writeStartTagExit(out, indent);
        super.writeWidget(out, indent);
        this.writeEndTag(out, indent);
    }

    protected void writeAttributes(PrintStream out) throws IOException {
        out.print(" src='");
        out.print(XMLUtilities.encodeAttribute((String)this.audioFileURI));
        out.print("'");
    }

    protected void writeStartTagExit(PrintStream out, int indent) throws IOException {
        out.print(">");
    }

    protected void writeStartTagEntry(PrintStream out, int indent) throws IOException {
        out.print("<audio");
    }

    protected void writeEndTag(PrintStream out, int indent) throws IOException {
        out.print("</audio>");
    }

    public boolean equals(Object obj) {
        return obj instanceof AudioOutput && this.audioFileURI.equals(((AudioOutput)obj).audioFileURI);
    }
}

