/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.widgets.vxml;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.vtp.framework.util.HashtableUtilities;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.framework.widgets.vxml.EventHandler;
import org.eclipse.vtp.framework.widgets.vxml.VXMLWidget;

public abstract class Dialog
extends VXMLWidget {
    public static int SCOPE_DOCUMENT = 0;
    public static int SCOPE_DIALOG = 1;
    public static String[] SCOPE_DESCRIPTORS = new String[]{"document", "dialog"};
    protected String id;
    protected int scope;
    protected Hashtable properties;
    protected Vector eventHandlers;

    public Dialog(String id) {
        this.init(id, SCOPE_DIALOG);
    }

    public Dialog(String id, int scope) {
        this.init(id, scope);
    }

    private void init(String id, int scope) {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null.");
        }
        if (id.equals("")) {
            throw new IllegalArgumentException("Id cannot be empty.");
        }
        if (scope < 0 || scope > 1) {
            throw new IllegalArgumentException("Scope must be 0 || 1.");
        }
        this.id = id;
        this.scope = scope;
        this.properties = new Hashtable();
        this.eventHandlers = new Vector();
    }

    public String getId() {
        return this.id;
    }

    public int getScope() {
        return this.scope;
    }

    public void setId(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null.");
        }
        if (id.equals("")) {
            throw new IllegalArgumentException("Id cannot be empty.");
        }
        this.id = id;
    }

    public void setScope(int scope) {
        if (scope < 0 || scope > 1) {
            throw new IllegalArgumentException("Scope must be 0 || 1.");
        }
        this.scope = scope;
    }

    public String getProperty(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null.");
        }
        return (String)this.properties.get(key);
    }

    public void setProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null.");
        }
        this.properties.put(key, value);
    }

    public void addEventHandler(EventHandler eventHandler) {
        if (eventHandler == null) {
            throw new IllegalArgumentException("Cannot add null event handler.");
        }
        this.eventHandlers.addElement(eventHandler);
    }

    protected void writeAttributes(PrintStream out) throws IOException {
        out.print(" id='");
        out.print(XMLUtilities.encodeAttribute((String)this.id));
        out.print("' scope='");
        out.print(XMLUtilities.encodeAttribute((String)SCOPE_DESCRIPTORS[this.scope]));
        out.print("'");
    }

    protected void writeEventHandlers(PrintStream out, int indent) throws IOException {
        int i = 0;
        while (i < this.eventHandlers.size()) {
            ((EventHandler)this.eventHandlers.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
    }

    protected void writeChildren(PrintStream out, int indent) throws IOException {
        String[] keys = HashtableUtilities.getKeys((Hashtable)this.properties);
        int i = 0;
        while (i < keys.length) {
            String value = (String)this.properties.get(keys[i]);
            out.println("<property name='" + keys[i] + "' value='" + value + "'/>");
            ++i;
        }
    }
}

