/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.widgets.vxml;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.framework.widgets.vxml.Action;
import org.eclipse.vtp.framework.widgets.vxml.If;
import org.eclipse.vtp.framework.widgets.vxml.VXMLWidget;
import org.eclipse.vtp.framework.widgets.vxml.Variable;

public class Filled
extends VXMLWidget {
    public static int MODE_ANY = 0;
    public static int MODE_ALL = 1;
    public static String[] MODE_DESCRIPTORS = new String[]{"any", "all"};
    protected int mode = -1;
    protected Vector nameList = new Vector();
    protected Vector actions = new Vector();
    protected Vector variables = new Vector();

    public Filled() {
        this.init(MODE_ANY, null);
    }

    public Filled(int mode) {
        this.init(mode, null);
    }

    public Filled(String[] names) {
        this.init(MODE_ANY, names);
    }

    public Filled(int mode, String[] names) {
        this.init(mode, names);
    }

    private void init(int mode, String[] names) {
        if (mode < 0 || mode > 1) {
            throw new IllegalArgumentException("Mode must be 0 or 1.");
        }
        this.mode = mode;
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                this.nameList.addElement(names[i]);
                ++i;
            }
        }
    }

    public void addName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot add null name.");
        }
        this.nameList.addElement(name);
    }

    public void addAction(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Cannot add null action.");
        }
        this.actions.addElement(action);
    }

    public void addIfClause(If ifClause) {
        if (ifClause == null) {
            throw new IllegalArgumentException("Cannot add null if clause.");
        }
        this.actions.addElement(ifClause);
    }

    public void addVariable(Variable variable) {
        if (variable == null) {
            throw new IllegalArgumentException("Cannot add null variable.");
        }
        this.variables.addElement(variable);
    }

    protected void writeAttributes(PrintStream out) throws IOException {
        if (this.mode > 0) {
            out.print(" mode='");
            out.print(XMLUtilities.encodeAttribute((String)MODE_DESCRIPTORS[this.mode]));
            out.print("'");
        }
        if (this.nameList.size() > 0) {
            out.print(" namelist='");
            int i = 0;
            while (i < this.nameList.size()) {
                if (i != 0) {
                    out.print(" ");
                }
                out.print(XMLUtilities.encodeAttribute((String)((String)this.nameList.elementAt(i))));
                ++i;
            }
            out.print("'");
        }
    }

    protected void writeChildren(PrintStream out, int indent) throws IOException {
        int i = 0;
        while (i < this.variables.size()) {
            ((Variable)this.variables.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
        i = 0;
        while (i < this.actions.size()) {
            ((VXMLWidget)this.actions.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
    }

    protected void writeEndTag(PrintStream out, int indent) throws IOException {
        out.println("</filled>");
    }

    protected void writeStartTagEntry(PrintStream out, int indent) throws IOException {
        out.print("<filled");
    }

    protected void writeStartTagExit(PrintStream out, int indent) throws IOException {
        out.println(">");
    }
}

