/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.widgets.vxml;

import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.vtp.framework.widgets.vxml.Action;
import org.eclipse.vtp.framework.widgets.vxml.Output;

public class Prompt
extends Action {
    protected Output output = null;
    protected boolean bargeIn = true;
    protected String language = "en-US";
    private String timeout = null;

    public Prompt(Output output) {
        this.init(output);
    }

    public Prompt(Output output, boolean bargeIn) {
        this.init(output);
        this.bargeIn = bargeIn;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public Output getOutput() {
        return this.output;
    }

    private void init(Output output) {
        if (output == null) {
            throw new IllegalArgumentException("Output cannot be null.");
        }
        this.output = output;
    }

    public void setOutput(Output output) {
        if (output == null) {
            throw new IllegalArgumentException("Output cannot be null.");
        }
        this.output = output;
    }

    protected void writeEndTag(PrintStream out, int indent) throws IOException {
        out.println("</prompt>");
    }

    protected void writeStartTagEntry(PrintStream out, int indent) throws IOException {
        out.print("<prompt");
    }

    protected void writeStartTagExit(PrintStream out, int indent) throws IOException {
        out.print(">");
    }

    protected void writeChildren(PrintStream out, int indent) throws IOException {
        this.output.writeWidget(out, indent + 1);
    }

    protected void writeAttributes(PrintStream out) throws IOException {
        out.print(" bargein='" + (this.bargeIn ? "true" : "false") + "'");
        out.print(" xml:lang='" + this.language + "'");
        if (this.timeout != null) {
            out.print(" timeout=\"" + this.timeout + "\"");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Prompt)) {
            return false;
        }
        Prompt prompt = (Prompt)obj;
        return this.output.equals(prompt.output) && this.bargeIn == prompt.bargeIn;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }
}

